/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.Random;
import org.refcodes.data.PaddingChar;
import org.refcodes.data.Text;
import org.refcodes.generator.IdGenerator;
import org.refcodes.numerical.NumericalUtility;

public class UniqueIdGenerator
implements IdGenerator {
    private static final int UUID_LENGTH = 36;
    private int _idLength;
    private static byte[] IP_ADDRESS = new byte[2];
    private static long COUNTER = 0L;
    private static long SEED;

    public static void initSeed() {
        SEED = new Random().nextLong();
        try {
            byte[] byArray = InetAddress.getLocalHost().getAddress();
            UniqueIdGenerator.IP_ADDRESS[0] = byArray[byArray.length - 2];
            UniqueIdGenerator.IP_ADDRESS[1] = byArray[byArray.length - 1];
        }
        catch (UnknownHostException unknownHostException) {
            new Random().nextBytes(IP_ADDRESS);
        }
    }

    public UniqueIdGenerator() {
        this(36);
    }

    public UniqueIdGenerator(int n) {
        this._idLength = n;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public String next() {
        int n;
        String string = null;
        string = Base64.getEncoder().encodeToString(IP_ADDRESS);
        if (this._idLength <= (string = string.replaceAll("" + PaddingChar.BASE64.getChar(), "")).length()) {
            throw new IllegalStateException("The desired length of <" + this._idLength + "> is too short as the prefix \"" + string + "\" has already a length of <" + string.length());
        }
        Long l = System.currentTimeMillis();
        String string2 = null;
        string2 = Base64.getEncoder().encodeToString(NumericalUtility.toBytes((long)l));
        string2 = string2.replaceAll("" + PaddingChar.BASE64.getChar(), "");
        String string3 = null;
        while (string3 == null || string3.length() == 0) {
            string3 = Base64.getEncoder().encodeToString(NumericalUtility.toBytes((long)SEED++));
            if ((string3 = string3.replaceAll("" + PaddingChar.BASE64.getChar(), "")) != null && string3.length() != 0) continue;
            UniqueIdGenerator.initSeed();
        }
        if (this._idLength <= 4) {
            string = "";
        }
        int n2 = 4;
        if (this._idLength <= 6) {
            n2 -= 7 - this._idLength;
        }
        if (string3.length() > n2) {
            string3 = string3.substring(string3.length() - n2);
        }
        if ((n = this._idLength - string3.length() - string.length()) < 0) {
            throw new IllegalStateException("Cannot create an TID of length <" + this._idLength + "> as we are short of <" + Math.abs(n) + "> digits; enlarge your length accordinbgly.");
        }
        if (string2.length() >= n) {
            int n3 = string2.length() - n;
            return string + string3 + string2.substring(n3);
        }
        String string4 = Base64.getEncoder().encodeToString(NumericalUtility.toBytes((long)COUNTER++));
        if ((string4 = string4.replaceAll("" + PaddingChar.BASE64.getChar(), "")).length() != n) {
            if (string4.length() > n) {
                string4 = string4.substring(0, n);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string4);
                for (int i = 0; i < n - string4.length(); ++i) {
                    stringBuffer.append('0');
                }
                string4 = stringBuffer.toString();
            }
        }
        return string + string3 + string2 + string4;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    static {
        UniqueIdGenerator.initSeed();
    }
}

