/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.refcodes.generator.Generator;
import org.refcodes.mixin.DecorateeAccessor;

public class ThreadBufferedGeneratorDecorator<T>
implements Generator<T>,
DecorateeAccessor<Generator<T>> {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private ThreadLocal<List<T>> _threadBuffer = new ThreadLocal();
    private Generator<T> _decoratee;
    private int _bufferSize;
    private boolean _pause = false;

    public ThreadBufferedGeneratorDecorator(Generator<T> generator) {
        this(generator, 1024);
    }

    public ThreadBufferedGeneratorDecorator(Generator<T> generator, int n) {
        this._decoratee = generator;
        this._bufferSize = n;
    }

    @Override
    public boolean hasNext() {
        return !this.getLocalBuffer().isEmpty();
    }

    @Override
    public T next() {
        List<T> list = this.getLocalBuffer();
        if (!list.isEmpty()) {
            return list.remove(0);
        }
        throw new NoSuchElementException("No more elements left in the underlying generator <" + this._decoratee + ">!");
    }

    @Override
    public void remove() {
        List<T> list = this.getLocalBuffer();
        if (!list.isEmpty()) {
            list.remove(0);
        } else {
            this._decoratee.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> getLocalBuffer() {
        List<T> list = this._threadBuffer.get();
        if (list == null || list.isEmpty()) {
            if (list == null) {
                list = new ArrayList<T>();
                this._threadBuffer.set(list);
            }
            if (!this._pause) {
                ThreadBufferedGeneratorDecorator threadBufferedGeneratorDecorator = this;
                synchronized (threadBufferedGeneratorDecorator) {
                    for (int i = 0; i < this._bufferSize && this._decoratee.hasNext(); ++i) {
                        list.add(this._decoratee.next());
                    }
                }
            }
        }
        return list;
    }

    public void pauseBufferRefill() {
        this._pause = true;
    }

    public void enableBufferRefill() {
        this._pause = false;
    }

    public Generator<T> getDecoratee() {
        return this._decoratee;
    }
}

