/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.refcodes.generator.Generator;
import org.refcodes.generator.SeriesMonitor;

public class SeriesMonitorDecorator<T>
implements SeriesMonitor<T> {
    private Generator<T> _decoratee;
    private List<T> _generated = new ArrayList<T>();
    private List<Boolean> _processed = new ArrayList<Boolean>();
    private T _lastProcessed = null;

    public SeriesMonitorDecorator(Generator<T> generator) {
        this._decoratee = generator;
    }

    @Override
    public void remove() {
        this._decoratee.remove();
    }

    @Override
    public boolean hasNext() {
        return this._decoratee.hasNext();
    }

    @Override
    public T next() {
        T t = this._decoratee.next();
        this._generated.add(t);
        this._processed.add(false);
        return t;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> consumer) {
        this._decoratee.forEachRemaining(consumer);
    }

    @Override
    public boolean markAsProcessed(T t) {
        int n = this._generated.indexOf(t);
        if (n != -1) {
            this._processed.set(n, true);
        }
        Iterator<Boolean> iterator = this._processed.iterator();
        while (iterator.hasNext() && iterator.next().booleanValue()) {
            this._lastProcessed = this._generated.remove(0);
            iterator.remove();
        }
        return n != -1;
    }

    @Override
    public T lastProcessed() {
        return this._lastProcessed;
    }

    public void clear() {
        this._generated.clear();
        this._processed.clear();
    }

    boolean isEmpty() {
        return this._generated.isEmpty() & this._processed.isEmpty();
    }
}

