/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import java.io.Flushable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.refcodes.component.BidirectionalConnectionOpenable;
import org.refcodes.component.Closable;
import org.refcodes.component.CloseException;
import org.refcodes.component.Configurable;
import org.refcodes.component.ConfigureException;
import org.refcodes.component.ConnectionOpenable;
import org.refcodes.component.Decomposable;
import org.refcodes.component.DecomposeException;
import org.refcodes.component.DestroyException;
import org.refcodes.component.Destroyable;
import org.refcodes.component.DisposeException;
import org.refcodes.component.Initializable;
import org.refcodes.component.InitializeException;
import org.refcodes.component.Openable;
import org.refcodes.component.Pausable;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResetException;
import org.refcodes.component.Resumable;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.Startable;
import org.refcodes.component.StopException;
import org.refcodes.component.Stoppable;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.mixin.Disposable;
import org.refcodes.mixin.Resetable;

public final class ComponentUtility {
    private static final CallableFactory<Initializable> _initializeCallableFactoryImpl = new CallableFactory<Initializable>(){

        @Override
        public Callable<Void> toCallable(Initializable aComponent, Object ... aArguments) {
            return new InitializeCallable(aComponent);
        }

        @Override
        public Class<Initializable> getType() {
            return Initializable.class;
        }
    };
    private static final CallableFactory<Configurable> _configureCallableFactoryImpl = new CallableFactory<Configurable>(){

        @Override
        public Callable<Void> toCallable(Configurable aComponent, Object ... aArguments) {
            return new ConfigureCallable<Object>(aComponent, aArguments[0]);
        }

        @Override
        public Class<Configurable> getType() {
            return Configurable.class;
        }
    };
    private static final CallableFactory<Startable> _startCallableFactoryImpl = new CallableFactory<Startable>(){

        @Override
        public Callable<Void> toCallable(Startable aComponent, Object ... aArguments) {
            return new StartCallable(aComponent);
        }

        @Override
        public Class<Startable> getType() {
            return Startable.class;
        }
    };
    private static final CallableFactory<Pausable> _pauseCallableFactoryImpl = new CallableFactory<Pausable>(){

        @Override
        public Callable<Void> toCallable(Pausable aComponent, Object ... aArguments) {
            return new PauseCallable(aComponent);
        }

        @Override
        public Class<Pausable> getType() {
            return Pausable.class;
        }
    };
    private static final CallableFactory<Resumable> _resumeCallableFactoryImpl = new CallableFactory<Resumable>(){

        @Override
        public Callable<Void> toCallable(Resumable aComponent, Object ... aArguments) {
            return new ResumeCallable(aComponent);
        }

        @Override
        public Class<Resumable> getType() {
            return Resumable.class;
        }
    };
    private static final CallableFactory<Stoppable> _stopCallableFactoryImpl = new CallableFactory<Stoppable>(){

        @Override
        public Callable<Void> toCallable(Stoppable aComponent, Object ... aArguments) {
            return new StopCallable(aComponent);
        }

        @Override
        public Class<Stoppable> getType() {
            return Stoppable.class;
        }
    };
    private static final CallableFactory<Destroyable> _destroyCallableFactoryImpl = new CallableFactory<Destroyable>(){

        @Override
        public Callable<Void> toCallable(Destroyable aComponent, Object ... aArguments) {
            return new DestroyCallable(aComponent);
        }

        @Override
        public Class<Destroyable> getType() {
            return Destroyable.class;
        }
    };
    private static final CallableFactory<Decomposable> _decomposeCallableFactoryImpl = new CallableFactory<Decomposable>(){

        @Override
        public Callable<Void> toCallable(Decomposable aComponent, Object ... aArguments) {
            return new DecomposeCallable(aComponent);
        }

        @Override
        public Class<Decomposable> getType() {
            return Decomposable.class;
        }
    };
    private static final CallableFactory<Disposable> _disposeCallableFactoryImpl = new CallableFactory<Disposable>(){

        @Override
        public Callable<Void> toCallable(Disposable aComponent, Object ... aArguments) {
            return new DisposeCallable(aComponent);
        }

        @Override
        public Class<Disposable> getType() {
            return Disposable.class;
        }
    };
    private static final CallableFactory<Openable> _openCallableFactoryImpl = new CallableFactory<Openable>(){

        @Override
        public Callable<Void> toCallable(Openable aComponent, Object ... aArguments) {
            return new OpenCallable(aComponent);
        }

        @Override
        public Class<Openable> getType() {
            return Openable.class;
        }
    };
    private static final CallableFactory<ConnectionOpenable> _connectCallableFactoryImpl = new CallableFactory<ConnectionOpenable>(){

        @Override
        public Callable<Void> toCallable(ConnectionOpenable aComponent, Object ... aArguments) {
            return new ConnectCallable<Object>(aComponent, aArguments[0]);
        }

        @Override
        public Class<ConnectionOpenable> getType() {
            return ConnectionOpenable.class;
        }
    };
    private static final CallableFactory<BidirectionalConnectionOpenable> _ioConnectCallableFactoryImpl = new CallableFactory<BidirectionalConnectionOpenable>(){

        @Override
        public Callable<Void> toCallable(BidirectionalConnectionOpenable aComponent, Object ... aArguments) {
            return new IoConnectCallable<Object, Object>(aComponent, aArguments[0], aArguments[1]);
        }

        @Override
        public Class<BidirectionalConnectionOpenable> getType() {
            return BidirectionalConnectionOpenable.class;
        }
    };
    private static final CallableFactory<Closable> _closeCallableFactoryImpl = new CallableFactory<Closable>(){

        @Override
        public Callable<Void> toCallable(Closable aComponent, Object ... aArguments) {
            return new CloseCallable(aComponent);
        }

        @Override
        public Class<Closable> getType() {
            return Closable.class;
        }
    };
    private static final CallableFactory<Flushable> _flushCallableFactoryImpl = new CallableFactory<Flushable>(){

        @Override
        public Callable<Void> toCallable(Flushable aComponent, Object ... aArguments) {
            return new FlushCallable(aComponent);
        }

        @Override
        public Class<Flushable> getType() {
            return Flushable.class;
        }
    };
    private static final CallableFactory<Resetable> _resetCallableFactoryImpl = new CallableFactory<Resetable>(){

        @Override
        public Callable<Void> toCallable(Resetable aComponent, Object ... aArguments) {
            return new ResetCallable(aComponent);
        }

        @Override
        public Class<Resetable> getType() {
            return Resetable.class;
        }
    };

    private ComponentUtility() {
    }

    public static void initialize(Object aComponent) throws InitializeException {
        if (aComponent instanceof Initializable) {
            ((Initializable)aComponent).initialize();
        }
    }

    public static void initialize(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) throws InitializeException {
        ComponentUtility.initialize(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void initialize(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) throws InitializeException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _initializeCallableFactoryImpl, aComponents, null);
        }
        catch (InitializeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitializeException(e);
        }
    }

    @SafeVarargs
    public static void initialize(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) throws InitializeException {
        ComponentUtility.initialize(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void initialize(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) throws InitializeException {
        ComponentUtility.initialize(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static <CTX> void initialize(Object aComponent, CTX aContext) throws InitializeException {
        if (aComponent instanceof Configurable) {
            ((Configurable)aComponent).initialize(aContext);
        }
    }

    public static <CTX> void initialize(ExecutionStrategy aComponentExecutionStrategy, CTX aContext, Collection<?> aComponents) throws ConfigureException {
        ComponentUtility.initialize(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aContext, aComponents);
    }

    public static <CTX> void initialize(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, CTX aContext, Collection<?> aComponents) throws ConfigureException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _configureCallableFactoryImpl, aComponents, aContext);
        }
        catch (ConfigureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigureException(aContext, (Throwable)e);
        }
    }

    @SafeVarargs
    public static <CTX> void initialize(ExecutionStrategy aComponentExecutionStrategy, CTX aContext, Object ... aComponents) throws ConfigureException {
        ComponentUtility.initialize(aComponentExecutionStrategy, aContext, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static <CTX> void initialize(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, CTX aContext, Object ... aComponents) throws ConfigureException {
        ComponentUtility.initialize(aComponentExecutionStrategy, aExecutorService, aContext, Arrays.asList(aComponents));
    }

    public static void start(Object aComponent) throws StartException {
        if (aComponent instanceof Startable) {
            ((Startable)aComponent).start();
        }
    }

    public static void start(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) throws StartException {
        ComponentUtility.start(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void start(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) throws StartException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _startCallableFactoryImpl, aComponents, null);
        }
        catch (StartException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StartException(e);
        }
    }

    @SafeVarargs
    public static void start(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) throws StartException {
        ComponentUtility.start(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void start(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) throws StartException {
        ComponentUtility.start(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void pause(Object aComponent) throws PauseException {
        if (aComponent instanceof Pausable) {
            ((Pausable)aComponent).pause();
        }
    }

    public static void pause(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) throws PauseException {
        ComponentUtility.pause(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void pause(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) throws PauseException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _pauseCallableFactoryImpl, aComponents, null);
        }
        catch (PauseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PauseException(e);
        }
    }

    @SafeVarargs
    public static void pause(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) throws PauseException {
        ComponentUtility.pause(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void pause(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) throws PauseException {
        ComponentUtility.pause(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void resume(Object aComponent) throws ResumeException {
        if (aComponent instanceof Resumable) {
            ((Resumable)aComponent).resume();
        }
    }

    public static void resume(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) throws ResumeException {
        ComponentUtility.resume(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void resume(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) throws ResumeException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _resumeCallableFactoryImpl, aComponents, null);
        }
        catch (ResumeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResumeException(e);
        }
    }

    @SafeVarargs
    public static void resume(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) throws ResumeException {
        ComponentUtility.resume(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void resume(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) throws ResumeException {
        ComponentUtility.resume(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void stop(Object aComponent) throws StopException {
        if (aComponent instanceof Stoppable) {
            ((Stoppable)aComponent).stop();
        }
    }

    public static void stop(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) throws StopException {
        ComponentUtility.stop(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void stop(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) throws StopException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _stopCallableFactoryImpl, aComponents, null);
        }
        catch (StopException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StopException(e);
        }
    }

    @SafeVarargs
    public static void stop(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) throws StopException {
        ComponentUtility.stop(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void stop(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) throws StopException {
        ComponentUtility.stop(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void destroy(Object aComponent) {
        if (aComponent instanceof Destroyable) {
            ((Destroyable)aComponent).destroy();
        }
    }

    public static void destroy(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) {
        ComponentUtility.destroy(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void destroy(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _destroyCallableFactoryImpl, aComponents, null);
        }
        catch (Exception e) {
            throw new DestroyException.DestroyRuntimeException(e);
        }
    }

    @SafeVarargs
    public static void destroy(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) {
        ComponentUtility.destroy(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void destroy(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) {
        ComponentUtility.destroy(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void decompose(Object aComponent) {
        if (aComponent instanceof Decomposable) {
            ((Decomposable)aComponent).decompose();
        }
    }

    public static void decompose(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) {
        ComponentUtility.decompose(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void decompose(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _decomposeCallableFactoryImpl, aComponents, null);
        }
        catch (Exception e) {
            throw new DecomposeException.DecomposeRuntimeException(e);
        }
    }

    @SafeVarargs
    public static void decompose(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) {
        ComponentUtility.decompose(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void decompose(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) {
        ComponentUtility.decompose(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void dispose(Object aComponent) {
        if (aComponent instanceof Disposable) {
            ((Disposable)aComponent).dispose();
        }
    }

    public static void dispose(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) {
        ComponentUtility.dispose(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void dispose(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _disposeCallableFactoryImpl, aComponents, null);
        }
        catch (Exception e) {
            throw new DisposeException.DisposeRuntimeException(e);
        }
    }

    @SafeVarargs
    public static void dispose(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) {
        ComponentUtility.dispose(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void dispose(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) {
        ComponentUtility.dispose(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void flush(Object aComponent) throws IOException {
        if (aComponent instanceof Flushable) {
            try {
                ((Flushable)aComponent).flush();
            }
            catch (IOException e) {
                throw new IOException("Unable to flush component <" + String.valueOf(aComponent) + ">.", e);
            }
        }
    }

    public static void flush(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) throws IOException {
        ComponentUtility.flush(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void flush(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) throws IOException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _flushCallableFactoryImpl, aComponents, null);
        }
        catch (Exception e) {
            throw new IOException("Unable to flush component(s).", e);
        }
    }

    @SafeVarargs
    public static void flush(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) throws IOException {
        ComponentUtility.flush(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void flush(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) throws IOException {
        ComponentUtility.flush(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void reset(Object aComponent) {
        if (aComponent instanceof Resetable) {
            ((Resetable)aComponent).reset();
        }
    }

    public static void reset(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) {
        ComponentUtility.reset(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void reset(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _resetCallableFactoryImpl, aComponents, null);
        }
        catch (Exception e) {
            throw new ResetException.ResetRuntimeException(e);
        }
    }

    @SafeVarargs
    public static void reset(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) {
        ComponentUtility.reset(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void reset(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) {
        ComponentUtility.reset(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static void open(Object aComponent) throws IOException {
        if (aComponent instanceof Openable) {
            ((Openable)aComponent).open();
        }
    }

    public static void open(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void open(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) throws IOException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _openCallableFactoryImpl, aComponents, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @SafeVarargs
    public static void open(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void open(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static <CON> void open(Object aComponent, CON aConnection) throws IOException {
        if (aComponent instanceof ConnectionOpenable) {
            ((ConnectionOpenable)aComponent).open(aConnection);
        }
    }

    public static <CON> void open(ExecutionStrategy aComponentExecutionStrategy, CON aConnection, Collection<?> aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aConnection, aComponents);
    }

    public static <CON> void open(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, CON aConnection, Collection<?> aComponents) throws IOException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _connectCallableFactoryImpl, aComponents, aConnection);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @SafeVarargs
    public static <CON> void open(ExecutionStrategy aComponentExecutionStrategy, CON aConnection, Object ... aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, aConnection, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static <CON> void open(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, CON aConnection, Object ... aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, aExecutorService, aConnection, Arrays.asList(aComponents));
    }

    public static <INPUT, OUTPUT> void open(Object aComponent, INPUT aInputConnection, OUTPUT aOutputConnection) throws IOException {
        if (aComponent instanceof BidirectionalConnectionOpenable) {
            ((BidirectionalConnectionOpenable)aComponent).open(aInputConnection, aOutputConnection);
        }
    }

    public static <INPUT, OUTPUT> void open(ExecutionStrategy aComponentExecutionStrategy, INPUT aInputConnection, OUTPUT aOutputConnection, Collection<?> aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aInputConnection, aOutputConnection, aComponents);
    }

    public static <INPUT, OUTPUT> void open(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, INPUT aInputConnection, OUTPUT aOutputConnection, Collection<?> aComponents) throws IOException {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _ioConnectCallableFactoryImpl, aComponents, aInputConnection, aOutputConnection);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @SafeVarargs
    public static <INPUT, OUTPUT> void open(ExecutionStrategy aComponentExecutionStrategy, INPUT aInputConnection, OUTPUT aOutputConnection, Object ... aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, aInputConnection, aOutputConnection, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static <INPUT, OUTPUT> void open(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, INPUT aInputConnection, OUTPUT aOutputConnection, Object ... aComponents) throws IOException {
        ComponentUtility.open(aComponentExecutionStrategy, aExecutorService, aInputConnection, aOutputConnection, Arrays.asList(aComponents));
    }

    public static void close(Object aComponent) throws IOException {
        if (aComponent instanceof Closable) {
            ((Closable)aComponent).close();
        }
    }

    public static void close(ExecutionStrategy aComponentExecutionStrategy, Collection<?> aComponents) {
        ComponentUtility.close(aComponentExecutionStrategy, ControlFlowUtility.createCachedExecutorService((boolean)true), aComponents);
    }

    public static void close(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Collection<?> aComponents) {
        try {
            ComponentUtility.execute(aComponentExecutionStrategy, aExecutorService, _closeCallableFactoryImpl, aComponents, null);
        }
        catch (Exception e) {
            throw new CloseException.CloseRuntimeException(e);
        }
    }

    @SafeVarargs
    public static void close(ExecutionStrategy aComponentExecutionStrategy, Object ... aComponents) {
        ComponentUtility.close(aComponentExecutionStrategy, Arrays.asList(aComponents));
    }

    @SafeVarargs
    public static void close(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, Object ... aComponents) {
        ComponentUtility.close(aComponentExecutionStrategy, aExecutorService, Arrays.asList(aComponents));
    }

    public static <T> void execute(ExecutionStrategy aComponentExecutionStrategy, ExecutorService aExecutorService, CallableFactory<T> aCallableFactory, Collection<?> aComponents, Object ... aArguments) throws Exception {
        if (aComponentExecutionStrategy == ExecutionStrategy.SEQUENTIAL) {
            for (Object e : aComponents) {
                if (!aCallableFactory.getType().isAssignableFrom(e.getClass())) continue;
                Callable<Void> theCallable = aCallableFactory.toCallable(e, aArguments);
                theCallable.call();
            }
        } else if (aComponentExecutionStrategy == ExecutionStrategy.PARALLEL || aComponentExecutionStrategy == ExecutionStrategy.JOIN) {
            HashSet<Callable<Void>> theCallables = new HashSet<Callable<Void>>();
            for (Object e : aComponents) {
                if (!aCallableFactory.getType().isAssignableFrom(e.getClass())) continue;
                Callable<Void> callable = aCallableFactory.toCallable(e, aArguments);
                theCallables.add(callable);
            }
            if (aComponentExecutionStrategy == ExecutionStrategy.PARALLEL) {
                try {
                    aExecutorService.invokeAll(theCallables);
                }
                catch (InterruptedException e) {}
            } else if (aComponentExecutionStrategy == ExecutionStrategy.JOIN) {
                HashSet theFutures = new HashSet();
                for (Callable callable : theCallables) {
                    theFutures.add(aExecutorService.submit(callable));
                }
                ControlFlowUtility.waitForFutures(theFutures);
            }
        }
    }

    private static interface CallableFactory<T> {
        public Callable<Void> toCallable(T var1, Object ... var2);

        public Class<T> getType();
    }

    private static class CloseCallable
    implements Callable<Void> {
        private final Closable _component;

        private CloseCallable(Closable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.close();
            return null;
        }
    }

    private static class IoConnectCallable<INPUT, OUTPUT>
    implements Callable<Void> {
        private final BidirectionalConnectionOpenable<INPUT, OUTPUT> _component;
        private final INPUT _inputConnection;
        private final OUTPUT _outputConnection;

        private IoConnectCallable(BidirectionalConnectionOpenable<INPUT, OUTPUT> aComponent, INPUT aInputConnection, OUTPUT aOutputConnection) {
            this._component = aComponent;
            this._inputConnection = aInputConnection;
            this._outputConnection = aOutputConnection;
        }

        @Override
        public Void call() throws Exception {
            this._component.open(this._inputConnection, this._outputConnection);
            return null;
        }
    }

    private static class ConnectCallable<CON>
    implements Callable<Void> {
        private final ConnectionOpenable<CON> _component;
        private final CON _connection;

        private ConnectCallable(ConnectionOpenable<CON> aComponent, CON aConnection) {
            this._component = aComponent;
            this._connection = aConnection;
        }

        @Override
        public Void call() throws Exception {
            this._component.open(this._connection);
            return null;
        }
    }

    private static class OpenCallable
    implements Callable<Void> {
        private final Openable _component;

        private OpenCallable(Openable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.open();
            return null;
        }
    }

    private static class ResetCallable
    implements Callable<Void> {
        private final Resetable _component;

        private ResetCallable(Resetable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.reset();
            return null;
        }
    }

    private static class FlushCallable
    implements Callable<Void> {
        private final Flushable _component;

        private FlushCallable(Flushable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.flush();
            return null;
        }
    }

    private static class DisposeCallable
    implements Callable<Void> {
        private final Disposable _component;

        private DisposeCallable(Disposable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.dispose();
            return null;
        }
    }

    private static class DecomposeCallable
    implements Callable<Void> {
        private final Decomposable _component;

        private DecomposeCallable(Decomposable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.decompose();
            return null;
        }
    }

    private static class DestroyCallable
    implements Callable<Void> {
        private final Destroyable _component;

        private DestroyCallable(Destroyable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.destroy();
            return null;
        }
    }

    private static class StopCallable
    implements Callable<Void> {
        private final Stoppable _component;

        private StopCallable(Stoppable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.stop();
            return null;
        }
    }

    private static class ResumeCallable
    implements Callable<Void> {
        private final Resumable _component;

        private ResumeCallable(Resumable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.resume();
            return null;
        }
    }

    private static class PauseCallable
    implements Callable<Void> {
        private final Pausable _component;

        private PauseCallable(Pausable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.pause();
            return null;
        }
    }

    private static class StartCallable
    implements Callable<Void> {
        private final Startable _component;

        private StartCallable(Startable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.start();
            return null;
        }
    }

    private static class ConfigureCallable<CTX>
    implements Callable<Void> {
        private final Configurable<CTX> _component;
        private final CTX _context;

        private ConfigureCallable(Configurable<CTX> aComponent, CTX aContext) {
            this._component = aComponent;
            this._context = aContext;
        }

        @Override
        public Void call() throws Exception {
            this._component.initialize(this._context);
            return null;
        }
    }

    private static class InitializeCallable
    implements Callable<Void> {
        private final Initializable _component;

        private InitializeCallable(Initializable aComponent) {
            this._component = aComponent;
        }

        @Override
        public Void call() throws Exception {
            this._component.initialize();
            return null;
        }
    }
}

