/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.redisson.LongSlotCallback;
import org.redisson.RedissonObject;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.RKeys;
import org.redisson.api.RObject;
import org.redisson.api.RType;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.iterator.RedissonBaseIterator;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.CompositeIterable;
import org.redisson.reactive.CommandReactiveBatchService;
import org.redisson.rx.CommandRxBatchService;

public class RedissonKeys
implements RKeys {
    private final CommandAsyncExecutor commandExecutor;

    public RedissonKeys(CommandAsyncExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public CommandAsyncExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public ConnectionManager getConnectionManager() {
        return this.commandExecutor.getConnectionManager();
    }

    @Override
    public RType getType(String key) {
        return this.commandExecutor.get(this.getTypeAsync(key));
    }

    @Override
    public RFuture<RType> getTypeAsync(String key) {
        return this.commandExecutor.readAsync(key, RedisCommands.TYPE, key);
    }

    @Override
    public int getSlot(String key) {
        return this.commandExecutor.get(this.getSlotAsync(key));
    }

    @Override
    public RFuture<Integer> getSlotAsync(String key) {
        return this.commandExecutor.readAsync(null, RedisCommands.KEYSLOT, key);
    }

    @Override
    public Iterable<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    @Override
    public Iterable<String> getKeysByPattern(String pattern, int count) {
        return this.getKeysByPattern(RedisCommands.SCAN, pattern, 0, count);
    }

    public <T> Iterable<T> getKeysByPattern(final RedisCommand<?> command, final String pattern, int limit, final int count) {
        ArrayList iterables = new ArrayList();
        for (final MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            Iterable iterable = new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return RedissonKeys.this.createKeysIterator(entry, command, pattern, count);
                }
            };
            iterables.add(iterable);
        }
        return new CompositeIterable(iterables, limit);
    }

    @Override
    public Iterable<String> getKeysWithLimit(int limit) {
        return this.getKeysWithLimit(null, limit);
    }

    @Override
    public Iterable<String> getKeysWithLimit(String pattern, int limit) {
        return this.getKeysByPattern(RedisCommands.SCAN, pattern, limit, limit);
    }

    @Override
    public Iterable<String> getKeys() {
        return this.getKeysByPattern(null);
    }

    @Override
    public Iterable<String> getKeys(int count) {
        return this.getKeysByPattern(null, count);
    }

    public RFuture<ScanResult<Object>> scanIteratorAsync(RedisClient client, MasterSlaveEntry entry, RedisCommand<?> command, long startPos, String pattern, int count) {
        if (pattern == null) {
            return this.commandExecutor.readAsync(client, entry, (Codec)StringCodec.INSTANCE, command, startPos, "COUNT", count);
        }
        return this.commandExecutor.readAsync(client, entry, (Codec)StringCodec.INSTANCE, command, startPos, "MATCH", pattern, "COUNT", count);
    }

    public RFuture<ScanResult<Object>> scanIteratorAsync(RedisClient client, MasterSlaveEntry entry, long startPos, String pattern, int count) {
        return this.scanIteratorAsync(client, entry, RedisCommands.SCAN, startPos, pattern, count);
    }

    private <T> Iterator<T> createKeysIterator(final MasterSlaveEntry entry, final RedisCommand<?> command, final String pattern, final int count) {
        return new RedissonBaseIterator<T>(){

            @Override
            protected ScanResult<Object> iterator(RedisClient client, long nextIterPos) {
                return RedissonKeys.this.commandExecutor.get(RedissonKeys.this.scanIteratorAsync(client, entry, command, nextIterPos, pattern, count));
            }

            @Override
            protected void remove(Object value) {
                RedissonKeys.this.delete((String)value);
            }
        };
    }

    @Override
    public long touch(String ... names) {
        return this.commandExecutor.get(this.touchAsync(names));
    }

    @Override
    public RFuture<Long> touchAsync(String ... names) {
        if (names.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        return this.commandExecutor.writeBatchedAsync(null, RedisCommands.TOUCH_LONG, new LongSlotCallback(), names);
    }

    @Override
    public long countExists(String ... names) {
        return this.commandExecutor.get(this.countExistsAsync(names));
    }

    @Override
    public RFuture<Long> countExistsAsync(String ... names) {
        if (names.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        List<String> keysList = Arrays.stream(names).map(k -> this.commandExecutor.getConnectionManager().getConfig().getNameMapper().map((String)k)).collect(Collectors.toList());
        return this.commandExecutor.readBatchedAsync(StringCodec.INSTANCE, RedisCommands.EXISTS_LONG, new LongSlotCallback(), keysList.toArray(new String[0]));
    }

    @Override
    public String randomKey() {
        return this.commandExecutor.get(this.randomKeyAsync());
    }

    @Override
    public RFuture<String> randomKeyAsync() {
        return this.commandExecutor.readRandomAsync(StringCodec.INSTANCE, RedisCommands.RANDOM_KEY, new Object[0]);
    }

    @Override
    public long deleteByPattern(String pattern) {
        return this.commandExecutor.get(this.deleteByPatternAsync(pattern));
    }

    @Override
    public RFuture<Long> deleteByPatternAsync(String pattern) {
        if (this.commandExecutor instanceof CommandBatchService || this.commandExecutor instanceof CommandReactiveBatchService || this.commandExecutor instanceof CommandRxBatchService) {
            if (this.getConnectionManager().isClusterMode()) {
                throw new IllegalStateException("This method doesn't work in batch for Redis cluster mode. For Redis cluster execute it as non-batch method");
            }
            return this.commandExecutor.evalWriteAsync((String)null, null, RedisCommands.EVAL_LONG, "local keys = redis.call('keys', ARGV[1]) local n = 0 for i=1, #keys,5000 do n = n + redis.call('del', unpack(keys, i, math.min(i+4999, table.getn(keys)))) end return n;", Collections.emptyList(), pattern);
        }
        int batchSize = 500;
        ArrayList futures = new ArrayList();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            CompletableFuture future = new CompletableFuture();
            futures.add(future);
            this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                long count = 0L;
                try {
                    Iterator keysIterator = this.createKeysIterator(entry, RedisCommands.SCAN, pattern, batchSize);
                    ArrayList<String> keys = new ArrayList<String>();
                    while (keysIterator.hasNext()) {
                        String key = (String)keysIterator.next();
                        keys.add(key);
                        if (keys.size() % batchSize != 0) continue;
                        count += this.delete(keys.toArray(new String[0]));
                        keys.clear();
                    }
                    if (!keys.isEmpty()) {
                        count += this.delete(keys.toArray(new String[0]));
                        keys.clear();
                    }
                    future.complete(count);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            });
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage res = future.handle((r, e) -> {
            long cc = futures.stream().filter(f -> f.isDone()).mapToLong(f -> f.getNow(0L)).sum();
            if (e != null) {
                if (cc > 0L) {
                    RedisException ex = new RedisException(cc + " keys have been deleted. But one or more nodes has an error", (Throwable)e);
                    throw new CompletionException(ex);
                }
                throw new CompletionException((Throwable)e);
            }
            return cc;
        });
        return new CompletableFutureWrapper<Long>((CompletableFuture<Long>)res);
    }

    @Override
    public long delete(String ... keys) {
        return this.commandExecutor.get(this.deleteAsync(keys));
    }

    @Override
    public long delete(RObject ... objects) {
        return this.commandExecutor.get(this.deleteAsync(objects));
    }

    @Override
    public RFuture<Long> deleteAsync(RObject ... objects) {
        ArrayList<String> keys = new ArrayList<String>();
        for (RObject obj : objects) {
            keys.add(((RedissonObject)obj).getRawName());
        }
        return this.deleteAsync(keys.toArray(new String[keys.size()]));
    }

    @Override
    public long unlink(String ... keys) {
        return this.commandExecutor.get(this.unlinkAsync(keys));
    }

    @Override
    public RFuture<Long> unlinkAsync(String ... keys) {
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        return this.commandExecutor.writeBatchedAsync(null, RedisCommands.UNLINK, new LongSlotCallback(), keys);
    }

    @Override
    public RFuture<Long> deleteAsync(String ... keys) {
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Long>(0L);
        }
        return this.commandExecutor.writeBatchedAsync(null, RedisCommands.DEL, new LongSlotCallback(), keys);
    }

    @Override
    public long count() {
        return this.commandExecutor.get(this.countAsync());
    }

    @Override
    public RFuture<Long> countAsync() {
        List futures = this.commandExecutor.readAllAsync(RedisCommands.DBSIZE, new Object[0]);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> futures.stream().mapToLong(v -> v.getNow(0L)).sum());
        return new CompletableFutureWrapper<Long>((CompletableFuture<Long>)s);
    }

    @Override
    public void flushdbParallel() {
        this.commandExecutor.get(this.flushdbParallelAsync());
    }

    @Override
    public RFuture<Void> flushdbParallelAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FLUSHDB_ASYNC, new Object[0]);
    }

    @Override
    public void flushallParallel() {
        this.commandExecutor.get(this.flushallParallelAsync());
    }

    @Override
    public RFuture<Void> flushallParallelAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FLUSHALL_ASYNC, new Object[0]);
    }

    @Override
    public void flushdb() {
        this.commandExecutor.get(this.flushdbAsync());
    }

    @Override
    public RFuture<Void> flushdbAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FLUSHDB, new Object[0]);
    }

    @Override
    public void flushall() {
        this.commandExecutor.get(this.flushallAsync());
    }

    @Override
    public RFuture<Void> flushallAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.FLUSHALL, new Object[0]);
    }

    @Override
    public long remainTimeToLive(String name) {
        return this.commandExecutor.get(this.remainTimeToLiveAsync(name));
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync(String name) {
        return this.commandExecutor.readAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PTTL, name);
    }

    @Override
    public void rename(String currentName, String newName) {
        this.commandExecutor.get(this.renameAsync(currentName, newName));
    }

    @Override
    public RFuture<Void> renameAsync(String currentName, String newName) {
        return this.commandExecutor.writeAsync(currentName, RedisCommands.RENAME, currentName, newName);
    }

    @Override
    public boolean renamenx(String oldName, String newName) {
        return this.commandExecutor.get(this.renamenxAsync(oldName, newName));
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String oldName, String newName) {
        return this.commandExecutor.writeAsync(oldName, RedisCommands.RENAMENX, oldName, newName);
    }

    @Override
    public boolean clearExpire(String name) {
        return this.commandExecutor.get(this.clearExpireAsync(name));
    }

    @Override
    public RFuture<Boolean> clearExpireAsync(String name) {
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PERSIST, name);
    }

    @Override
    public boolean expireAt(String name, long timestamp) {
        return this.commandExecutor.get(this.expireAtAsync(name, timestamp));
    }

    @Override
    public RFuture<Boolean> expireAtAsync(String name, long timestamp) {
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIREAT, name, timestamp);
    }

    @Override
    public boolean expire(String name, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.get(this.expireAsync(name, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> expireAsync(String name, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIRE, name, timeUnit.toMillis(timeToLive));
    }

    @Override
    public void migrate(String name, String host, int port, int database, long timeout) {
        this.commandExecutor.get(this.migrateAsync(name, host, port, database, timeout));
    }

    @Override
    public RFuture<Void> migrateAsync(String name, String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(name, RedisCommands.MIGRATE, host, port, name, database, timeout);
    }

    @Override
    public void copy(String name, String host, int port, int database, long timeout) {
        this.commandExecutor.get(this.copyAsync(name, host, port, database, timeout));
    }

    @Override
    public RFuture<Void> copyAsync(String name, String host, int port, int database, long timeout) {
        return this.commandExecutor.writeAsync(name, RedisCommands.MIGRATE, host, port, name, database, timeout, "COPY");
    }

    @Override
    public boolean move(String name, int database) {
        return this.commandExecutor.get(this.moveAsync(name, database));
    }

    @Override
    public RFuture<Boolean> moveAsync(String name, int database) {
        return this.commandExecutor.writeAsync(name, RedisCommands.MOVE, name, database);
    }

    @Override
    public Stream<String> getKeysStreamByPattern(String pattern) {
        return this.toStream(this.getKeysByPattern(pattern).iterator());
    }

    protected <T> Stream<T> toStream(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    public Stream<String> getKeysStreamByPattern(String pattern, int count) {
        return this.toStream(this.getKeysByPattern(pattern, count).iterator());
    }

    @Override
    public Stream<String> getKeysStream() {
        return this.toStream(this.getKeys().iterator());
    }

    @Override
    public Stream<String> getKeysStream(int count) {
        return this.toStream(this.getKeys(count).iterator());
    }

    @Override
    public void swapdb(int db1, int db2) {
        this.commandExecutor.get(this.swapdbAsync(db1, db2));
    }

    @Override
    public RFuture<Void> swapdbAsync(int db1, int db2) {
        return this.commandExecutor.writeAsync(null, RedisCommands.SWAPDB, db1, db2);
    }
}

