/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.concurrent.Callable;
import org.redisson.api.RFuture;
import org.redisson.command.CommandAsyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.rx.CommandRxExecutor;

public class CommandRxService
extends CommandAsyncService
implements CommandRxExecutor {
    public CommandRxService(ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder) {
        super(connectionManager, objectBuilder, RedissonObjectBuilder.ReferenceType.RXJAVA);
    }

    @Override
    public <R> Flowable<R> flowable(final Callable<RFuture<R>> supplier) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            public void accept(long t) throws Exception {
                RFuture future;
                try {
                    future = (RFuture)supplier.call();
                }
                catch (Exception e2) {
                    p.onError((Throwable)e2);
                    return;
                }
                p.doOnCancel(new Action(){

                    public void run() throws Exception {
                        future.cancel(true);
                    }
                });
                future.onComplete((res, e) -> {
                    if (e != null) {
                        p.onError(e);
                        return;
                    }
                    if (res != null) {
                        p.onNext(res);
                    }
                    p.onComplete();
                });
            }
        });
    }
}

