/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.redisson.Redisson;
import org.redisson.RedissonObject;
import org.redisson.RedissonReactive;
import org.redisson.RedissonRx;
import org.redisson.ScanResult;
import org.redisson.api.CacheAsync;
import org.redisson.api.CacheReactive;
import org.redisson.api.CacheRx;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.MapValueDecoder;
import org.redisson.codec.BaseEventCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.iterator.RedissonBaseMapIterator;
import org.redisson.jcache.JCacheEntry;
import org.redisson.jcache.JCacheEntryEvent;
import org.redisson.jcache.JCacheEventCodec;
import org.redisson.jcache.JCacheManager;
import org.redisson.jcache.JMutableEntry;
import org.redisson.jcache.configuration.JCacheConfiguration;
import org.redisson.misc.Hash;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.reactive.ReactiveProxyBuilder;
import org.redisson.rx.RxProxyBuilder;

public class JCache<K, V>
extends RedissonObject
implements Cache<K, V>,
CacheAsync<K, V> {
    final boolean atomicExecution = System.getProperty("org.jsr107.tck.management.agentId") == null;
    final JCacheManager cacheManager;
    final JCacheConfiguration<K, V> config;
    private final ConcurrentMap<CacheEntryListenerConfiguration<K, V>, Map<Integer, String>> listeners = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, Map<Integer, String>>();
    final Redisson redisson;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private boolean closed;
    private boolean hasOwnRedisson;
    private static final RLock DUMMY_LOCK = (RLock)Proxy.newProxyInstance(JCache.class.getClassLoader(), new Class[]{RLock.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    });
    private BaseEventCodec.OSType osType;

    public JCache(JCacheManager cacheManager, Redisson redisson, String name, JCacheConfiguration<K, V> config, boolean hasOwnRedisson) {
        super(redisson.getConfig().getCodec(), redisson.getCommandExecutor(), name);
        this.hasOwnRedisson = hasOwnRedisson;
        this.redisson = redisson;
        Factory<CacheLoader<K, V>> cacheLoaderFactory = config.getCacheLoaderFactory();
        if (cacheLoaderFactory != null) {
            this.cacheLoader = (CacheLoader)cacheLoaderFactory.create();
        }
        Factory<CacheWriter<K, V>> cacheWriterFactory = config.getCacheWriterFactory();
        if (config.getCacheWriterFactory() != null) {
            this.cacheWriter = (CacheWriter)cacheWriterFactory.create();
        }
        this.cacheManager = cacheManager;
        this.config = config;
        redisson.getEvictionScheduler().scheduleJCache(this.getRawName(), this.getTimeoutSetName(), this.getExpiredChannelName());
        for (CacheEntryListenerConfiguration<K, V> listenerConfig : config.getCacheEntryListenerConfigurations()) {
            this.registerCacheEntryListener(listenerConfig, false);
        }
    }

    void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    String getTimeoutSetName() {
        return "jcache_timeout_set:{" + this.getRawName() + "}";
    }

    String getTimeoutSetName(String name) {
        return JCache.prefixName("jcache_timeout_set", name);
    }

    String getSyncName(Object syncId) {
        return "jcache_sync:" + syncId + ":{" + this.getRawName() + "}";
    }

    String getCreatedSyncChannelName() {
        return "jcache_created_sync_channel:{" + this.getRawName() + "}";
    }

    String getCreatedSyncChannelName(String name) {
        return JCache.prefixName("jcache_created_sync_channel", name);
    }

    String getUpdatedSyncChannelName() {
        return "jcache_updated_sync_channel:{" + this.getRawName() + "}";
    }

    String getUpdatedSyncChannelName(String name) {
        return JCache.prefixName("jcache_updated_sync_channel", name);
    }

    String getRemovedSyncChannelName() {
        return "jcache_removed_sync_channel:{" + this.getRawName() + "}";
    }

    String getRemovedSyncChannelName(String name) {
        return JCache.prefixName("jcache_removed_sync_channel", name);
    }

    String getCreatedChannelName() {
        return "jcache_created_channel:{" + this.getRawName() + "}";
    }

    String getCreatedChannelName(String name) {
        return JCache.prefixName("jcache_created_channel", name);
    }

    String getUpdatedChannelName() {
        return "jcache_updated_channel:{" + this.getRawName() + "}";
    }

    String getUpdatedChannelName(String name) {
        return JCache.prefixName("jcache_updated_channel", name);
    }

    String getExpiredChannelName() {
        return "jcache_expired_channel:{" + this.getRawName() + "}";
    }

    String getRemovedChannelName(String name) {
        return JCache.prefixName("jcache_removed_channel", name);
    }

    String getRemovedChannelName() {
        return "jcache_removed_channel:{" + this.getRawName() + "}";
    }

    String getOldValueListenerCounter() {
        return "jcache_old_value_listeners:{" + this.getRawName() + "}";
    }

    String getOldValueListenerCounter(String name) {
        return JCache.prefixName("jcache_old_value_listeners", name);
    }

    long currentNanoTime() {
        if (this.config.isStatisticsEnabled()) {
            return System.nanoTime();
        }
        return 0L;
    }

    void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        RLock lock = this.getLockedLock(key);
        try {
            RFuture<V> result = this.getAsync(key);
            result.syncUninterruptibly();
            V v = result.getNow();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public RFuture<V> getAsync(K key) {
        RFuture<Object> future;
        this.checkNotClosed();
        this.checkKey(key);
        long startTime = this.currentNanoTime();
        if (this.atomicExecution) {
            future = this.getValue(key);
        } else {
            V value2 = this.getValueLocked(key);
            future = RedissonPromise.newSucceededFuture(value2);
        }
        RedissonPromise result = new RedissonPromise();
        future.onComplete((value, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)new CacheException(e));
                return;
            }
            if (value == null) {
                this.cacheManager.getStatBean(this).addMisses(1L);
                if (this.config.isReadThrough()) {
                    this.redisson.getConnectionManager().getExecutor().execute(() -> {
                        try {
                            V val = this.loadValue(key);
                            result.trySuccess(val);
                        }
                        catch (Exception ex) {
                            result.tryFailure(ex);
                        }
                    });
                    return;
                }
            } else {
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addHits(1L);
            }
            result.trySuccess(value);
        });
        return result;
    }

    V getValueLocked(K key) {
        Object value = this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[2]) then return nil; end; return value; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName()), 0, System.currentTimeMillis(), this.encodeMapKey(key));
        if (value != null) {
            Long accessTimeout = this.getAccessTimeout();
            if (accessTimeout == -1L) {
                return (V)value;
            }
            ArrayList<Object> result = new ArrayList<Object>(3);
            result.add(value);
            double syncId = ThreadLocalRandom.current().nextDouble();
            Long syncs = (Long)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LONG, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local value = redis.call('hget', KEYS[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value), ARGV[4]); local syncs = redis.call('publish', KEYS[4], syncMsg); return syncs;elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); return 0;end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getRemovedSyncChannelName()), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key), syncId);
            result.add(syncs);
            result.add(syncId);
            this.waitSync(result);
            return (V)value;
        }
        return (V)value;
    }

    RFuture<V> getValue(K key) {
        Long accessTimeout = this.getAccessTimeout();
        if (accessTimeout == -1L) {
            String name = this.getRawName(key);
            return this.commandExecutor.evalReadAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[2]) then return nil; end; return value; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name)), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key));
        }
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[2]) then return nil; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); end; return value; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name)), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key));
    }

    Long getAccessTimeout(long baseTime) {
        if (this.config.getExpiryPolicy().getExpiryForAccess() == null) {
            return -1L;
        }
        Long accessTimeout = this.config.getExpiryPolicy().getExpiryForAccess().getAdjustedTime(baseTime);
        if (this.config.getExpiryPolicy().getExpiryForAccess().isZero()) {
            accessTimeout = 0L;
        } else if (accessTimeout == Long.MAX_VALUE) {
            accessTimeout = -1L;
        }
        return accessTimeout;
    }

    Long getAccessTimeout() {
        return this.getAccessTimeout(System.currentTimeMillis());
    }

    V loadValue(K key) {
        Object value = null;
        try {
            value = this.cacheLoader.load(key);
        }
        catch (Exception ex) {
            throw new CacheLoaderException((Throwable)ex);
        }
        if (value != null) {
            long startTime = this.currentNanoTime();
            if (this.atomicExecution) {
                this.putValue(key, value);
            } else {
                this.putValueLocked(key, value);
            }
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        }
        return (V)value;
    }

    private <T, R> R write(String key, RedisCommand<T> command, Object ... params) {
        RFuture future = this.commandExecutor.writeAsync(key, command, params);
        try {
            return (R)this.get((K)future);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    <T, R> R evalWrite(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        RFuture future = this.commandExecutor.evalWriteAsync(key, codec, evalCommandType, script, keys, params);
        try {
            return (R)this.get((K)future);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    <T, R> R evalRead(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        RFuture future = this.commandExecutor.evalReadAsync(key, codec, evalCommandType, script, keys, params);
        try {
            return (R)this.get((K)future);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private boolean putValueLocked(K key, Object value) {
        double syncId = ThreadLocalRandom.current().nextDouble();
        if (this.containsKey(key)) {
            Long updateTimeout = this.getUpdateTimeout();
            List res = (List)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]);local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[6]); local syncs = redis.call('publish', KEYS[7], syncMsg); return {0, syncs};elseif ARGV[2] ~= '-1' then local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1, ARGV[6]); else local value = redis.call('hget', KEYS[1], ARGV[4]);redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value), ARGV[6]); end; redis.call('publish', KEYS[5], msg); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, syncs};else local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1, ARGV[6]); else local value = redis.call('hget', KEYS[1], ARGV[4]);redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value), ARGV[6]); end; redis.call('publish', KEYS[5], msg); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, syncs};end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getCreatedChannelName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getCreatedSyncChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName(), this.getOldValueListenerCounter()), 0, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
            res.add(syncId);
            this.waitSync(res);
            return (Long)res.get(0) == 1L;
        }
        Long creationTimeout = this.getCreationTimeout();
        if (creationTimeout == 0L) {
            return false;
        }
        List res = (List)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "if ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {1, syncs};end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getCreatedChannelName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getCreatedSyncChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName()), creationTimeout, 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
        res.add(syncId);
        this.waitSync(res);
        return (Long)res.get(0) == 1L;
    }

    RFuture<Long> putAllValues(Map<? extends K, ? extends V> map) {
        Long creationTimeout = this.getCreationTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(creationTimeout);
        params.add(updateTimeout);
        params.add(System.currentTimeMillis());
        double syncId = ThreadLocalRandom.current().nextDouble();
        params.add(syncId);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            params.add(this.encodeMapKey(entry.getKey()));
            params.add(this.encodeMapValue(entry.getValue()));
        }
        RFuture<List<Object>> res = this.putAllOperation(this.commandExecutor, null, this.getRawName(), params);
        RFuture<Long> result = this.handlePutAllResult(syncId, res);
        return result;
    }

    RFuture<Long> handlePutAllResult(double syncId, RFuture<List<Object>> res) {
        RedissonPromise<Long> result = new RedissonPromise<Long>();
        if (this.atomicExecution) {
            res.onComplete((r, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)new CacheException(e));
                    return;
                }
                Long added = (Long)r.get(0);
                Long syncs = (Long)r.get(1);
                if (syncs > 0L) {
                    RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
                    semaphore.acquireAsync(syncs.intValue()).onComplete((obj1, ex) -> {
                        if (ex != null) {
                            result.tryFailure((Throwable)new CacheException(ex));
                            return;
                        }
                        semaphore.deleteAsync().onComplete((obj, exc) -> {
                            if (exc != null) {
                                result.tryFailure((Throwable)new CacheException(exc));
                                return;
                            }
                            result.trySuccess(added);
                        });
                    });
                } else {
                    result.trySuccess(added);
                }
            });
        } else {
            res.syncUninterruptibly();
            List<Object> r2 = res.getNow();
            Long added = (Long)r2.get(0);
            Long syncs = (Long)r2.get(1);
            if (syncs > 0L) {
                RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
                try {
                    semaphore.acquire(syncs.intValue());
                    semaphore.delete();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
            result.trySuccess(added);
        }
        return result;
    }

    RFuture<List<Object>> putAllOperation(CommandAsyncExecutor commandExecutor, MasterSlaveEntry entry, String name, List<Object> params) {
        String script = "local added = 0; local syncs = 0; for i = 5, #ARGV, 2 do local expireDateScore = redis.call('zscore', KEYS[2], ARGV[i]);local exists = redis.call('hexists', KEYS[1], ARGV[i]) == 1;if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[3]) then exists = false;end;if exists then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[i]); redis.call('zrem', KEYS[2], ARGV[i]); local value = redis.call('hget', KEYS[1], ARGV[i]);local msg = struct.pack('Lc0Lc0', string.len(ARGV[i]), ARGV[i], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[i]), ARGV[i], string.len(tostring(value)), tostring(value), ARGV[4]); syncs = syncs + redis.call('publish', KEYS[7], syncMsg); elseif ARGV[2] ~= '-1' then local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[i], ARGV[i+1]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[i]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], -1, ARGV[4]); else local value = redis.call('hget', KEYS[1], ARGV[i]);redis.call('hset', KEYS[1], ARGV[i], ARGV[i+1]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[i]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], string.len(tostring(value)), tostring(value), ARGV[4]); end; redis.call('publish', KEYS[5], msg); syncs = syncs + redis.call('publish', KEYS[8], syncMsg); added = added + 1;else local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[i], ARGV[i+1]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], -1, ARGV[4]); else local value = redis.call('hget', KEYS[1], ARGV[i]);redis.call('hset', KEYS[1], ARGV[i], ARGV[i+1]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], string.len(tostring(value)), tostring(value), ARGV[4]); end; redis.call('publish', KEYS[5], msg); syncs = syncs + redis.call('publish', KEYS[8], syncMsg); added = added + 1;end; else if ARGV[1] == '0' then elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[i], ARGV[i+1]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[i]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], ARGV[4]); syncs = syncs + redis.call('publish', KEYS[6], syncMsg); added = added + 1;else redis.call('hset', KEYS[1], ARGV[i], ARGV[i+1]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[i]), ARGV[i], string.len(ARGV[i+1]), ARGV[i+1], ARGV[4]); syncs = syncs + redis.call('publish', KEYS[6], syncMsg); added = added + 1;end; end; end; return {added, syncs};";
        if (entry == null) {
            return commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_LIST, script, Arrays.asList(name, this.getTimeoutSetName(name), this.getCreatedChannelName(name), this.getRemovedChannelName(name), this.getUpdatedChannelName(name), this.getCreatedSyncChannelName(name), this.getRemovedSyncChannelName(name), this.getUpdatedSyncChannelName(name), this.getOldValueListenerCounter(name)), params.toArray());
        }
        return commandExecutor.evalWriteAsync(entry, this.codec, RedisCommands.EVAL_LIST, script, Arrays.asList(name, this.getTimeoutSetName(name), this.getCreatedChannelName(name), this.getRemovedChannelName(name), this.getUpdatedChannelName(name), this.getCreatedSyncChannelName(name), this.getRemovedSyncChannelName(name), this.getUpdatedSyncChannelName(name), this.getOldValueListenerCounter(name)), params.toArray());
    }

    RFuture<Boolean> putValue(K key, Object value) {
        double syncId = ThreadLocalRandom.current().nextDouble();
        Long creationTimeout = this.getCreationTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        String name = this.getRawName(key);
        RFuture<List<Object>> res = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_LIST, "local expireDateScore = redis.call('zscore', KEYS[2], ARGV[4]);local exists = redis.call('hexists', KEYS[1], ARGV[4]) == 1;if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[3]) then exists = false;end;if exists then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]);local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[6]); local syncs = redis.call('publish', KEYS[7], syncMsg); return {0, syncs};elseif ARGV[2] ~= '-1' then local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1, ARGV[6]); else local value = redis.call('hget', KEYS[1], ARGV[4]);redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value), ARGV[6]); end; redis.call('publish', KEYS[5], msg); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, syncs};else local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1, ARGV[6]); else local value = redis.call('hget', KEYS[1], ARGV[4]);redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value), ARGV[6]); end; redis.call('publish', KEYS[5], msg); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, syncs};end; else if ARGV[1] == '0' then return {0};elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {1, syncs};end; end; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getCreatedChannelName(name), this.getRemovedChannelName(name), this.getUpdatedChannelName(name), this.getCreatedSyncChannelName(name), this.getRemovedSyncChannelName(name), this.getUpdatedSyncChannelName(name), this.getOldValueListenerCounter(name)), creationTimeout, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
        RPromise<Boolean> result = this.waitSync(syncId, res);
        return result;
    }

    RPromise<Boolean> waitSync(double syncId, RFuture<List<Object>> res) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        if (this.atomicExecution) {
            res.onComplete((r, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)new CacheException(e));
                    return;
                }
                r.add(syncId);
                if (r.size() < 2) {
                    result.trySuccess((Long)r.get(0) >= 1L);
                    return;
                }
                Long syncs = (Long)r.get(r.size() - 2);
                if (syncs != null && syncs > 0L) {
                    RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
                    semaphore.acquireAsync(syncs.intValue()).onComplete((obj1, ex) -> {
                        if (ex != null) {
                            result.tryFailure((Throwable)new CacheException(ex));
                            return;
                        }
                        semaphore.deleteAsync().onComplete((obj, exc) -> {
                            if (exc != null) {
                                result.tryFailure((Throwable)new CacheException(exc));
                                return;
                            }
                            result.trySuccess((Long)r.get(0) >= 1L);
                        });
                    });
                } else {
                    result.trySuccess((Long)r.get(0) >= 1L);
                }
            });
        } else {
            res.syncUninterruptibly();
            List<Object> r2 = res.getNow();
            r2.add(syncId);
            this.waitSync(r2);
            result.trySuccess((Long)r2.get(0) >= 1L);
        }
        return result;
    }

    Long getUpdateTimeout(long baseTime) {
        if (this.config.getExpiryPolicy().getExpiryForUpdate() == null) {
            return -1L;
        }
        Long updateTimeout = this.config.getExpiryPolicy().getExpiryForUpdate().getAdjustedTime(baseTime);
        if (this.config.getExpiryPolicy().getExpiryForUpdate().isZero()) {
            updateTimeout = 0L;
        } else if (updateTimeout == Long.MAX_VALUE) {
            updateTimeout = -1L;
        }
        return updateTimeout;
    }

    Long getUpdateTimeout() {
        return this.getUpdateTimeout(System.currentTimeMillis());
    }

    Long getCreationTimeout(long baseTime) {
        if (this.config.getExpiryPolicy().getExpiryForCreation() == null) {
            return -1L;
        }
        Long creationTimeout = this.config.getExpiryPolicy().getExpiryForCreation().getAdjustedTime(baseTime);
        if (this.config.getExpiryPolicy().getExpiryForCreation().isZero()) {
            creationTimeout = 0L;
        } else if (creationTimeout == Long.MAX_VALUE) {
            creationTimeout = -1L;
        }
        return creationTimeout;
    }

    Long getCreationTimeout() {
        return this.getCreationTimeout(System.currentTimeMillis());
    }

    RFuture<Boolean> putIfAbsentValue(K key, Object value) {
        Long creationTimeout = this.getCreationTimeout();
        if (creationTimeout == 0L) {
            return RedissonPromise.newSucceededFuture(false);
        }
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]);local exists = redis.call('hexists', KEYS[1], ARGV[2]) == 1;if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[4]) then exists = false;end;if exists then return 0; else if ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;else redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;end; end; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getCreatedChannelName(name)), creationTimeout, this.encodeMapKey(key), this.encodeMapValue(value), System.currentTimeMillis());
    }

    private boolean putIfAbsentValueLocked(K key, Object value) {
        if (this.containsKey(key)) {
            return false;
        }
        Long creationTimeout = this.getCreationTimeout();
        if (creationTimeout == 0L) {
            return false;
        }
        return (Boolean)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;else redis.call('hset', KEYS[1], ARGV[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(ARGV[3]), ARGV[3]); redis.call('publish', KEYS[3], msg); return 1;end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getCreatedChannelName()), creationTimeout, this.encodeMapKey(key), this.encodeMapValue(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockName(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        try {
            String string = "{" + this.getRawName() + "}:" + Hash.hash128toBase64(keyState) + ":key";
            return string;
        }
        finally {
            keyState.release();
        }
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            this.checkKey(key);
        }
        if (!this.atomicExecution && !this.config.isReadThrough()) {
            long startTime = this.currentNanoTime();
            boolean exists = false;
            for (K key : keys) {
                if (!this.containsKey(key)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                return Collections.emptyMap();
            }
        }
        RFuture<Map<K, V>> result = this.getAllAsync(keys);
        result.syncUninterruptibly();
        return result.getNow();
    }

    @Override
    public RFuture<Map<K, V>> getAllAsync(Set<? extends K> keys) {
        this.checkNotClosed();
        long startTime = this.currentNanoTime();
        Long accessTimeout = this.getAccessTimeout();
        ArrayList<Object> args = new ArrayList<Object>(keys.size() + 2);
        args.add(accessTimeout);
        args.add(System.currentTimeMillis());
        this.encodeMapKeys(args, keys);
        RFuture<Map<K, V>> res = this.getAllOperation(this.commandExecutor, this.getRawName(), null, new ArrayList<K>(keys), accessTimeout, args);
        return this.handleGetAllResult(startTime, res);
    }

    RFuture<Map<K, V>> getAllOperation(CommandAsyncExecutor commandExecutor, String name, MasterSlaveEntry entry, List<Object> keys, Long accessTimeout, List<Object> args) {
        String script = accessTimeout == -1L ? "local expireHead = redis.call('zrange', KEYS[2], 0, 0, 'withscores');local accessTimeout = ARGV[1]; local currentTime = tonumber(ARGV[2]); local hasExpire = #expireHead == 2 and tonumber(expireHead[2]) <= currentTime; local map = {};for i=3, #ARGV, 5000 do local m = redis.call('hmget', KEYS[1], unpack(ARGV, i, math.min(i+4999, #ARGV))); for k,v in ipairs(m) do table.insert(map, v) end; end; local result = {};for i, value in ipairs(map) do if value ~= false then local key = ARGV[i+2]; if hasExpire then local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false and tonumber(expireDateScore) <= currentTime then value = false; end; end; end; table.insert(result, value); end; return result;" : "local expireHead = redis.call('zrange', KEYS[2], 0, 0, 'withscores');local accessTimeout = ARGV[1]; local currentTime = tonumber(ARGV[2]); local hasExpire = #expireHead == 2 and tonumber(expireHead[2]) <= currentTime; local map = {};for i=3, #ARGV, 5000 do local m = redis.call('hmget', KEYS[1], unpack(ARGV, i, math.min(i+4999, #ARGV))); for k,v in ipairs(m) do table.insert(map, v) end; end; local result = {};for i, value in ipairs(map) do if value ~= false then local key = ARGV[i+2]; if hasExpire then local expireDateScore = redis.call('zscore', KEYS[2], key); if expireDateScore ~= false and tonumber(expireDateScore) <= currentTime then value = false; end; end; if accessTimeout == '0' then redis.call('hdel', KEYS[1], key); redis.call('zrem', KEYS[2], key); local msg = struct.pack('Lc0Lc0', string.len(key), key, string.len(value), value); redis.call('publish', KEYS[3], {key, value}); elseif accessTimeout ~= '-1' then redis.call('zadd', KEYS[2], accessTimeout, key); end; end; table.insert(result, value); end; return result;";
        if (entry == null) {
            return commandExecutor.evalReadAsync(name, this.codec, new RedisCommand<Object>("EVAL", new MapValueDecoder(new MapGetAllDecoder(keys, 0, true))), script, Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name)), args.toArray());
        }
        return commandExecutor.evalReadAsync(entry, this.codec, new RedisCommand<Object>("EVAL", new MapValueDecoder(new MapGetAllDecoder(keys, 0, true))), script, Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name)), args.toArray());
    }

    RPromise<Map<K, V>> handleGetAllResult(long startTime, RFuture<Map<K, V>> res) {
        RedissonPromise<Map<K, V>> result = new RedissonPromise<Map<K, V>>();
        res.onComplete((r, ex) -> {
            Map<Object, Object> map = r.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(x -> x.getKey(), x -> x.getValue()));
            this.cacheManager.getStatBean(this).addHits(map.size());
            int nullValues = r.size() - map.size();
            if (this.config.isReadThrough() && nullValues > 0) {
                this.cacheManager.getStatBean(this).addMisses(nullValues);
                this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                    try {
                        r.entrySet().stream().filter(e -> e.getValue() == null).forEach(entry -> {
                            V value = this.loadValue(entry.getKey());
                            if (value != null) {
                                map.put(entry.getKey(), value);
                            }
                        });
                    }
                    catch (Exception exc) {
                        result.tryFailure(exc);
                        return;
                    }
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    result.trySuccess(map);
                });
            } else {
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                result.trySuccess(map);
            }
        });
        return result;
    }

    public boolean containsKey(K key) {
        RFuture<Boolean> future = this.containsKeyAsync(key);
        future.syncUninterruptibly();
        return future.getNow();
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(K key) {
        this.checkNotClosed();
        this.checkKey(key);
        String name = this.getRawName(key);
        RFuture<Boolean> future = this.commandExecutor.evalReadAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hexists', KEYS[1], ARGV[2]) == 0 then return 0;end;local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0; end; return 1;", Arrays.asList(name, this.getTimeoutSetName(name)), System.currentTimeMillis(), this.encodeMapKey(key));
        return future;
    }

    public void loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final CompletionListener completionListener) {
        this.checkNotClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            this.checkKey(key);
        }
        if (this.cacheLoader == null) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
            return;
        }
        this.commandExecutor.getConnectionManager().getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Object key : keys) {
                    try {
                        if (JCache.this.containsKey(key) && !replaceExistingValues) continue;
                        RLock lock = JCache.this.getLockedLock(key);
                        try {
                            Object value;
                            if (JCache.this.containsKey(key) && !replaceExistingValues) continue;
                            try {
                                value = JCache.this.cacheLoader.load(key);
                            }
                            catch (Exception ex) {
                                throw new CacheLoaderException((Throwable)ex);
                            }
                            if (value == null) continue;
                            if (JCache.this.atomicExecution) {
                                JCache.this.putValue(key, value);
                                continue;
                            }
                            JCache.this.putValueLocked(key, value);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    catch (Exception e) {
                        if (completionListener != null) {
                            completionListener.onException(e);
                        }
                        throw e;
                    }
                }
                if (completionListener != null) {
                    completionListener.onCompletion();
                }
            }
        });
    }

    RLock getLockedLock(K key) {
        if (this.atomicExecution) {
            return DUMMY_LOCK;
        }
        String lockName = this.getLockName(key);
        RLock lock = this.redisson.getLock(lockName);
        try {
            lock.lock();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<Void> putAsync(K key, V value) {
        this.checkNotClosed();
        this.checkKey(key);
        if (value == null) {
            throw new NullPointerException();
        }
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                RFuture<List<Object>> future;
                if (this.atomicExecution) {
                    future = this.getAndPutValue(key, value);
                } else {
                    List<Object> res2 = this.getAndPutValueLocked(key, value);
                    future = RedissonPromise.newSucceededFuture(res2);
                }
                future.onComplete((res, ex) -> {
                    if (ex != null) {
                        result.tryFailure((Throwable)new CacheException(ex));
                        return;
                    }
                    if (res.isEmpty()) {
                        this.cacheManager.getStatBean(this).addPuts(1L);
                        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                        result.trySuccess(null);
                        return;
                    }
                    Long added = (Long)res.get(0);
                    if (added == null) {
                        this.cacheManager.getStatBean(this).addPuts(1L);
                        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                        result.trySuccess(null);
                        return;
                    }
                    this.writeCache(key, value, (RPromise<Void>)result, startTime, (List<Object>)res, added);
                });
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            RFuture<Boolean> future;
            if (this.atomicExecution) {
                future = this.putValue(key, value);
            } else {
                boolean res3 = this.putValueLocked(key, value);
                future = RedissonPromise.newSucceededFuture(res3);
            }
            future.onComplete((r, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)new CacheException(e));
                    return;
                }
                if (r.booleanValue()) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                result.trySuccess(null);
            });
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private void writeCache(K key, V value, RPromise<Void> result, long startTime, List<Object> res, Long added) {
        Runnable r = added >= 1L ? () -> {
            try {
                this.cacheWriter.write(new JCacheEntry<Object, Object>(key, value));
                this.cacheManager.getStatBean(this).addPuts(1L);
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                result.trySuccess(null);
            }
            catch (Exception e) {
                this.removeValues(key).onComplete((obj, exc) -> {
                    if (exc != null) {
                        result.tryFailure((Throwable)new CacheWriterException(exc));
                        return;
                    }
                    this.handleException(result, e);
                });
            }
        } : () -> {
            try {
                this.cacheWriter.delete(key);
                this.cacheManager.getStatBean(this).addPuts(1L);
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                result.trySuccess(null);
            }
            catch (Exception e) {
                if (res.size() == 4 && res.get(1) != null) {
                    this.putValue(key, res.get(1)).onComplete((obj, exc) -> {
                        if (exc != null) {
                            result.tryFailure((Throwable)new CacheWriterException(exc));
                            return;
                        }
                        this.handleException(result, e);
                    });
                    return;
                }
                this.handleException(result, e);
            }
        };
        if (this.atomicExecution) {
            this.commandExecutor.getConnectionManager().getExecutor().execute(r);
        } else {
            r.run();
        }
    }

    public void put(K key, V value) {
        RFuture<Void> future = this.putAsync(key, value);
        future.syncUninterruptibly();
    }

    RFuture<Long> removeValues(Object ... keys) {
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.add(System.currentTimeMillis());
        this.encodeMapKeys(params, Arrays.asList(keys));
        return this.removeValuesOperation(this.commandExecutor, this.getRawName(), null, params);
    }

    RFuture<Long> removeValuesOperation(CommandAsyncExecutor commandExecutor, String name, MasterSlaveEntry entry, List<Object> params) {
        String script = "local counter = 0;for i=2, #ARGV do local value = redis.call('hget', KEYS[1], ARGV[i]); if value ~= false then redis.call('hdel', KEYS[1], ARGV[i]); local expireDateScore = redis.call('zscore', KEYS[2], ARGV[i]); if not (expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[1])) then counter = counter + 1;end; redis.call('zrem', KEYS[2], ARGV[i]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[i]), ARGV[i], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); end;end; return counter;";
        if (entry == null) {
            return commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_LONG, script, Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getRemovedSyncChannelName(name)), params.toArray());
        }
        return commandExecutor.evalWriteAsync(entry, this.codec, RedisCommands.EVAL_LONG, script, Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getRemovedSyncChannelName(name)), params.toArray());
    }

    private List<Object> getAndPutValueLocked(K key, V value) {
        double syncId = ThreadLocalRandom.current().nextDouble();
        if (this.containsKey(key)) {
            Long updateTimeout = this.getUpdateTimeout();
            List result = (List)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "local value = redis.call('hget', KEYS[1], ARGV[4]);if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {0, value, syncs};elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1, ARGV[6]); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value), ARGV[6]); end; redis.call('publish', KEYS[5], msg); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, value, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1, ARGV[6]); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value), ARGV[6]); end; redis.call('publish', KEYS[5], msg); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, value, syncs};end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getCreatedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getCreatedSyncChannelName(), this.getUpdatedSyncChannelName(), this.getOldValueListenerCounter()), 0, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
            result.add(syncId);
            this.waitSync(result);
            return result;
        }
        Long creationTimeout = this.getCreationTimeout();
        if (creationTimeout == 0L) {
            return Collections.emptyList();
        }
        List result = (List)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "if ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {1, syncs};end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getCreatedChannelName(), this.getCreatedSyncChannelName()), creationTimeout, 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
        result.add(syncId);
        this.waitSync(result);
        return result;
    }

    RFuture<List<Object>> getAndPutValue(K key, V value) {
        Long creationTimeout = this.getCreationTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        double syncId = ThreadLocalRandom.current().nextDouble();
        RedissonPromise<List<Object>> result = new RedissonPromise<List<Object>>();
        String name = this.getRawName(key);
        RFuture future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_LIST, "local value = redis.call('hget', KEYS[1], ARGV[4]);if value ~= false then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[6]); local syncs = redis.call('publish', KEYS[6], syncMsg); return {0, value, syncs};elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1, ARGV[6]); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value), ARGV[6]); end; redis.call('publish', KEYS[5], msg); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, value, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local oldValueRequired = tonumber(redis.call('get', KEYS[9])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], -1, ARGV[6]); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], string.len(tostring(value)), tostring(value), ARGV[6]); end; redis.call('publish', KEYS[5], msg); local syncs = redis.call('publish', KEYS[8], syncMsg); return {1, value, syncs};end; else if ARGV[1] == '0' then return {nil};elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[7], syncMsg); return {1, syncs};else redis.call('hset', KEYS[1], ARGV[4], ARGV[5]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5]); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[5]), ARGV[5], ARGV[6]); local syncs = redis.call('publish', KEYS[7], syncMsg); return {1, syncs};end; end; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getCreatedChannelName(name), this.getUpdatedChannelName(name), this.getRemovedSyncChannelName(name), this.getCreatedSyncChannelName(name), this.getUpdatedSyncChannelName(name), this.getOldValueListenerCounter(name)), creationTimeout, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
        future.onComplete((r, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (!r.isEmpty()) {
                r.add(syncId);
            }
            result.trySuccess((List<Object>)r);
        });
        return result;
    }

    public V getAndPut(K key, V value) {
        RFuture<V> future = this.getAndPutAsync(key, value);
        future.syncUninterruptibly();
        return future.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<V> getAndPutAsync(K key, V value) {
        this.checkNotClosed();
        this.checkKey(key);
        if (value == null) {
            throw new NullPointerException();
        }
        RedissonPromise result = new RedissonPromise();
        long startTime = this.currentNanoTime();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                RFuture<List<Object>> future;
                if (this.atomicExecution) {
                    future = this.getAndPutValue(key, value);
                } else {
                    List<Object> res2 = this.getAndPutValueLocked(key, value);
                    future = RedissonPromise.newSucceededFuture(res2);
                }
                future.onComplete((res, ex) -> {
                    if (ex != null) {
                        result.tryFailure((Throwable)new CacheException(ex));
                        return;
                    }
                    if (res.isEmpty()) {
                        this.cacheManager.getStatBean(this).addPuts(1L);
                        this.cacheManager.getStatBean(this).addMisses(1L);
                        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                        result.trySuccess(null);
                        return;
                    }
                    Long added = (Long)res.get(0);
                    if (added == null) {
                        this.cacheManager.getStatBean(this).addPuts(1L);
                        this.cacheManager.getStatBean(this).addHits(1L);
                        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                        result.trySuccess(res.get(1));
                        return;
                    }
                    RedissonPromise<Void> writeRes = new RedissonPromise<Void>();
                    this.writeCache(key, value, (RPromise<Void>)writeRes, startTime, (List<Object>)res, added);
                    writeRes.onComplete((r, e) -> {
                        if (e != null) {
                            result.tryFailure((Throwable)e);
                            return;
                        }
                        V val = this.getAndPutResult(startTime, (List<Object>)res);
                        result.trySuccess(val);
                    });
                });
            }
            finally {
                lock.unlock();
            }
        }
        RLock lock = this.getLockedLock(key);
        try {
            RFuture<List<Object>> future;
            if (this.atomicExecution) {
                future = this.getAndPutValue(key, value);
            } else {
                List<Object> res3 = this.getAndPutValueLocked(key, value);
                future = RedissonPromise.newSucceededFuture(res3);
            }
            future.onComplete((r, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)new CacheException(e));
                    return;
                }
                V val = this.getAndPutResult(startTime, (List<Object>)r);
                result.trySuccess(val);
            });
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private V getAndPutResult(long startTime, List<Object> result) {
        if (result.size() != 4) {
            this.cacheManager.getStatBean(this).addPuts(1L);
            this.cacheManager.getStatBean(this).addMisses(1L);
            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
            return null;
        }
        this.cacheManager.getStatBean(this).addPuts(1L);
        this.cacheManager.getStatBean(this).addHits(1L);
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
        return (V)result.get(1);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        RFuture<Void> result = this.putAllAsync(map);
        result.syncUninterruptibly();
    }

    @Override
    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) {
        this.checkNotClosed();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            this.checkKey(key);
            V value = entry.getValue();
            if (value != null) continue;
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        RFuture<Long> future = this.putAllValues(map);
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        Runnable r = () -> {
            HashMap addedEntries = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                addedEntries.put(entry.getKey(), new JCacheEntry(entry.getKey(), entry.getValue()));
            }
            try {
                this.cacheWriter.writeAll(addedEntries.values());
            }
            catch (Exception e) {
                this.removeValues(addedEntries.keySet().toArray()).onComplete((res, ex) -> {
                    if (ex != null) {
                        result.tryFailure((Throwable)new CacheException(ex));
                        return;
                    }
                    this.handleException(result, e);
                });
                return;
            }
            result.trySuccess(null);
        };
        future.onComplete((res, ex) -> {
            if (ex != null) {
                result.tryFailure((Throwable)new CacheException(ex));
                return;
            }
            this.cacheManager.getStatBean(this).addPuts((long)res);
            int i = 0;
            while ((long)i < res) {
                this.cacheManager.getStatBean(this).addPutTime((this.currentNanoTime() - startTime) / res);
                ++i;
            }
        });
        if (this.atomicExecution) {
            future.onComplete((res, ex) -> {
                if (this.config.isWriteThrough()) {
                    this.commandExecutor.getConnectionManager().getExecutor().execute(r);
                } else {
                    result.trySuccess(null);
                }
            });
        } else if (this.config.isWriteThrough()) {
            r.run();
        } else {
            result.trySuccess(null);
        }
        return result;
    }

    void waitSync(List<Object> result) {
        if (result.size() < 2) {
            return;
        }
        Long syncs = (Long)result.get(result.size() - 2);
        Double syncId = (Double)result.get(result.size() - 1);
        if (syncs != null && syncs > 0L) {
            RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
            try {
                semaphore.acquire(syncs.intValue());
                semaphore.delete();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean putIfAbsent(K key, V value) {
        RFuture<Boolean> result = this.putIfAbsentAsync(key, value);
        result.syncUninterruptibly();
        return result.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<Boolean> putIfAbsentAsync(K key, V value) {
        this.checkNotClosed();
        this.checkKey(key);
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        RLock lock = this.getLockedLock(key);
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        try {
            RFuture<Boolean> future;
            if (this.atomicExecution) {
                future = this.putIfAbsentValue(key, value);
            } else {
                boolean r2 = this.putIfAbsentValueLocked(key, value);
                future = RedissonPromise.newSucceededFuture(r2);
            }
            future.onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)new CacheException(ex));
                    return;
                }
                if (r.booleanValue()) {
                    this.cacheManager.getStatBean(this).addPuts(1L);
                    if (this.config.isWriteThrough()) {
                        this.commandExecutor.getConnectionManager().getExecutor().execute(() -> {
                            try {
                                this.cacheWriter.write(new JCacheEntry<Object, Object>(key, value));
                            }
                            catch (Exception e) {
                                this.removeValues(key);
                                this.handleException(result, e);
                                return;
                            }
                            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                            result.trySuccess((Boolean)r);
                        });
                        return;
                    }
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                result.trySuccess((Boolean)r);
            });
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    void handleException(RPromise<?> result, Exception e) {
        if (e instanceof CacheWriterException) {
            result.tryFailure(e);
        }
        result.tryFailure((Throwable)new CacheWriterException((Throwable)e));
    }

    RFuture<Boolean> removeValue(K key) {
        double syncId = ThreadLocalRandom.current().nextDouble();
        String name = this.getRawName(key);
        RFuture<List<Object>> future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_LIST, "local value = redis.call('hexists', KEYS[1], ARGV[2]); if value == 0 then return {0}; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[1]) then return {0}; end; value = redis.call('hget', KEYS[1], ARGV[2]); redis.call('hdel', KEYS[1], ARGV[2]); redis.call('zrem', KEYS[2], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value), ARGV[3]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {1, syncs};", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getRemovedSyncChannelName(name)), System.currentTimeMillis(), this.encodeMapKey(key), syncId);
        RPromise<Boolean> result = this.waitSync(syncId, future);
        return result;
    }

    public boolean remove(K key) {
        RFuture<Boolean> future = this.removeAsync(key);
        future.syncUninterruptibly();
        return future.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<Boolean> removeAsync(K key) {
        this.checkNotClosed();
        this.checkKey(key);
        long startTime = System.currentTimeMillis();
        if (this.config.isWriteThrough()) {
            RLock lock = this.getLockedLock(key);
            try {
                RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
                RFuture<Object> future = this.getAndRemoveValue(key);
                if (this.atomicExecution) {
                    future.onComplete((oldValue, ex) -> {
                        if (ex != null) {
                            result.tryFailure((Throwable)new CacheException(ex));
                            return;
                        }
                        this.commandExecutor.getConnectionManager().getExecutor().submit(() -> {
                            try {
                                this.cacheWriter.delete(key);
                                if (oldValue != null) {
                                    this.cacheManager.getStatBean(this).addRemovals(1L);
                                }
                                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                                result.trySuccess(oldValue != null);
                            }
                            catch (Exception e) {
                                if (oldValue != null) {
                                    this.putValue(key, oldValue);
                                }
                                this.handleException(result, e);
                            }
                        });
                    });
                } else {
                    future.syncUninterruptibly();
                    V oldValue2 = future.getNow();
                    try {
                        this.cacheWriter.delete(key);
                        if (oldValue2 != null) {
                            this.cacheManager.getStatBean(this).addRemovals(1L);
                        }
                        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                        result.trySuccess(oldValue2 != null);
                    }
                    catch (Exception e) {
                        if (oldValue2 != null) {
                            this.putValue(key, oldValue2);
                        }
                        this.handleException(result, e);
                    }
                }
                RedissonPromise<Boolean> redissonPromise = result;
                return redissonPromise;
            }
            finally {
                lock.unlock();
            }
        }
        RFuture<Boolean> result = this.removeValue(key);
        result.onComplete((res, ex) -> {
            if (ex != null) {
                return;
            }
            if (res.booleanValue()) {
                this.cacheManager.getStatBean(this).addRemovals(1L);
            }
            this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
        });
        return result;
    }

    private boolean removeValueLocked(K key, V value) {
        Boolean result = (Boolean)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return 0; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[2]) then return 0; end; if ARGV[4] == value then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); return 1; end; return nil;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName()), 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
        if (result == null) {
            Long accessTimeout = this.getAccessTimeout();
            if (accessTimeout == -1L) {
                return false;
            }
            return (Boolean)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local value = redis.call('hget', KEYS[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName()), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
        }
        return result;
    }

    RFuture<Boolean> removeValue(K key, V value) {
        Long accessTimeout = this.getAccessTimeout();
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return 0; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[2]) then return 0; end; if ARGV[4] == value then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); return 1; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); end; return 0; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name)), accessTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    public boolean remove(K key, V value) {
        RFuture<Boolean> future = this.removeAsync(key, value);
        future.syncUninterruptibly();
        return future.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<Boolean> removeAsync(K key, V value) {
        RedissonPromise<Boolean> result;
        block16: {
            this.checkNotClosed();
            this.checkKey(key);
            if (value == null) {
                throw new NullPointerException();
            }
            long startTime = this.currentNanoTime();
            result = new RedissonPromise<Boolean>();
            if (this.config.isWriteThrough()) {
                RLock lock = this.getLockedLock(key);
                try {
                    if (this.atomicExecution) {
                        RFuture<Boolean> future = this.removeValue(key, value);
                        future.onComplete((r, ex) -> {
                            if (ex != null) {
                                result.tryFailure((Throwable)new CacheException(ex));
                                return;
                            }
                            if (r.booleanValue()) {
                                this.commandExecutor.getConnectionManager().getExecutor().submit(() -> {
                                    try {
                                        this.cacheWriter.delete(key);
                                    }
                                    catch (Exception e) {
                                        this.putValue(key, value);
                                        this.handleException(result, e);
                                        return;
                                    }
                                    this.cacheManager.getStatBean(this).addHits(1L);
                                    this.cacheManager.getStatBean(this).addRemovals(1L);
                                    this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                                    result.trySuccess((Boolean)r);
                                });
                            } else {
                                this.cacheManager.getStatBean(this).addMisses(1L);
                                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                                result.trySuccess((Boolean)r);
                            }
                        });
                        break block16;
                    }
                    boolean res = this.removeValueLocked(key, value);
                    if (res) {
                        try {
                            this.cacheWriter.delete(key);
                        }
                        catch (Exception e) {
                            this.putValue(key, value).syncUninterruptibly();
                            if (e instanceof CacheWriterException) {
                                throw e;
                            }
                            throw new CacheWriterException((Throwable)e);
                        }
                        this.cacheManager.getStatBean(this).addHits(1L);
                        this.cacheManager.getStatBean(this).addRemovals(1L);
                        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                    } else {
                        this.cacheManager.getStatBean(this).addMisses(1L);
                        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                    }
                    RFuture<Boolean> e = RedissonPromise.newSucceededFuture(res);
                    return e;
                }
                finally {
                    lock.unlock();
                }
            }
            RLock lock = this.getLockedLock(key);
            try {
                RFuture<Boolean> future;
                if (this.atomicExecution) {
                    future = this.removeValue(key, value);
                } else {
                    boolean res = this.removeValueLocked(key, value);
                    future = RedissonPromise.newSucceededFuture(res);
                }
                future.onComplete((r, ex) -> {
                    if (ex != null) {
                        result.tryFailure((Throwable)new CacheException(ex));
                        return;
                    }
                    if (r.booleanValue()) {
                        this.cacheManager.getStatBean(this).addHits(1L);
                        this.cacheManager.getStatBean(this).addRemovals(1L);
                    } else {
                        this.cacheManager.getStatBean(this).addMisses(1L);
                    }
                    this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                    result.trySuccess((Boolean)r);
                });
            }
            finally {
                lock.unlock();
            }
        }
        return result;
    }

    RFuture<Map<K, V>> getAndRemoveValues(Collection<K> keys) {
        double syncId = ThreadLocalRandom.current().nextDouble();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(System.currentTimeMillis());
        params.add(syncId);
        for (K key : keys) {
            params.add(this.encodeMapKey(key));
        }
        RFuture<List<Object>> future = this.getAndRemoveValuesOperation(this.commandExecutor, null, this.getRawName(), params);
        RedissonPromise<Map<K, V>> result = new RedissonPromise<Map<K, V>>();
        if (this.atomicExecution) {
            future.onComplete((r, exc1) -> {
                if (exc1 != null) {
                    result.tryFailure((Throwable)exc1);
                    return;
                }
                long nullsAmount = (Long)r.get(1);
                if (nullsAmount == (long)keys.size()) {
                    result.trySuccess(Collections.emptyMap());
                    return;
                }
                long syncs = (Long)r.get(0);
                if (syncs > 0L) {
                    RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
                    semaphore.acquireAsync((int)syncs).onComplete((obj1, ex) -> {
                        if (ex != null) {
                            result.tryFailure((Throwable)ex);
                            return;
                        }
                        semaphore.deleteAsync().onComplete((obj, exc) -> {
                            if (exc != null) {
                                result.tryFailure((Throwable)exc);
                                return;
                            }
                            this.getAndRemoveValuesResult(keys, (RPromise<Map<K, V>>)result, (List<Object>)r, nullsAmount);
                        });
                    });
                } else {
                    this.getAndRemoveValuesResult(keys, (RPromise<Map<K, V>>)result, (List<Object>)r, nullsAmount);
                }
            });
        } else {
            future.syncUninterruptibly();
            List<Object> r2 = future.getNow();
            long nullsAmount = (Long)r2.get(1);
            if (nullsAmount == (long)keys.size()) {
                result.trySuccess(Collections.emptyMap());
                return result;
            }
            long syncs = (Long)r2.get(0);
            if (syncs > 0L) {
                RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
                try {
                    semaphore.acquire((int)syncs);
                    semaphore.delete();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.getAndRemoveValuesResult(keys, result, r2, nullsAmount);
        }
        return result;
    }

    RFuture<List<Object>> getAndRemoveValuesOperation(CommandAsyncExecutor commandExecutor, MasterSlaveEntry entry, String name, List<Object> params) {
        String script = "local syncs = 0; local values = {}; local result = {}; local nulls = {}; for i = 3, #ARGV, 1 do local value = redis.call('hget', KEYS[1], ARGV[i]); if value == false then table.insert(nulls, i-3); else local expireDateScore = redis.call('zscore', KEYS[2], ARGV[i]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[1]) then table.insert(nulls, i-3); else redis.call('hdel', KEYS[1], ARGV[i]); redis.call('zrem', KEYS[2], ARGV[i]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[i]), ARGV[i], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[i]), ARGV[i], string.len(tostring(value)), tostring(value), ARGV[2]); syncs = syncs + redis.call('publish', KEYS[4], syncMsg); table.insert(values, value); end; end; end; table.insert(result, syncs); table.insert(result, #nulls); for i = 1, #nulls, 1 do table.insert(result, nulls[i]); end; for i = 1, #values, 1 do table.insert(result, values[i]); end; return result; ";
        if (entry == null) {
            return commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE_LIST, script, Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getRemovedSyncChannelName(name)), params.toArray());
        }
        return commandExecutor.evalWriteAsync(entry, this.codec, RedisCommands.EVAL_MAP_VALUE_LIST, script, Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getRemovedSyncChannelName(name)), params.toArray());
    }

    private void getAndRemoveValuesResult(Collection<K> keys, RPromise<Map<K, V>> result, List<Object> r, long nullsAmount) {
        HashMap res = new HashMap();
        this.fillMap(keys, r, res, nullsAmount, 0);
        result.trySuccess(res);
    }

    void fillMap(Collection<K> keys, List<Object> r, Map<K, V> res, long nullsAmount, int baseIndex) {
        List<Object> list = r.subList(baseIndex + 2, baseIndex + (int)nullsAmount + 2);
        HashSet<Object> nullIndexes = new HashSet<Object>(list);
        long i = 0L;
        for (K key : keys) {
            if (nullIndexes.contains(i)) continue;
            Object value = r.get((int)((long)baseIndex + i + nullsAmount + 2L));
            res.put(key, value);
            ++i;
        }
    }

    RFuture<V> getAndRemoveValue(K key) {
        double syncId = ThreadLocalRandom.current().nextDouble();
        RedissonPromise result = new RedissonPromise();
        String name = this.getRawName(key);
        RFuture future = this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE_LIST, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value == false then return {nil}; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[1]) then return {nil}; end; redis.call('hdel', KEYS[1], ARGV[2]); redis.call('zrem', KEYS[2], ARGV[2]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[2]), ARGV[2], string.len(tostring(value)), tostring(value), ARGV[3]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {value, syncs}; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getRemovedSyncChannelName(name)), System.currentTimeMillis(), this.encodeMapKey(key), syncId);
        if (this.atomicExecution) {
            future.onComplete((r, exc1) -> {
                if (exc1 != null) {
                    result.tryFailure((Throwable)exc1);
                    return;
                }
                if (r.size() < 2) {
                    result.trySuccess(null);
                    return;
                }
                Long syncs = (Long)r.get(1);
                if (syncs != null && syncs > 0L) {
                    RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
                    semaphore.acquireAsync(syncs.intValue()).onComplete((obj1, ex) -> {
                        if (ex != null) {
                            result.tryFailure((Throwable)ex);
                            return;
                        }
                        semaphore.deleteAsync().onComplete((obj, exc) -> {
                            if (exc != null) {
                                result.tryFailure((Throwable)exc);
                                return;
                            }
                            result.trySuccess(r.get(0));
                        });
                    });
                } else {
                    result.trySuccess(r.get(0));
                }
            });
        } else {
            future.syncUninterruptibly();
            List r2 = (List)future.getNow();
            if (r2.size() < 2) {
                result.trySuccess(null);
                return result;
            }
            Long syncs = (Long)r2.get(1);
            if (syncs != null && syncs > 0L) {
                RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
                try {
                    semaphore.acquire(syncs.intValue());
                    semaphore.delete();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            result.trySuccess(r2.get(0));
        }
        return result;
    }

    public V getAndRemove(K key) {
        RFuture<V> future = this.getAndRemoveAsync(key);
        future.syncUninterruptibly();
        return future.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<V> getAndRemoveAsync(K key) {
        this.checkNotClosed();
        this.checkKey(key);
        long startTime = this.currentNanoTime();
        RedissonPromise result = new RedissonPromise();
        RLock lock = this.getLockedLock(key);
        try {
            RFuture<Object> future = this.getAndRemoveValue(key);
            future.onComplete((value, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)new CacheException(e));
                    return;
                }
                if (value != null) {
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addRemovals(1L);
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                if (this.config.isWriteThrough()) {
                    this.commandExecutor.getConnectionManager().getExecutor().submit(() -> {
                        try {
                            this.cacheWriter.delete(key);
                        }
                        catch (Exception ex) {
                            if (value != null) {
                                this.putValue(key, value);
                            }
                            this.handleException(result, ex);
                            return;
                        }
                        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                        this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                        result.trySuccess(value);
                    });
                } else {
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                    result.trySuccess(value);
                }
            });
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private long replaceValueLocked(K key, V oldValue, V newValue) {
        Long res = (Long)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LONG, "local value = redis.call('hget', KEYS[1], ARGV[4]); if value == false then return 0; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[4]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[3]) then return 0; end; if ARGV[5] == value then return 1;end; return -1;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), 0, 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue));
        if (res == 1L) {
            Long updateTimeout = this.getUpdateTimeout();
            double syncId = ThreadLocalRandom.current().nextDouble();
            Long syncs = (Long)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LONG, "if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[7]); return redis.call('publish', KEYS[5], syncMsg); elseif ARGV[2] ~= '-1' then local oldValueRequired = tonumber(redis.call('get', KEYS[7])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], -1, ARGV[7]); else local value = redis.call('hget', KEYS[1], ARGV[4]); redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], string.len(tostring(value)), tostring(value), ARGV[7]); end; redis.call('publish', KEYS[4], msg); return redis.call('publish', KEYS[6], syncMsg); else redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); local msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], -1); redis.call('publish', KEYS[4], msg); local syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], -1, ARGV[7]); return redis.call('publish', KEYS[6], syncMsg); end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName(), this.getOldValueListenerCounter()), 0, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue), syncId);
            List<Object> result = Arrays.asList(syncs, syncId);
            this.waitSync(result);
            return res;
        }
        if (res == 0L) {
            return res;
        }
        Long accessTimeout = this.getAccessTimeout();
        if (accessTimeout == -1L) {
            return -1L;
        }
        double syncId = ThreadLocalRandom.current().nextDouble();
        List result = (List)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local value = redis.call('hget', KEYS[1], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(value), value); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[4]), ARGV[4], string.len(value), value, ARGV[7]); local syncs = redis.call('publish', KEYS[4], syncMsg); return {-1, syncs}; elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); return {0};end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getRemovedSyncChannelName()), accessTimeout, 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue), syncId);
        result.add(syncId);
        this.waitSync(result);
        return (Long)result.get(0);
    }

    RFuture<Long> replaceValue(K key, V oldValue, V newValue) {
        Long accessTimeout = this.getAccessTimeout();
        Long updateTimeout = this.getUpdateTimeout();
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_LONG, "local value = redis.call('hget', KEYS[1], ARGV[4]); if value == false then return 0; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[4]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[3]) then return 0; end; if ARGV[5] == value then if ARGV[2] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[2] ~= '-1' then redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); redis.call('zadd', KEYS[2], ARGV[2], ARGV[4]); local oldValueRequired = tonumber(redis.call('get', KEYS[5])); local msg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], -1); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], string.len(tostring(value)), tostring(value)); end; redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[4], ARGV[6]); local oldValueRequired = tonumber(redis.call('get', KEYS[5])); local msg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], -1); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(ARGV[6]), ARGV[6], string.len(tostring(value)), tostring(value)); end; redis.call('publish', KEYS[4], msg); end; return 1;end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[4]); redis.call('zrem', KEYS[2], ARGV[4]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[4]), ARGV[4], string.len(value), value); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('zadd', KEYS[2], ARGV[1], ARGV[4]); return 0;end; return -1; ", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getUpdatedChannelName(name), this.getOldValueListenerCounter(name)), accessTimeout, updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(oldValue), this.encodeMapValue(newValue));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        RFuture<Boolean> future = this.replaceAsync(key, oldValue, newValue);
        future.syncUninterruptibly();
        return future.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        this.checkNotClosed();
        this.checkKey(key);
        if (oldValue == null) {
            throw new NullPointerException();
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        RLock lock = this.getLockedLock(key);
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        try {
            RFuture<Long> future;
            if (this.atomicExecution) {
                future = this.replaceValue(key, oldValue, newValue);
            } else {
                long res2 = this.replaceValueLocked(key, oldValue, newValue);
                future = RedissonPromise.newSucceededFuture(res2);
            }
            future.onComplete((res, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)new CacheException(ex));
                    return;
                }
                if (res == 1L) {
                    if (this.config.isWriteThrough()) {
                        this.commandExecutor.getConnectionManager().getExecutor().submit(() -> {
                            try {
                                this.cacheWriter.write(new JCacheEntry<Object, Object>(key, newValue));
                            }
                            catch (Exception e) {
                                this.removeValues(key);
                                this.handleException(result, e);
                                return;
                            }
                            this.cacheManager.getStatBean(this).addHits(1L);
                            this.cacheManager.getStatBean(this).addPuts(1L);
                            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                            result.trySuccess(true);
                        });
                    } else {
                        this.cacheManager.getStatBean(this).addHits(1L);
                        this.cacheManager.getStatBean(this).addPuts(1L);
                        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                        this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                        result.trySuccess(true);
                    }
                } else {
                    if (res == 0L) {
                        this.cacheManager.getStatBean(this).addMisses(1L);
                    } else {
                        this.cacheManager.getStatBean(this).addHits(1L);
                    }
                    this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                    this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                    result.trySuccess(false);
                }
            });
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private boolean replaceValueLocked(K key, V value) {
        if (this.containsKey(key)) {
            double syncId = ThreadLocalRandom.current().nextDouble();
            Long updateTimeout = this.getUpdateTimeout();
            Long syncs = (Long)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LONG, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local value = redis.call('hget', KEYS[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value), ARGV[5]); return redis.call('publish', KEYS[5], syncMsg); elseif ARGV[1] ~= '-1' then local oldValueRequired = tonumber(redis.call('get', KEYS[7])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1, ARGV[5]); else local value = redis.call('hget', KEYS[1], ARGV[3]); redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[5]); end; redis.call('publish', KEYS[4], msg); return redis.call('publish', KEYS[6], syncMsg); else local oldValueRequired = tonumber(redis.call('get', KEYS[7])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1, ARGV[5]); else local value = redis.call('hget', KEYS[1], ARGV[3]); redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[5]); end; redis.call('publish', KEYS[4], msg); return redis.call('publish', KEYS[6], syncMsg); end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName(), this.getOldValueListenerCounter()), updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
            List<Object> result = Arrays.asList(syncs, syncId);
            this.waitSync(result);
            return true;
        }
        return false;
    }

    RFuture<Boolean> replaceValue(K key, V value) {
        Long updateTimeout = this.getUpdateTimeout();
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return 0; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[2]) then return 0; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); local oldValueRequired = tonumber(redis.call('get', KEYS[5])); local msg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); end; redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); local oldValueRequired = tonumber(redis.call('get', KEYS[5])); local msg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); end; redis.call('publish', KEYS[4], msg); end; return 1;", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getUpdatedChannelName(name), this.getOldValueListenerCounter(name)), updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    RFuture<V> getAndReplaceValue(K key, V value) {
        Long updateTimeout = this.getUpdateTimeout();
        String name = this.getRawName(key);
        return this.commandExecutor.evalWriteAsync(name, this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[2]) then return nil; end; if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); elseif ARGV[1] ~= '-1' then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); local oldValueRequired = tonumber(redis.call('get', KEYS[5])); local msg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); end; redis.call('publish', KEYS[4], msg); else redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); local oldValueRequired = tonumber(redis.call('get', KEYS[5])); local msg; if oldValueRequired == nil or oldValueRequired < 1 then msg = struct.pack('Lc0Lc0h', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1); else msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); end; redis.call('publish', KEYS[4], msg); end; return value;", Arrays.asList(name, this.getTimeoutSetName(name), this.getRemovedChannelName(name), this.getUpdatedChannelName(name), this.getOldValueListenerCounter(name)), updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
    }

    private V getAndReplaceValueLocked(K key, V value) {
        Object oldValue = this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local value = redis.call('hget', KEYS[1], ARGV[3]); if value == false then return nil; end; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) <= tonumber(ARGV[2]) then return nil; end; return value;", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName()), 0, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value));
        if (oldValue != null) {
            Long updateTimeout = this.getUpdateTimeout();
            double syncId = ThreadLocalRandom.current().nextDouble();
            Long syncs = (Long)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_LONG, "if ARGV[1] == '0' then redis.call('hdel', KEYS[1], ARGV[3]); redis.call('zrem', KEYS[2], ARGV[3]); local value = redis.call('hget', KEYS[1], ARGV[3]); local msg = struct.pack('Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value)); redis.call('publish', KEYS[3], msg); local syncMsg = struct.pack('Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(tostring(value)), tostring(value), ARGV[5]); return redis.call('publish', KEYS[5], msg); elseif ARGV[1] ~= '-1' then local oldValueRequired = tonumber(redis.call('get', KEYS[7])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1, ARGV[5]); else local value = redis.call('hget', KEYS[1], ARGV[3]); redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); redis.call('zadd', KEYS[2], ARGV[1], ARGV[3]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[5]); end; redis.call('publish', KEYS[4], msg); return redis.call('publish', KEYS[6], syncMsg); else local oldValueRequired = tonumber(redis.call('get', KEYS[7])); local msg, syncMsg; if oldValueRequired == nil or oldValueRequired < 1 then redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); msg = struct.pack('Lc0Lc0h', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1); syncMsg = struct.pack('Lc0Lc0hd', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], -1, ARGV[5]); else local value = redis.call('hget', KEYS[1], ARGV[3]); redis.call('hset', KEYS[1], ARGV[3], ARGV[4]); msg = struct.pack('Lc0Lc0Lc0', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value)); syncMsg = struct.pack('Lc0Lc0Lc0d', string.len(ARGV[3]), ARGV[3], string.len(ARGV[4]), ARGV[4], string.len(tostring(value)), tostring(value), ARGV[5]); end; redis.call('publish', KEYS[4], msg); return redis.call('publish', KEYS[6], syncMsg); end; ", Arrays.asList(this.getRawName(), this.getTimeoutSetName(), this.getRemovedChannelName(), this.getUpdatedChannelName(), this.getRemovedSyncChannelName(), this.getUpdatedSyncChannelName(), this.getOldValueListenerCounter()), updateTimeout, System.currentTimeMillis(), this.encodeMapKey(key), this.encodeMapValue(value), syncId);
            List<Object> result = Arrays.asList(syncs, syncId);
            this.waitSync(result);
        }
        return (V)oldValue;
    }

    private void incrementOldValueListenerCounter(String counterName) {
        this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "return redis.call('incr', KEYS[1]);", Arrays.asList(counterName), new Object[0]);
    }

    private void decrementOldValueListenerCounter(String counterName) {
        this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "return redis.call('decr', KEYS[1]);", Arrays.asList(counterName), new Object[0]);
    }

    private Integer getOldValueListenerCount(String counterName) {
        return (Integer)this.evalWrite(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "return tonumber(redis.call('get', KEYS[1]));", Arrays.asList(counterName), new Object[0]);
    }

    public boolean replace(K key, V value) {
        RFuture<Boolean> future = this.replaceAsync(key, value);
        future.syncUninterruptibly();
        return future.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<Boolean> replaceAsync(K key, V value) {
        this.checkNotClosed();
        this.checkKey(key);
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        RLock lock = this.getLockedLock(key);
        try {
            RFuture<Boolean> future;
            if (this.atomicExecution) {
                future = this.replaceValue(key, value);
            } else {
                boolean res = this.replaceValueLocked(key, value);
                future = RedissonPromise.newSucceededFuture(res);
            }
            future.onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)new CacheException(ex));
                    return;
                }
                if (r.booleanValue()) {
                    if (this.config.isWriteThrough()) {
                        this.commandExecutor.getConnectionManager().getExecutor().submit(() -> {
                            try {
                                this.cacheWriter.write(new JCacheEntry<Object, Object>(key, value));
                            }
                            catch (Exception e) {
                                this.removeValues(key);
                                this.handleException(result, e);
                            }
                            this.cacheManager.getStatBean(this).addHits(1L);
                            this.cacheManager.getStatBean(this).addPuts(1L);
                            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                            result.trySuccess((Boolean)r);
                        });
                        return;
                    }
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addPuts(1L);
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                result.trySuccess((Boolean)r);
            });
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public V getAndReplace(K key, V value) {
        RFuture<V> future = this.getAndReplaceAsync(key, value);
        future.syncUninterruptibly();
        return future.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RFuture<V> getAndReplaceAsync(K key, V value) {
        this.checkNotClosed();
        this.checkKey(key);
        if (value == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        RedissonPromise result = new RedissonPromise();
        RLock lock = this.getLockedLock(key);
        try {
            RFuture<Object> future;
            if (this.atomicExecution) {
                future = this.getAndReplaceValue(key, value);
            } else {
                V res = this.getAndReplaceValueLocked(key, value);
                future = RedissonPromise.newSucceededFuture(res);
            }
            future.onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)new CacheException(ex));
                    return;
                }
                if (r != null) {
                    if (this.config.isWriteThrough()) {
                        this.commandExecutor.getConnectionManager().getExecutor().submit(() -> {
                            this.cacheManager.getStatBean(this).addHits(1L);
                            this.cacheManager.getStatBean(this).addPuts(1L);
                            try {
                                this.cacheWriter.write(new JCacheEntry<Object, Object>(key, value));
                            }
                            catch (Exception e) {
                                this.removeValues(key);
                                this.handleException(result, e);
                                return;
                            }
                            this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                            this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                            result.trySuccess(r);
                        });
                        return;
                    }
                    this.cacheManager.getStatBean(this).addHits(1L);
                    this.cacheManager.getStatBean(this).addPuts(1L);
                } else {
                    this.cacheManager.getStatBean(this).addMisses(1L);
                }
                this.cacheManager.getStatBean(this).addPutTime(this.currentNanoTime() - startTime);
                this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
                result.trySuccess(r);
            });
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public void removeAll(Set<? extends K> keys) {
        RFuture<Void> future = this.removeAllAsync(keys);
        future.syncUninterruptibly();
    }

    @Override
    public RFuture<Void> removeAllAsync(Set<? extends K> keys) {
        this.checkNotClosed();
        for (K key : keys) {
            this.checkKey(key);
        }
        long startTime = this.currentNanoTime();
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        if (this.config.isWriteThrough()) {
            RFuture<Map<K, Map>> future = this.getAndRemoveValues(keys);
            future.onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                try {
                    this.cacheWriter.deleteAll(r.keySet());
                }
                catch (Exception e) {
                    this.putAllValues((Map<? extends K, ? extends V>)r);
                    this.handleException(result, e);
                    return;
                }
                this.cacheManager.getStatBean(this).addRemovals(r.size());
                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                result.trySuccess(null);
            });
        } else {
            RFuture<Long> future = this.removeValues(keys.toArray());
            future.onComplete((res, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                this.cacheManager.getStatBean(this).addRemovals((long)res);
                this.cacheManager.getStatBean(this).addRemoveTime(this.currentNanoTime() - startTime);
                result.trySuccess(null);
            });
        }
        return result;
    }

    MapScanResult<Object, Object> scanIterator(String name, RedisClient client, long startPos) {
        RFuture f = this.commandExecutor.readAsync(client, name, this.codec, RedisCommands.HSCAN, name, startPos, "COUNT", 50);
        try {
            return (MapScanResult)this.get((K)f);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    Iterator<K> keyIterator() {
        return new RedissonBaseMapIterator<K>(){

            @Override
            protected K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }

            @Override
            protected void remove(Map.Entry<Object, Object> value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected Object put(Map.Entry<Object, Object> entry, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected ScanResult<Map.Entry<Object, Object>> iterator(RedisClient client, long nextIterPos) {
                return JCache.this.scanIterator(JCache.this.getRawName(), client, nextIterPos);
            }
        };
    }

    public void removeAll() {
        this.checkNotClosed();
        HashSet<K> keys = new HashSet<K>();
        Iterator<K> iterator = this.keyIterator();
        while (iterator.hasNext()) {
            K key = iterator.next();
            keys.add(key);
            if (keys.size() != 50) continue;
            this.removeAll(keys);
            keys.clear();
        }
        if (!keys.isEmpty()) {
            this.removeAll(keys);
        }
    }

    public void clear() {
        RFuture<Void> future = this.clearAsync();
        future.syncUninterruptibly();
    }

    @Override
    public RFuture<Void> clearAsync() {
        this.checkNotClosed();
        return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_OBJECTS, this.getRawName(), this.getTimeoutSetName());
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.config)) {
            return (C)((Configuration)clazz.cast(this.config));
        }
        throw new IllegalArgumentException("Configuration object is not an instance of " + clazz);
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.checkNotClosed();
        this.checkKey(key);
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        long startTime = this.currentNanoTime();
        if (this.containsKey(key)) {
            this.cacheManager.getStatBean(this).addHits(1L);
        } else {
            this.cacheManager.getStatBean(this).addMisses(1L);
        }
        this.cacheManager.getStatBean(this).addGetTime(this.currentNanoTime() - startTime);
        JMutableEntry<K, Object> entry = new JMutableEntry<K, Object>(this, key, null, this.config.isReadThrough());
        RLock lock = this.getLockedLock(key);
        try {
            Object result = entryProcessor.process(entry, arguments);
            if (entry.getAction() == JMutableEntry.Action.CREATED || entry.getAction() == JMutableEntry.Action.UPDATED) {
                this.put(key, entry.value());
            }
            if (entry.getAction() == JMutableEntry.Action.DELETED) {
                this.remove(key);
            }
            Object object = result;
            return (T)object;
        }
        catch (EntryProcessorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EntryProcessorException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkNotClosed();
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        HashMap<K, Object> results = new HashMap<K, Object>();
        for (K key : keys) {
            try {
                final T result = this.invoke(key, entryProcessor, arguments);
                if (result == null) continue;
                results.put(key, new EntryProcessorResult<T>(){

                    public T get() throws EntryProcessorException {
                        return result;
                    }
                });
            }
            catch (EntryProcessorException e) {
                results.put(key, new EntryProcessorResult<T>(){

                    public T get() throws EntryProcessorException {
                        throw e;
                    }
                });
            }
        }
        return results;
    }

    public CacheManager getCacheManager() {
        this.checkNotClosed();
        return this.cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            return;
        }
        JCacheManager jCacheManager = this.cacheManager;
        synchronized (jCacheManager) {
            if (!this.isClosed()) {
                if (this.hasOwnRedisson) {
                    this.redisson.shutdown();
                }
                this.cacheManager.closeCache(this);
                for (CacheEntryListenerConfiguration config : this.listeners.keySet()) {
                    this.deregisterCacheEntryListener(config);
                }
                this.closed = true;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (clazz == CacheAsync.class) {
            return (T)this;
        }
        if (clazz == CacheReactive.class) {
            return (T)ReactiveProxyBuilder.create(((RedissonReactive)this.redisson.reactive()).getCommandExecutor(), this, CacheReactive.class);
        }
        if (clazz == CacheRx.class) {
            return (T)RxProxyBuilder.create(((RedissonRx)this.redisson.rxJava()).getCommandExecutor(), this, CacheRx.class);
        }
        return null;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.registerCacheEntryListener(cacheEntryListenerConfiguration, true);
    }

    private void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean addToConfig) {
        int listenerId;
        RTopic topic;
        String channelName;
        if (this.osType == null) {
            RFuture serverFuture = this.commandExecutor.readAsync((String)null, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_SERVER, new Object[0]);
            serverFuture.syncUninterruptibly();
            String os = (String)((Map)serverFuture.getNow()).get("os");
            if (os.contains("Windows")) {
                this.osType = BaseEventCodec.OSType.WINDOWS;
            } else if (os.contains("NONSTOP")) {
                this.osType = BaseEventCodec.OSType.HPNONSTOP;
            }
        }
        Factory factory = cacheEntryListenerConfiguration.getCacheEntryListenerFactory();
        final CacheEntryListener listener = (CacheEntryListener)factory.create();
        Factory filterFactory = cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory();
        final CacheEntryEventFilter filter = filterFactory != null ? (CacheEntryEventFilter)filterFactory.create() : null;
        Map<Integer, String> values = new ConcurrentHashMap();
        Map oldValues = this.listeners.putIfAbsent(cacheEntryListenerConfiguration, values);
        if (oldValues != null) {
            values = oldValues;
        }
        final boolean sync = cacheEntryListenerConfiguration.isSynchronous();
        if (CacheEntryRemovedListener.class.isAssignableFrom(listener.getClass())) {
            channelName = this.getRemovedChannelName();
            if (sync) {
                channelName = this.getRemovedSyncChannelName();
            }
            topic = this.redisson.getTopic(channelName, new JCacheEventCodec(this.codec, this.osType, sync));
            listenerId = topic.addListener(List.class, new MessageListener<List<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.REMOVED, msg.get(0), msg.get(1), msg.get(1));
                    try {
                        if (filter == null || filter.evaluate(event)) {
                            List events = Collections.singletonList(event);
                            ((CacheEntryRemovedListener)listener).onRemoved(events);
                        }
                    }
                    finally {
                        JCache.this.sendSync(sync, msg);
                    }
                }
            });
            values.put(listenerId, channelName);
        }
        if (CacheEntryCreatedListener.class.isAssignableFrom(listener.getClass())) {
            channelName = this.getCreatedChannelName();
            if (sync) {
                channelName = this.getCreatedSyncChannelName();
            }
            topic = this.redisson.getTopic(channelName, new JCacheEventCodec(this.codec, this.osType, sync));
            listenerId = topic.addListener(List.class, new MessageListener<List<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.CREATED, msg.get(0), msg.get(1));
                    try {
                        if (filter == null || filter.evaluate(event)) {
                            List events = Collections.singletonList(event);
                            ((CacheEntryCreatedListener)listener).onCreated(events);
                        }
                    }
                    finally {
                        JCache.this.sendSync(sync, msg);
                    }
                }
            });
            values.put(listenerId, channelName);
        }
        if (CacheEntryUpdatedListener.class.isAssignableFrom(listener.getClass())) {
            channelName = this.getUpdatedChannelName();
            if (sync) {
                channelName = this.getUpdatedSyncChannelName();
            }
            if (cacheEntryListenerConfiguration.isOldValueRequired()) {
                this.incrementOldValueListenerCounter(this.getOldValueListenerCounter());
            }
            topic = this.redisson.getTopic(channelName, new JCacheEventCodec(this.codec, this.osType, sync, true));
            listenerId = topic.addListener(List.class, new MessageListener<List<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.UPDATED, msg.get(0), msg.get(1), msg.get(2));
                    try {
                        if (filter == null || filter.evaluate(event)) {
                            List events = Collections.singletonList(event);
                            ((CacheEntryUpdatedListener)listener).onUpdated(events);
                        }
                    }
                    finally {
                        JCache.this.sendSync(sync, msg);
                    }
                }
            });
            values.put(listenerId, channelName);
        }
        if (CacheEntryExpiredListener.class.isAssignableFrom(listener.getClass())) {
            channelName = this.getExpiredChannelName();
            topic = this.redisson.getTopic(channelName, new JCacheEventCodec(this.codec, this.osType, false));
            listenerId = topic.addListener(List.class, new MessageListener<List<Object>>(){

                @Override
                public void onMessage(CharSequence channel, List<Object> msg) {
                    JCacheEntryEvent event = new JCacheEntryEvent(JCache.this, EventType.EXPIRED, msg.get(0), msg.get(1), msg.get(1));
                    if (filter == null || filter.evaluate(event)) {
                        List events = Collections.singletonList(event);
                        ((CacheEntryExpiredListener)listener).onExpired(events);
                    }
                }
            });
            values.put(listenerId, channelName);
        }
        if (addToConfig) {
            this.config.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        }
    }

    private void sendSync(boolean sync, List<Object> msg) {
        if (sync) {
            Object syncId = msg.get(msg.size() - 1);
            RSemaphore semaphore = this.redisson.getSemaphore(this.getSyncName(syncId));
            semaphore.release();
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        CacheEntryListener listener;
        Map listenerIds = (Map)this.listeners.remove(cacheEntryListenerConfiguration);
        if (listenerIds != null) {
            for (Map.Entry entry : listenerIds.entrySet()) {
                this.redisson.getTopic((String)entry.getValue()).removeListener((Integer)entry.getKey());
            }
        }
        if (cacheEntryListenerConfiguration.isOldValueRequired() && CacheEntryUpdatedListener.class.isAssignableFrom((listener = (CacheEntryListener)cacheEntryListenerConfiguration.getCacheEntryListenerFactory().create()).getClass())) {
            this.decrementOldValueListenerCounter(this.getOldValueListenerCounter());
        }
        this.config.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkNotClosed();
        return new RedissonBaseMapIterator<Cache.Entry<K, V>>(){

            @Override
            protected Cache.Entry<K, V> getValue(Map.Entry<Object, Object> entry) {
                JCache.this.cacheManager.getStatBean(JCache.this).addHits(1L);
                Long accessTimeout = JCache.this.getAccessTimeout();
                JCacheEntry<Object, Object> je = new JCacheEntry<Object, Object>(entry.getKey(), entry.getValue());
                if (accessTimeout == 0L) {
                    this.remove();
                } else if (accessTimeout != -1L) {
                    JCache.this.write(JCache.this.getRawName(), RedisCommands.ZADD_BOOL, new Object[]{JCache.this.getTimeoutSetName(), accessTimeout, JCache.this.encodeMapKey(entry.getKey())});
                }
                return je;
            }

            @Override
            protected void remove(Map.Entry<Object, Object> entry) {
                JCache.this.remove(entry.getKey());
            }

            @Override
            protected Object put(Map.Entry<Object, Object> entry, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected ScanResult<Map.Entry<Object, Object>> iterator(RedisClient client, long nextIterPos) {
                return JCache.this.scanIterator(JCache.this.getRawName(), client, nextIterPos);
            }
        };
    }
}

