/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.redisson.RedissonShutdownException;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.cache.LRUCacheMap;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisBusyException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClusterDownException;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisResponseTimeoutException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisExecutor<V, R> {
    static final Logger log = LoggerFactory.getLogger(RedisExecutor.class);
    final boolean readOnlyMode;
    final RedisCommand<V> command;
    final Object[] params;
    final RPromise<R> mainPromise;
    final boolean ignoreRedirect;
    final RedissonObjectBuilder objectBuilder;
    final ConnectionManager connectionManager;
    final RedissonObjectBuilder.ReferenceType referenceType;
    RFuture<RedisConnection> connectionFuture;
    NodeSource source;
    Codec codec;
    volatile int attempt;
    volatile Timeout timeout;
    volatile BiConsumer<R, Throwable> mainPromiseListener;
    volatile ChannelFuture writeFuture;
    volatile RedisException exception;
    int attempts;
    long retryInterval;
    long responseTimeout;
    private static final Map<ClassLoader, Map<Codec, Codec>> CODECS = new LRUCacheMap<ClassLoader, Map<Codec, Codec>>(25, 0L, 0L);

    public RedisExecutor(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, boolean ignoreRedirect, ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, RedissonObjectBuilder.ReferenceType referenceType) {
        this.readOnlyMode = readOnlyMode;
        this.source = source;
        this.codec = codec;
        this.command = command;
        this.params = params;
        this.mainPromise = mainPromise;
        this.ignoreRedirect = ignoreRedirect;
        this.connectionManager = connectionManager;
        this.objectBuilder = objectBuilder;
        this.attempts = connectionManager.getConfig().getRetryAttempts();
        this.retryInterval = connectionManager.getConfig().getRetryInterval();
        this.responseTimeout = connectionManager.getConfig().getTimeout();
        this.referenceType = referenceType;
    }

    public void execute() {
        if (this.mainPromise.isCancelled()) {
            this.free();
            return;
        }
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            this.free();
            this.mainPromise.tryFailure(new RedissonShutdownException("Redisson is shutdown"));
            return;
        }
        this.codec = this.getCodec(this.codec);
        RFuture<RedisConnection> connectionFuture = this.getConnection();
        final RedissonPromise attemptPromise = new RedissonPromise();
        this.mainPromiseListener = (r, e) -> {
            if (this.mainPromise.isCancelled() && connectionFuture.cancel(false)) {
                log.debug("Connection obtaining canceled for {}", this.command);
                this.timeout.cancel();
                if (attemptPromise.cancel(false)) {
                    this.free();
                }
            }
        };
        if (this.attempt == 0) {
            this.mainPromise.onComplete((r, e) -> {
                if (this.mainPromiseListener != null) {
                    this.mainPromiseListener.accept((R)r, (Throwable)e);
                }
            });
        }
        this.scheduleRetryTimeout(connectionFuture, attemptPromise);
        connectionFuture.onComplete((connection, e) -> {
            if (connectionFuture.isCancelled()) {
                this.connectionManager.getShutdownLatch().release();
                return;
            }
            if (!connectionFuture.isSuccess()) {
                this.connectionManager.getShutdownLatch().release();
                this.exception = this.convertException(connectionFuture);
                return;
            }
            this.sendCommand(attemptPromise, (RedisConnection)connection);
            this.writeFuture.addListener((GenericFutureListener)new ChannelFutureListener((RedisConnection)connection){
                final /* synthetic */ RedisConnection val$connection;
                {
                    this.val$connection = redisConnection;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    RedisExecutor.this.checkWriteFuture(RedisExecutor.this.writeFuture, attemptPromise, this.val$connection);
                }
            });
        });
        attemptPromise.onComplete((r, e) -> {
            this.releaseConnection(attemptPromise, connectionFuture);
            this.checkAttemptPromise(attemptPromise, connectionFuture);
        });
    }

    private void scheduleRetryTimeout(final RFuture<RedisConnection> connectionFuture, final RPromise<R> attemptPromise) {
        TimerTask retryTimerTask = new TimerTask(){

            public void run(Timeout t) throws Exception {
                if (attemptPromise.isDone()) {
                    return;
                }
                if (connectionFuture.cancel(false)) {
                    if (RedisExecutor.this.exception == null) {
                        RedisExecutor.this.exception = new RedisTimeoutException("Unable to acquire connection! " + connectionFuture + "Increase connection pool size. Node source: " + RedisExecutor.this.source + ", command: " + LogHelper.toString(RedisExecutor.this.command, RedisExecutor.this.params) + " after " + RedisExecutor.this.attempt + " retry attempts");
                    }
                } else if (connectionFuture.isSuccess()) {
                    if (RedisExecutor.this.writeFuture == null || !RedisExecutor.this.writeFuture.isDone()) {
                        if (RedisExecutor.this.attempt == RedisExecutor.this.attempts) {
                            if (RedisExecutor.this.writeFuture != null && RedisExecutor.this.writeFuture.cancel(false)) {
                                if (RedisExecutor.this.exception == null) {
                                    long totalSize = 0L;
                                    if (RedisExecutor.this.params != null) {
                                        for (Object param : RedisExecutor.this.params) {
                                            if (!(param instanceof ByteBuf)) continue;
                                            totalSize += (long)((ByteBuf)param).readableBytes();
                                        }
                                    }
                                    RedisExecutor.this.exception = new RedisTimeoutException("Command still hasn't been written into connection! Try to increase nettyThreads setting. Payload size in bytes: " + totalSize + ". Node source: " + RedisExecutor.this.source + ", connection: " + connectionFuture.getNow() + ", command: " + LogHelper.toString(RedisExecutor.this.command, RedisExecutor.this.params) + " after " + RedisExecutor.this.attempt + " retry attempts");
                                }
                                attemptPromise.tryFailure(RedisExecutor.this.exception);
                            }
                            return;
                        }
                        ++RedisExecutor.this.attempt;
                        RedisExecutor.this.scheduleRetryTimeout(connectionFuture, attemptPromise);
                        return;
                    }
                    if (RedisExecutor.this.writeFuture.isSuccess()) {
                        return;
                    }
                }
                if (RedisExecutor.this.mainPromise.isCancelled()) {
                    if (attemptPromise.cancel(false)) {
                        RedisExecutor.this.free();
                    }
                    return;
                }
                if (RedisExecutor.this.attempt == RedisExecutor.this.attempts) {
                    attemptPromise.tryFailure(RedisExecutor.this.exception);
                    return;
                }
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                ++RedisExecutor.this.attempt;
                if (log.isDebugEnabled()) {
                    log.debug("attempt {} for command {} and params {}", new Object[]{RedisExecutor.this.attempt, RedisExecutor.this.command, LogHelper.toString(RedisExecutor.this.params)});
                }
                RedisExecutor.this.mainPromiseListener = null;
                RedisExecutor.this.execute();
            }
        };
        this.timeout = this.connectionManager.newTimeout(retryTimerTask, this.retryInterval, TimeUnit.MILLISECONDS);
    }

    protected void free() {
        this.free(this.params);
    }

    protected void free(Object[] params) {
        for (Object obj : params) {
            ReferenceCountUtil.safeRelease((Object)obj);
        }
    }

    private void checkWriteFuture(ChannelFuture future, RPromise<R> attemptPromise, RedisConnection connection) {
        if (future.isCancelled() || attemptPromise.isDone()) {
            return;
        }
        if (!future.isSuccess()) {
            this.exception = new WriteRedisConnectionException("Unable to write command into connection! Node source: " + this.source + ", connection: " + connection + ", command: " + LogHelper.toString(this.command, this.params) + " after " + this.attempt + " retry attempts", future.cause());
            if (this.attempt == this.attempts) {
                attemptPromise.tryFailure(this.exception);
            }
            return;
        }
        this.timeout.cancel();
        this.scheduleResponseTimeout(attemptPromise, connection);
    }

    private void scheduleResponseTimeout(RPromise<R> attemptPromise, RedisConnection connection) {
        long timeoutTime = this.responseTimeout;
        if (this.command != null && (RedisCommands.BLOCKING_COMMAND_NAMES.contains(this.command.getName()) || RedisCommands.BLOCKING_COMMANDS.contains(this.command))) {
            Long popTimeout = null;
            if (RedisCommands.BLOCKING_COMMANDS.contains(this.command)) {
                for (int i = 0; i < this.params.length - 1; ++i) {
                    if (!"BLOCK".equals(this.params[i])) continue;
                    popTimeout = Long.valueOf(this.params[i + 1].toString()) / 1000L;
                    break;
                }
            } else {
                popTimeout = Long.valueOf(this.params[this.params.length - 1].toString());
            }
            this.handleBlockingOperations(attemptPromise, connection, popTimeout);
            if (popTimeout == 0L) {
                return;
            }
            timeoutTime += popTimeout * 1000L;
            timeoutTime += 1000L;
        }
        long timeoutAmount = timeoutTime;
        TimerTask timeoutResponseTask = timeout -> {
            if (this.isResendAllowed(this.attempt, this.attempts)) {
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                this.connectionManager.newTimeout(t -> {
                    ++this.attempt;
                    if (log.isDebugEnabled()) {
                        log.debug("attempt {} for command {} and params {}", new Object[]{this.attempt, this.command, LogHelper.toString(this.params)});
                    }
                    this.mainPromiseListener = null;
                    this.execute();
                }, this.retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            attemptPromise.tryFailure(new RedisResponseTimeoutException("Redis server response timeout (" + timeoutAmount + " ms) occured after " + this.attempt + " retry attempts. Increase nettyThreads and/or timeout settings. Try to define pingConnectionInterval setting. Command: " + LogHelper.toString(this.command, this.params) + ", channel: " + connection.getChannel()));
        };
        this.timeout = this.connectionManager.newTimeout(timeoutResponseTask, timeoutTime, TimeUnit.MILLISECONDS);
    }

    protected boolean isResendAllowed(int attempt, int attempts) {
        return attempt < attempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBlockingOperations(RPromise<R> attemptPromise, RedisConnection connection, Long popTimeout) {
        FutureListener listener = f -> this.mainPromise.tryFailure(new RedissonShutdownException("Redisson is shutdown"));
        Timeout scheduledFuture = popTimeout != 0L ? this.connectionManager.newTimeout(timeout -> {
            if (attemptPromise.trySuccess(null)) {
                connection.forceFastReconnectAsync();
            }
        }, popTimeout + 1L, TimeUnit.SECONDS) : null;
        this.mainPromise.onComplete((res, e) -> {
            if (scheduledFuture != null) {
                scheduledFuture.cancel();
            }
            FutureListener futureListener = listener;
            synchronized (futureListener) {
                this.connectionManager.getShutdownPromise().removeListener((GenericFutureListener)listener);
            }
            if ((this.mainPromise.isCancelled() || this.mainPromise.cause() instanceof InterruptedException) && !attemptPromise.isDone()) {
                log.debug("Canceled blocking operation {} used {}", this.command, (Object)connection);
                connection.forceFastReconnectAsync().onComplete((r, ex) -> attemptPromise.cancel(true));
                return;
            }
            if (e instanceof RedissonShutdownException) {
                attemptPromise.tryFailure((Throwable)e);
            }
        });
        FutureListener futureListener = listener;
        synchronized (futureListener) {
            if (!this.mainPromise.isDone()) {
                this.connectionManager.getShutdownPromise().addListener((GenericFutureListener)listener);
            }
        }
    }

    protected void checkAttemptPromise(RPromise<R> attemptFuture, RFuture<RedisConnection> connectionFuture) {
        this.timeout.cancel();
        if (attemptFuture.isCancelled()) {
            return;
        }
        try {
            this.mainPromiseListener = null;
            if (attemptFuture.cause() instanceof RedisMovedException && !this.ignoreRedirect) {
                RedisMovedException ex = (RedisMovedException)attemptFuture.cause();
                if (this.source.getRedirect() == NodeSource.Redirect.MOVED) {
                    this.mainPromise.tryFailure(new RedisException("MOVED redirection loop detected. Node " + this.source.getAddr() + " has further redirect to " + ex.getUrl()));
                    return;
                }
                this.onException();
                this.source = new NodeSource(ex.getSlot(), this.connectionManager.applyNatMap(ex.getUrl()), NodeSource.Redirect.MOVED);
                this.execute();
                return;
            }
            if (attemptFuture.cause() instanceof RedisAskException && !this.ignoreRedirect) {
                RedisAskException ex = (RedisAskException)attemptFuture.cause();
                this.onException();
                this.source = new NodeSource(ex.getSlot(), this.connectionManager.applyNatMap(ex.getUrl()), NodeSource.Redirect.ASK);
                this.execute();
                return;
            }
            if ((attemptFuture.cause() instanceof RedisLoadingException || attemptFuture.cause() instanceof RedisTryAgainException || attemptFuture.cause() instanceof RedisClusterDownException || attemptFuture.cause() instanceof RedisBusyException) && this.attempt < this.attempts) {
                this.onException();
                this.connectionManager.newTimeout(timeout -> {
                    ++this.attempt;
                    this.execute();
                }, this.retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            this.free();
            this.handleResult(attemptFuture, connectionFuture);
        }
        catch (Exception e) {
            this.handleError(connectionFuture, e);
        }
    }

    protected void handleResult(RPromise<R> attemptPromise, RFuture<RedisConnection> connectionFuture) throws ReflectiveOperationException {
        if (attemptPromise.isSuccess()) {
            Object res = attemptPromise.getNow();
            if (res instanceof ScanResult) {
                ((ScanResult)res).setRedisClient(connectionFuture.getNow().getRedisClient());
            }
            this.handleSuccess(this.mainPromise, connectionFuture, res);
        } else {
            this.handleError(connectionFuture, attemptPromise.cause());
        }
    }

    protected void onException() {
    }

    protected void handleError(RFuture<RedisConnection> connectionFuture, Throwable cause) {
        this.mainPromise.tryFailure(cause);
    }

    protected void handleSuccess(RPromise<R> promise, RFuture<RedisConnection> connectionFuture, R res) throws ReflectiveOperationException {
        if (this.objectBuilder != null) {
            this.handleReference(promise, res);
        } else {
            promise.trySuccess(res);
        }
    }

    private void handleReference(RPromise<R> promise, R res) throws ReflectiveOperationException {
        if (this.objectBuilder != null) {
            promise.trySuccess(this.objectBuilder.tryHandleReference(res, this.referenceType));
        } else {
            promise.trySuccess(res);
        }
    }

    protected void sendCommand(RPromise<R> attemptPromise, RedisConnection connection) {
        if (this.source.getRedirect() == NodeSource.Redirect.ASK) {
            ArrayList list = new ArrayList(2);
            RedissonPromise promise = new RedissonPromise();
            list.add(new CommandData(promise, this.codec, RedisCommands.ASKING, new Object[0]));
            list.add(new CommandData<V, R>(attemptPromise, this.codec, this.command, this.params));
            RedissonPromise<Void> main = new RedissonPromise<Void>();
            this.writeFuture = connection.send(new CommandsData(main, list, false, false));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("acquired connection for command {} and params {} from slot {} using node {}... {}", new Object[]{this.command, LogHelper.toString(this.params), this.source, connection.getRedisClient().getAddr(), connection});
            }
            this.writeFuture = connection.send(new CommandData<V, R>(attemptPromise, this.codec, this.command, this.params));
        }
    }

    protected void releaseConnection(RPromise<R> attemptPromise, RFuture<RedisConnection> connectionFuture) {
        if (!connectionFuture.isSuccess()) {
            return;
        }
        RedisConnection connection = connectionFuture.getNow();
        connection.setQueued(false);
        this.connectionManager.getShutdownLatch().release();
        if (this.readOnlyMode) {
            this.connectionManager.releaseRead(this.source, connection);
        } else {
            this.connectionManager.releaseWrite(this.source, connection);
        }
        if (log.isDebugEnabled()) {
            log.debug("connection released for command {} and params {} from slot {} using connection {}", new Object[]{this.command, LogHelper.toString(this.params), this.source, connection});
        }
    }

    public RedisClient getRedisClient() {
        return this.connectionFuture.getNow().getRedisClient();
    }

    protected RFuture<RedisConnection> getConnection() {
        this.connectionFuture = this.readOnlyMode ? this.connectionManager.connectionReadOp(this.source, this.command) : this.connectionManager.connectionWriteOp(this.source, this.command);
        return this.connectionFuture;
    }

    protected Codec getCodec(Codec codec) {
        Map map;
        if (codec == null) {
            return null;
        }
        if (!this.connectionManager.getCfg().isUseThreadClassLoader()) {
            return codec;
        }
        for (Class<?> clazz : BaseCodec.SKIPPED_CODECS) {
            if (!clazz.isAssignableFrom(codec.getClass())) continue;
            return codec;
        }
        Codec codecToUse = codec;
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null && (codecToUse = (Codec)(map = CODECS.computeIfAbsent(threadClassLoader, k -> new LRUCacheMap(200, 0L, 0L))).get(codec)) == null) {
            try {
                codecToUse = (Codec)codec.getClass().getConstructor(ClassLoader.class, codec.getClass()).newInstance(threadClassLoader, codec);
            }
            catch (NoSuchMethodException e) {
                codecToUse = codec;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            map.put(codec, codecToUse);
        }
        return codecToUse;
    }

    protected <T> RedisException convertException(RFuture<T> future) {
        if (future.cause() instanceof RedisException) {
            return (RedisException)future.cause();
        }
        return new RedisException("Unexpected exception while processing command", future.cause());
    }
}

