/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.CustomObjectInputStream;

public class SerializationCodec
extends BaseCodec {
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ObjectInputStream inputStream;
                ByteBufInputStream in = new ByteBufInputStream(buf);
                if (SerializationCodec.this.classLoader != null) {
                    Thread.currentThread().setContextClassLoader(SerializationCodec.this.classLoader);
                    inputStream = new CustomObjectInputStream(SerializationCodec.this.classLoader, (InputStream)in);
                } else {
                    inputStream = new ObjectInputStream((InputStream)in);
                }
                Object object = inputStream.readObject();
                Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
                return object;
            }
            catch (Throwable throwable) {
                try {
                    Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
                    throw throwable;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream result = new ByteBufOutputStream(out);
                ObjectOutputStream outputStream = new ObjectOutputStream((OutputStream)result);
                outputStream.writeObject(in);
                outputStream.close();
                return result.buffer();
            }
            catch (IOException e) {
                out.release();
                throw e;
            }
        }
    };
    private final ClassLoader classLoader;

    public SerializationCodec() {
        this(null);
    }

    public SerializationCodec(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SerializationCodec(ClassLoader classLoader, SerializationCodec codec) {
        this.classLoader = classLoader;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return this.getClass().getClassLoader();
    }
}

