/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.connection.ConnectionEntry;

public class SubscribesConnectionEntry
extends ConnectionEntry {
    private final Semaphore subscribeConnectionsSemaphore;
    private final Queue<RedisPubSubConnection> allSubscribeConnections = new ConcurrentLinkedQueue<RedisPubSubConnection>();
    private final Queue<RedisPubSubConnection> freeSubscribeConnections = new ConcurrentLinkedQueue<RedisPubSubConnection>();

    public SubscribesConnectionEntry(RedisClient client, int poolSize, int subscribePoolSize) {
        super(client, poolSize);
        this.subscribeConnectionsSemaphore = new Semaphore(subscribePoolSize);
    }

    public Queue<RedisPubSubConnection> getAllSubscribeConnections() {
        return this.allSubscribeConnections;
    }

    public void registerSubscribeConnection(RedisPubSubConnection connection) {
        this.allSubscribeConnections.offer(connection);
    }

    public RedisPubSubConnection pollFreeSubscribeConnection() {
        return this.freeSubscribeConnections.poll();
    }

    public void offerFreeSubscribeConnection(RedisPubSubConnection connection) {
        this.freeSubscribeConnections.offer(connection);
    }

    public Semaphore getSubscribeConnectionsSemaphore() {
        return this.subscribeConnectionsSemaphore;
    }
}

