/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import org.redisson.MasterSlaveServersConfig;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.connection.SubscribesConnectionEntry;

public class SingleEntry
extends MasterSlaveEntry {
    public SingleEntry(int startSlot, int endSlot, ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        super(startSlot, endSlot, connectionManager, config);
    }

    @Override
    public void setupMasterEntry(String host, int port) {
        RedisClient masterClient = this.connectionManager.createClient(host, port);
        this.masterEntry = new SubscribesConnectionEntry(masterClient, this.config.getMasterConnectionPoolSize(), this.config.getSlaveSubscriptionConnectionPoolSize());
    }

    private void acquireSubscribeConnection() {
        if (!((SubscribesConnectionEntry)this.masterEntry).getSubscribeConnectionsSemaphore().tryAcquire()) {
            this.log.warn("Subscribe connection pool gets exhausted! Trying to acquire connection ...");
            long time = System.currentTimeMillis();
            ((SubscribesConnectionEntry)this.masterEntry).getSubscribeConnectionsSemaphore().acquireUninterruptibly();
            long endTime = System.currentTimeMillis() - time;
            this.log.warn("Subscribe connection acquired, time spended: {} ms", (Object)endTime);
        }
    }

    @Override
    RedisPubSubConnection nextPubSubConnection() {
        this.acquireSubscribeConnection();
        RedisPubSubConnection conn = ((SubscribesConnectionEntry)this.masterEntry).pollFreeSubscribeConnection();
        if (conn != null) {
            return conn;
        }
        try {
            conn = this.masterEntry.getClient().connectPubSub();
            if (this.config.getPassword() != null) {
                conn.sync(RedisCommands.AUTH, this.config.getPassword());
            }
            if (this.config.getDatabase() != 0) {
                conn.sync(RedisCommands.SELECT, this.config.getDatabase());
            }
            if (this.config.getClientName() != null) {
                conn.sync(RedisCommands.CLIENT_SETNAME, this.config.getClientName());
            }
            return conn;
        }
        catch (RedisConnectionException e) {
            ((SubscribesConnectionEntry)this.masterEntry).getSubscribeConnectionsSemaphore().release();
            throw e;
        }
    }

    @Override
    public void returnSubscribeConnection(PubSubConnectionEntry entry) {
        ((SubscribesConnectionEntry)this.masterEntry).offerFreeSubscribeConnection(entry.getConnection());
        ((SubscribesConnectionEntry)this.masterEntry).getSubscribeConnectionsSemaphore().release();
    }

    @Override
    public RedisConnection connectionReadOp() {
        return super.connectionWriteOp();
    }

    @Override
    public void releaseRead(RedisConnection \u0441onnection) {
        super.releaseWrite(\u0441onnection);
    }
}

