/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.internal.PlatformDependent;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.Config;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.SentinelServersConfig;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.misc.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, RedisClient> sentinels = PlatformDependent.newConcurrentHashMap();
    private final AtomicReference<String> currentMaster = new AtomicReference();
    private final ConcurrentMap<String, Boolean> freezeSlaves = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<String, Boolean> slaves = PlatformDependent.newConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SentinelConnectionManager(SentinelServersConfig cfg, Config config) {
        this.init(config);
        MasterSlaveServersConfig c = new MasterSlaveServersConfig();
        c.setRetryInterval(cfg.getRetryInterval());
        c.setRetryAttempts(cfg.getRetryAttempts());
        c.setTimeout(cfg.getTimeout());
        c.setPingTimeout(cfg.getPingTimeout());
        c.setLoadBalancer(cfg.getLoadBalancer());
        c.setPassword(cfg.getPassword());
        c.setDatabase(cfg.getDatabase());
        c.setClientName(cfg.getClientName());
        c.setMasterConnectionPoolSize(cfg.getMasterConnectionPoolSize());
        c.setSlaveConnectionPoolSize(cfg.getSlaveConnectionPoolSize());
        c.setSlaveSubscriptionConnectionPoolSize(cfg.getSlaveSubscriptionConnectionPoolSize());
        c.setSubscriptionsPerConnection(cfg.getSubscriptionsPerConnection());
        ArrayList<String> disconnectedSlaves = new ArrayList<String>();
        for (URI addr : cfg.getSentinelAddresses()) {
            RedisClient client = this.createClient(addr.getHost(), addr.getPort(), c.getTimeout());
            try {
                RedisConnection connection = client.connect();
                List<String> master = connection.sync(RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, cfg.getMasterName());
                String masterHost = master.get(0) + ":" + master.get(1);
                c.setMasterAddress(masterHost);
                this.currentMaster.set(masterHost);
                this.log.info("master: {} added", (Object)masterHost);
                List<Map<String, String>> sentinelSlaves = connection.sync(RedisCommands.SENTINEL_SLAVES, cfg.getMasterName());
                for (Map<String, String> map : sentinelSlaves) {
                    if (map.isEmpty()) continue;
                    String ip = map.get("ip");
                    String port = map.get("port");
                    String flags = map.get("flags");
                    String host = ip + ":" + port;
                    c.addSlaveAddress(host);
                    this.slaves.put(host, true);
                    this.log.info("slave: {} added, params: {}", (Object)host, map);
                    if (!flags.contains("s_down") && !flags.contains("disconnected")) continue;
                    disconnectedSlaves.add(host);
                }
                break;
            }
            catch (RedisConnectionException e) {}
            continue;
            finally {
                client.shutdownAsync();
            }
        }
        if (this.currentMaster.get() == null) {
            throw new IllegalStateException("Can't connect to servers!");
        }
        this.init(c);
        for (String host : disconnectedSlaves) {
            String[] parts = host.split(":");
            this.slaveDown(parts[0], parts[1]);
        }
        for (URI addr : cfg.getSentinelAddresses()) {
            this.registerSentinel(cfg, addr, c);
        }
    }

    private void registerSentinel(final SentinelServersConfig cfg, final URI addr, final MasterSlaveServersConfig c) {
        RedisClient client = this.createClient(addr.getHost(), addr.getPort(), c.getTimeout());
        RedisClient oldClient = this.sentinels.putIfAbsent(addr.getHost() + ":" + addr.getPort(), client);
        if (oldClient != null) {
            return;
        }
        try {
            RedisPubSubConnection pubsub = client.connectPubSub();
            pubsub.addListener(new BaseRedisPubSubListener<String>(){

                @Override
                public void onMessage(String channel, String msg) {
                    if ("+sentinel".equals(channel)) {
                        SentinelConnectionManager.this.onSentinelAdded(cfg, msg, c);
                    }
                    if ("+slave".equals(channel)) {
                        SentinelConnectionManager.this.onSlaveAdded(addr, msg);
                    }
                    if ("+sdown".equals(channel)) {
                        SentinelConnectionManager.this.onSlaveDown(addr, msg);
                    }
                    if ("-sdown".equals(channel)) {
                        SentinelConnectionManager.this.onSlaveUp(addr, msg);
                    }
                    if ("+switch-master".equals(channel)) {
                        SentinelConnectionManager.this.onMasterChange(cfg, addr, msg);
                    }
                }

                @Override
                public boolean onStatus(PubSubType type, String channel) {
                    if (type == PubSubType.SUBSCRIBE) {
                        SentinelConnectionManager.this.log.debug("subscribed to channel: {} from Sentinel {}:{}", new Object[]{channel, addr.getHost(), addr.getPort()});
                    }
                    return true;
                }
            });
            pubsub.subscribe(StringCodec.INSTANCE, "+switch-master", "+sdown", "-sdown", "+slave", "+sentinel");
            this.log.info("sentinel: {}:{} added", (Object)addr.getHost(), (Object)addr.getPort());
        }
        catch (RedisConnectionException e) {
            this.log.warn("can't connect to sentinel: {}:{}", (Object)addr.getHost(), (Object)addr.getPort());
        }
    }

    protected void onSentinelAdded(SentinelServersConfig cfg, String msg, MasterSlaveServersConfig c) {
        String[] parts = msg.split(" ");
        if ("sentinel".equals(parts[0])) {
            String ip = parts[2];
            String port = parts[3];
            String addr = ip + ":" + port;
            URI uri = URIBuilder.create(addr);
            this.registerSentinel(cfg, uri, c);
        }
    }

    protected void onSlaveAdded(URI addr, String msg) {
        String[] parts = msg.split(" ");
        if (parts.length > 4 && "slave".equals(parts[0])) {
            String ip = parts[2];
            String port = parts[3];
            String slaveAddr = ip + ":" + port;
            if (this.slaves.putIfAbsent(slaveAddr, true) == null) {
                this.addSlave(ip, Integer.valueOf(port));
                this.log.info("slave: {} added", (Object)slaveAddr);
            }
        } else {
            this.log.warn("onSlaveAdded. Invalid message: {} from Sentinel {}:{}", new Object[]{msg, addr.getHost(), addr.getPort()});
        }
    }

    private void onSlaveDown(URI sentinelAddr, String msg) {
        String[] parts = msg.split(" ");
        if (parts.length > 3) {
            if ("slave".equals(parts[0])) {
                String ip = parts[2];
                String port = parts[3];
                this.slaveDown(ip, port);
            } else if ("sentinel".equals(parts[0])) {
                String ip = parts[2];
                String port = parts[3];
                String addr = ip + ":" + port;
                RedisClient sentinel = (RedisClient)this.sentinels.remove(addr);
                if (sentinel != null) {
                    sentinel.shutdownAsync();
                    this.log.info("sentinel: {} has down", (Object)addr);
                }
            } else if (!"master".equals(parts[0])) {
                this.log.warn("onSlaveDown. Invalid message: {} from Sentinel {}:{}", new Object[]{msg, sentinelAddr.getHost(), sentinelAddr.getPort()});
            }
        } else {
            this.log.warn("onSlaveDown. Invalid message: {} from Sentinel {}:{}", new Object[]{msg, sentinelAddr.getHost(), sentinelAddr.getPort()});
        }
    }

    private void slaveDown(String ip, String port) {
        String addr = ip + ":" + port;
        if (this.freezeSlaves.putIfAbsent(addr, true) == null) {
            this.slaveDown(0, ip, Integer.valueOf(port));
            this.log.info("slave: {} has down", (Object)addr);
        }
    }

    protected void onSlaveUp(URI addr, String msg) {
        String[] parts = msg.split(" ");
        if (parts.length > 4 && "slave".equals(parts[0])) {
            String ip = parts[2];
            String port = parts[3];
            String slaveAddr = ip + ":" + port;
            if (this.freezeSlaves.remove(slaveAddr) != null) {
                this.slaveUp(ip, Integer.valueOf(port));
                this.log.info("slave: {} has up", (Object)slaveAddr);
            }
        } else {
            this.log.warn("onSlaveUp. Invalid message: {} from Sentinel {}:{}", new Object[]{msg, addr.getHost(), addr.getPort()});
        }
    }

    private void onMasterChange(SentinelServersConfig cfg, URI addr, String msg) {
        String[] parts = msg.split(" ");
        if (parts.length > 3) {
            if (cfg.getMasterName().equals(parts[0])) {
                String ip = parts[3];
                String port = parts[4];
                String current = this.currentMaster.get();
                String newMaster = ip + ":" + port;
                if (!newMaster.equals(current) && this.currentMaster.compareAndSet(current, newMaster)) {
                    this.changeMaster(0, ip, Integer.valueOf(port));
                    this.log.info("master has changed from {} to {}", (Object)current, (Object)newMaster);
                }
            }
        } else {
            this.log.warn("Invalid message: {} from Sentinel {}:{}", new Object[]{msg, addr.getHost(), addr.getPort()});
        }
    }

    private void addSlave(String host, int port) {
        this.getEntry(0).addSlave(host, port);
    }

    private void slaveUp(String host, int port) {
        this.getEntry(0).slaveUp(host, port);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (RedisClient sentinel : this.sentinels.values()) {
            sentinel.shutdown();
        }
    }
}

