/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.net.InetSocketAddress;
import java.util.Map;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.core.ClusterNode;

public class RedisClientEntry
implements ClusterNode {
    private final RedisClient client;

    public RedisClientEntry(RedisClient client) {
        this.client = client;
    }

    public RedisClient getClient() {
        return this.client;
    }

    @Override
    public InetSocketAddress getAddr() {
        return this.client.getAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping() {
        RedisConnection c = this.client.connect();
        try {
            boolean bl = "PONG".equals(c.sync(RedisCommands.PING, new Object[0]));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            c.closeAsync();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.client == null ? 0 : this.client.getAddr().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RedisClientEntry other = (RedisClientEntry)obj;
        return !(this.client == null ? other.client != null : !this.client.getAddr().equals(other.client.getAddr()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> info() {
        RedisConnection c = this.client.connect();
        try {
            Map<String, String> map = c.sync(RedisCommands.CLUSTER_INFO, new Object[0]);
            return map;
        }
        catch (Exception e) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            c.closeAsync();
        }
    }
}

