/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubConnectionEntry {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile Status status = Status.ACTIVE;
    private final Semaphore subscribedChannelsAmount;
    private final RedisPubSubConnection conn;
    private final int subscriptionsPerConnection;
    private final ConcurrentMap<String, Queue<RedisPubSubListener>> channelListeners = new ConcurrentHashMap<String, Queue<RedisPubSubListener>>();

    public PubSubConnectionEntry(RedisPubSubConnection conn, int subscriptionsPerConnection) {
        this.conn = conn;
        this.subscriptionsPerConnection = subscriptionsPerConnection;
        this.subscribedChannelsAmount = new Semaphore(subscriptionsPerConnection);
    }

    public boolean hasListeners(String channelName) {
        return this.channelListeners.containsKey(channelName);
    }

    public Collection<RedisPubSubListener> getListeners(String channelName) {
        Collection result = (Collection)this.channelListeners.get(channelName);
        if (result == null) {
            return Collections.emptyList();
        }
        return new ArrayList<RedisPubSubListener>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String channelName, RedisPubSubListener<?> listener) {
        Queue oldQueue;
        Queue<RedisPubSubListener<Object>> queue = (ConcurrentLinkedQueue)this.channelListeners.get(channelName);
        if (queue == null && (oldQueue = (Queue)this.channelListeners.putIfAbsent(channelName, queue = new ConcurrentLinkedQueue())) != null) {
            queue = oldQueue;
        }
        ConcurrentLinkedQueue concurrentLinkedQueue = queue;
        synchronized (concurrentLinkedQueue) {
            if (this.channelListeners.get(channelName) != queue) {
                this.addListener(channelName, listener);
                return;
            }
            queue.add(listener);
        }
        this.conn.addListener(listener);
    }

    public boolean isActive() {
        return this.status == Status.ACTIVE;
    }

    public void close() {
        this.status = Status.INACTIVE;
    }

    public void removeListener(String channelName, int listenerId) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            if (listener.hashCode() != listenerId) continue;
            this.removeListener(channelName, listener);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(String channelName, RedisPubSubListener listener) {
        Queue queue;
        Queue queue2 = queue = (Queue)this.channelListeners.get(channelName);
        synchronized (queue2) {
            if (queue.remove(listener) && queue.isEmpty()) {
                this.channelListeners.remove(channelName);
            }
        }
        this.conn.removeListener(listener);
    }

    public boolean tryAcquire() {
        return this.subscribedChannelsAmount.tryAcquire();
    }

    public void release() {
        this.subscribedChannelsAmount.release();
    }

    public void subscribe(Codec codec, String channelName) {
        this.conn.subscribe(codec, channelName);
    }

    public void psubscribe(Codec codec, String pattern) {
        this.conn.psubscribe(codec, pattern);
    }

    public void subscribe(Codec codec, RedisPubSubListener listener, String channel) {
        this.addListener(channel, listener);
        this.conn.subscribe(codec, channel);
    }

    public void unsubscribe(final String channel, RedisPubSubListener listener) {
        this.conn.addOneShotListener(new BaseRedisPubSubListener<Object>(){

            @Override
            public boolean onStatus(PubSubType type, String ch) {
                if (type == PubSubType.UNSUBSCRIBE && channel.equals(ch)) {
                    PubSubConnectionEntry.this.removeListeners(channel);
                    return true;
                }
                return false;
            }
        });
        this.conn.addOneShotListener(listener);
        this.conn.unsubscribe(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListeners(String channel) {
        Queue queue = (Queue)this.channelListeners.get(channel);
        if (queue != null) {
            Queue queue2 = queue;
            synchronized (queue2) {
                this.channelListeners.remove(channel);
            }
            for (RedisPubSubListener listener : queue) {
                this.conn.removeListener(listener);
            }
        }
        this.subscribedChannelsAmount.release();
    }

    public void punsubscribe(final String channel, RedisPubSubListener listener) {
        this.conn.addOneShotListener(new BaseRedisPubSubListener<Object>(){

            @Override
            public boolean onStatus(PubSubType type, String ch) {
                if (type == PubSubType.PUNSUBSCRIBE && channel.equals(ch)) {
                    PubSubConnectionEntry.this.removeListeners(channel);
                    return true;
                }
                return false;
            }
        });
        this.conn.addOneShotListener(listener);
        this.conn.punsubscribe(channel);
    }

    public boolean tryClose() {
        if (this.subscribedChannelsAmount.tryAcquire(this.subscriptionsPerConnection)) {
            this.close();
            return true;
        }
        return false;
    }

    public RedisPubSubConnection getConnection() {
        return this.conn;
    }

    public static enum Status {
        ACTIVE,
        INACTIVE;

    }
}

