/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.connection.ConnectionEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.LoadBalancer;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.connection.SubscribesConnectionEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveEntry {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    LoadBalancer slaveBalancer;
    volatile ConnectionEntry masterEntry;
    final MasterSlaveServersConfig config;
    final ConnectionManager connectionManager;
    final int startSlot;
    final int endSlot;

    public MasterSlaveEntry(int startSlot, int endSlot, ConnectionManager connectionManager, MasterSlaveServersConfig config) {
        this.startSlot = startSlot;
        this.endSlot = endSlot;
        this.connectionManager = connectionManager;
        this.config = config;
        this.slaveBalancer = config.getLoadBalancer();
        this.slaveBalancer.init(config, connectionManager);
        ArrayList<URI> addresses = new ArrayList<URI>(config.getSlaveAddresses());
        addresses.add(config.getMasterAddress());
        for (URI address : addresses) {
            RedisClient client = connectionManager.createClient(address.getHost(), address.getPort());
            this.slaveBalancer.add(new SubscribesConnectionEntry(client, this.config.getSlaveConnectionPoolSize(), this.config.getSlaveSubscriptionConnectionPoolSize()));
        }
        if (config.getSlaveAddresses().size() > 1) {
            this.slaveDown(config.getMasterAddress().getHost(), config.getMasterAddress().getPort());
        }
        this.setupMasterEntry(config.getMasterAddress().getHost(), config.getMasterAddress().getPort());
    }

    public void setupMasterEntry(String host, int port) {
        RedisClient client = this.connectionManager.createClient(host, port);
        this.masterEntry = new ConnectionEntry(client, this.config.getMasterConnectionPoolSize());
    }

    public Collection<RedisPubSubConnection> slaveDown(String host, int port) {
        Collection<RedisPubSubConnection> conns = this.slaveBalancer.freeze(host, port);
        if (this.slaveBalancer.getAvailableClients() == 0) {
            this.slaveUp(this.masterEntry.getClient().getAddr().getHostName(), this.masterEntry.getClient().getAddr().getPort());
        }
        return conns;
    }

    public void addSlave(String host, int port) {
        RedisClient client = this.connectionManager.createClient(host, port);
        SubscribesConnectionEntry entry = new SubscribesConnectionEntry(client, this.config.getSlaveConnectionPoolSize(), this.config.getSlaveSubscriptionConnectionPoolSize());
        entry.setFreezed(true);
        this.slaveBalancer.add(entry);
    }

    public RedisClient getClient() {
        return this.masterEntry.getClient();
    }

    public void slaveUp(String host, int port) {
        if (!this.masterEntry.getClient().getAddr().getHostName().equals(host) && port != this.masterEntry.getClient().getAddr().getPort()) {
            this.slaveDown(this.masterEntry.getClient().getAddr().getHostName(), this.masterEntry.getClient().getAddr().getPort());
        }
        this.slaveBalancer.unfreeze(host, port);
    }

    public void changeMaster(String host, int port) {
        ConnectionEntry oldMaster = this.masterEntry;
        this.setupMasterEntry(host, port);
        if (this.slaveBalancer.getAvailableClients() > 1) {
            this.slaveDown(host, port);
        }
        this.connectionManager.shutdownAsync(oldMaster.getClient());
    }

    public void shutdownMasterAsync() {
        this.connectionManager.shutdownAsync(this.masterEntry.getClient());
        this.slaveBalancer.shutdownAsync();
    }

    public RedisConnection connectionWriteOp() {
        ConnectionEntry entry = this.masterEntry;
        this.acquireMasterConnection(entry);
        RedisConnection conn = entry.getConnections().poll();
        if (conn != null) {
            return conn;
        }
        try {
            return entry.connect(this.config);
        }
        catch (RedisException e) {
            entry.getConnectionsSemaphore().release();
            throw e;
        }
    }

    public RedisConnection connectionReadOp() {
        return this.slaveBalancer.nextConnection();
    }

    public RedisConnection connectionReadOp(RedisClient client) {
        return this.slaveBalancer.getConnection(client);
    }

    RedisPubSubConnection nextPubSubConnection() {
        return this.slaveBalancer.nextPubSubConnection();
    }

    void acquireMasterConnection(ConnectionEntry entry) {
        if (!entry.getConnectionsSemaphore().tryAcquire()) {
            this.log.warn("Master connection pool gets exhausted! Trying to acquire connection ...");
            long time = System.currentTimeMillis();
            entry.getConnectionsSemaphore().acquireUninterruptibly();
            long endTime = System.currentTimeMillis() - time;
            this.log.warn("Master connection acquired, time spended: {} ms", (Object)endTime);
        }
    }

    public void returnSubscribeConnection(PubSubConnectionEntry entry) {
        this.slaveBalancer.returnSubscribeConnection(entry.getConnection());
    }

    public void releaseWrite(RedisConnection connection) {
        ConnectionEntry entry = this.masterEntry;
        if (!entry.getClient().equals(connection.getRedisClient())) {
            connection.closeAsync();
            return;
        }
        entry.getConnections().add(connection);
        entry.getConnectionsSemaphore().release();
    }

    public void releaseRead(RedisConnection \u0441onnection) {
        this.slaveBalancer.returnConnection(\u0441onnection);
    }

    public void shutdown() {
        this.masterEntry.getClient().shutdown();
        this.slaveBalancer.shutdown();
    }

    public int getEndSlot() {
        return this.endSlot;
    }

    public int getStartSlot() {
        return this.startSlot;
    }

    public boolean isOwn(int slot) {
        return slot >= this.startSlot && slot <= this.endSlot;
    }
}

