/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.redisson.Config;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisEmptySlotException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.connection.CRC16;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.connection.RedisClientEntry;
import org.redisson.misc.InfinitySemaphoreLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveConnectionManager
implements ConnectionManager {
    static final int MAX_SLOT = 16384;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HashedWheelTimer timer;
    protected Codec codec;
    protected EventLoopGroup group;
    protected Class<? extends SocketChannel> socketChannelClass;
    protected final ConcurrentMap<String, PubSubConnectionEntry> name2PubSubConnection = new ConcurrentHashMap<String, PubSubConnectionEntry>();
    protected MasterSlaveServersConfig config;
    protected final NavigableMap<Integer, MasterSlaveEntry> entries = new ConcurrentSkipListMap<Integer, MasterSlaveEntry>();
    private final InfinitySemaphoreLatch shutdownLatch = new InfinitySemaphoreLatch();
    private final Set<RedisClientEntry> clients = Collections.newSetFromMap(new ConcurrentHashMap());

    MasterSlaveConnectionManager() {
    }

    @Override
    public HashedWheelTimer getTimer() {
        return this.timer;
    }

    @Override
    public MasterSlaveServersConfig getConfig() {
        return this.config;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    @Override
    public NavigableMap<Integer, MasterSlaveEntry> getEntries() {
        return this.entries;
    }

    public MasterSlaveConnectionManager(MasterSlaveServersConfig cfg, Config config) {
        this.init(cfg, config);
    }

    protected void init(MasterSlaveServersConfig config, Config cfg) {
        this.init(cfg);
        this.init(config);
    }

    protected void init(MasterSlaveServersConfig config) {
        this.config = config;
        int minTimeout = Math.min(config.getRetryInterval(), config.getTimeout());
        this.timer = minTimeout % 100 != 0 ? new HashedWheelTimer((long)(minTimeout % 100 / 2), TimeUnit.MILLISECONDS) : new HashedWheelTimer(100L, TimeUnit.MILLISECONDS);
        this.initEntry(config);
    }

    protected void initEntry(MasterSlaveServersConfig config) {
        MasterSlaveEntry entry = new MasterSlaveEntry(0, 16384, this, config);
        this.entries.put(16384, entry);
    }

    protected void init(Config cfg) {
        if (cfg.isUseLinuxNativeEpoll()) {
            this.group = new EpollEventLoopGroup(cfg.getThreads());
            this.socketChannelClass = EpollSocketChannel.class;
        } else {
            this.group = new NioEventLoopGroup(cfg.getThreads());
            this.socketChannelClass = NioSocketChannel.class;
        }
        this.codec = cfg.getCodec();
    }

    @Override
    public RedisClient createClient(String host, int port) {
        RedisClient client = this.createClient(host, port, this.config.getTimeout());
        this.clients.add(new RedisClientEntry(client));
        return client;
    }

    @Override
    public void shutdownAsync(RedisClient client) {
        this.clients.remove(new RedisClientEntry(client));
        client.shutdownAsync();
    }

    @Override
    public RedisClient createClient(String host, int port, int timeout) {
        return new RedisClient(this.group, this.socketChannelClass, host, port, timeout);
    }

    @Override
    public <T> FutureListener<T> createReleaseWriteListener(final int slot, final RedisConnection conn, final Timeout timeout) {
        return new FutureListener<T>(){

            public void operationComplete(Future<T> future) throws Exception {
                MasterSlaveConnectionManager.this.shutdownLatch.release();
                timeout.cancel();
                MasterSlaveConnectionManager.this.releaseWrite(slot, conn);
            }
        };
    }

    @Override
    public <T> FutureListener<T> createReleaseReadListener(final int slot, final RedisConnection conn, final Timeout timeout) {
        return new FutureListener<T>(){

            public void operationComplete(Future<T> future) throws Exception {
                MasterSlaveConnectionManager.this.shutdownLatch.release();
                timeout.cancel();
                MasterSlaveConnectionManager.this.releaseRead(slot, conn);
            }
        };
    }

    @Override
    public int calcSlot(String key) {
        if (this.entries.size() == 1 || key == null) {
            return 0;
        }
        int start = key.indexOf(123);
        if (start != -1) {
            int end = key.indexOf(125);
            key = key.substring(start + 1, end);
        }
        int result = CRC16.crc16(key.getBytes()) % 16384;
        this.log.debug("slot {} for {}", (Object)result, (Object)key);
        return result;
    }

    @Override
    public PubSubConnectionEntry getEntry(String channelName) {
        return (PubSubConnectionEntry)this.name2PubSubConnection.get(channelName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PubSubConnectionEntry subscribe(String channelName) {
        PubSubConnectionEntry \u0441onnEntry = (PubSubConnectionEntry)this.name2PubSubConnection.get(channelName);
        if (\u0441onnEntry != null) {
            return \u0441onnEntry;
        }
        HashSet entries = new HashSet(this.name2PubSubConnection.values());
        for (PubSubConnectionEntry entry : entries) {
            if (!entry.tryAcquire()) continue;
            PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(channelName, entry);
            if (oldEntry != null) {
                entry.release();
                return oldEntry;
            }
            PubSubConnectionEntry pubSubConnectionEntry = entry;
            synchronized (pubSubConnectionEntry) {
                if (!entry.isActive()) {
                    entry.release();
                    return this.subscribe(channelName);
                }
                entry.subscribe(this.codec, channelName);
                return entry;
            }
        }
        int slot = 0;
        RedisPubSubConnection conn = this.nextPubSubConnection(slot);
        PubSubConnectionEntry entry = new PubSubConnectionEntry(conn, this.config.getSubscriptionsPerConnection());
        entry.tryAcquire();
        PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(channelName, entry);
        if (oldEntry != null) {
            this.releaseSubscribeConnection(slot, entry);
            return oldEntry;
        }
        PubSubConnectionEntry pubSubConnectionEntry = entry;
        synchronized (pubSubConnectionEntry) {
            if (!entry.isActive()) {
                entry.release();
                return this.subscribe(channelName);
            }
            entry.subscribe(this.codec, channelName);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PubSubConnectionEntry psubscribe(String channelName) {
        PubSubConnectionEntry \u0441onnEntry = (PubSubConnectionEntry)this.name2PubSubConnection.get(channelName);
        if (\u0441onnEntry != null) {
            return \u0441onnEntry;
        }
        HashSet entries = new HashSet(this.name2PubSubConnection.values());
        for (PubSubConnectionEntry entry : entries) {
            if (!entry.tryAcquire()) continue;
            PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(channelName, entry);
            if (oldEntry != null) {
                entry.release();
                return oldEntry;
            }
            PubSubConnectionEntry pubSubConnectionEntry = entry;
            synchronized (pubSubConnectionEntry) {
                if (!entry.isActive()) {
                    entry.release();
                    return this.psubscribe(channelName);
                }
                entry.psubscribe(this.codec, channelName);
                return entry;
            }
        }
        int slot = 0;
        RedisPubSubConnection conn = this.nextPubSubConnection(slot);
        PubSubConnectionEntry entry = new PubSubConnectionEntry(conn, this.config.getSubscriptionsPerConnection());
        entry.tryAcquire();
        PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(channelName, entry);
        if (oldEntry != null) {
            this.releaseSubscribeConnection(slot, entry);
            return oldEntry;
        }
        PubSubConnectionEntry pubSubConnectionEntry = entry;
        synchronized (pubSubConnectionEntry) {
            if (!entry.isActive()) {
                entry.release();
                return this.psubscribe(channelName);
            }
            entry.psubscribe(this.codec, channelName);
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(RedisPubSubListener listener, String channelName) {
        PubSubConnectionEntry \u0441onnEntry = (PubSubConnectionEntry)this.name2PubSubConnection.get(channelName);
        if (\u0441onnEntry != null) {
            \u0441onnEntry.subscribe(this.codec, listener, channelName);
            return;
        }
        HashSet entries = new HashSet(this.name2PubSubConnection.values());
        for (PubSubConnectionEntry entry : entries) {
            if (!entry.tryAcquire()) continue;
            PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(channelName, entry);
            if (oldEntry != null) {
                entry.release();
                return;
            }
            PubSubConnectionEntry pubSubConnectionEntry = entry;
            synchronized (pubSubConnectionEntry) {
                if (!entry.isActive()) {
                    entry.release();
                    this.subscribe(listener, channelName);
                    return;
                }
                entry.subscribe(this.codec, listener, channelName);
                return;
            }
        }
        int slot = 0;
        RedisPubSubConnection conn = this.nextPubSubConnection(slot);
        PubSubConnectionEntry entry = new PubSubConnectionEntry(conn, this.config.getSubscriptionsPerConnection());
        entry.tryAcquire();
        PubSubConnectionEntry oldEntry = this.name2PubSubConnection.putIfAbsent(channelName, entry);
        if (oldEntry != null) {
            this.releaseSubscribeConnection(slot, entry);
            return;
        }
        PubSubConnectionEntry pubSubConnectionEntry = entry;
        synchronized (pubSubConnectionEntry) {
            if (!entry.isActive()) {
                entry.release();
                this.subscribe(listener, channelName);
                return;
            }
            entry.subscribe(this.codec, listener, channelName);
            return;
        }
    }

    @Override
    public void unsubscribe(final String channelName) {
        final PubSubConnectionEntry entry = (PubSubConnectionEntry)this.name2PubSubConnection.remove(channelName);
        if (entry == null) {
            return;
        }
        entry.unsubscribe(channelName, new BaseRedisPubSubListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onStatus(PubSubType type, String channel) {
                if (type == PubSubType.UNSUBSCRIBE && channel.equals(channelName)) {
                    PubSubConnectionEntry pubSubConnectionEntry = entry;
                    synchronized (pubSubConnectionEntry) {
                        if (entry.tryClose()) {
                            MasterSlaveConnectionManager.this.releaseSubscribeConnection(0, entry);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void punsubscribe(final String channelName) {
        final PubSubConnectionEntry entry = (PubSubConnectionEntry)this.name2PubSubConnection.remove(channelName);
        if (entry == null) {
            return;
        }
        entry.punsubscribe(channelName, new BaseRedisPubSubListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onStatus(PubSubType type, String channel) {
                if (type == PubSubType.PUNSUBSCRIBE && channel.equals(channelName)) {
                    PubSubConnectionEntry pubSubConnectionEntry = entry;
                    synchronized (pubSubConnectionEntry) {
                        if (entry.tryClose()) {
                            MasterSlaveConnectionManager.this.releaseSubscribeConnection(0, entry);
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    protected MasterSlaveEntry getEntry(int slot) {
        return this.entries.ceilingEntry(slot).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void slaveDown(int slot, String host, int port) {
        Collection<RedisPubSubConnection> allPubSubConnections = this.getEntry(slot).slaveDown(host, port);
        for (Map.Entry mapEntry : this.name2PubSubConnection.entrySet()) {
            for (RedisPubSubConnection redisPubSubConnection : allPubSubConnections) {
                PubSubConnectionEntry entry = (PubSubConnectionEntry)mapEntry.getValue();
                String channelName = (String)mapEntry.getKey();
                if (!entry.getConnection().equals(redisPubSubConnection)) continue;
                PubSubConnectionEntry pubSubConnectionEntry = entry;
                synchronized (pubSubConnectionEntry) {
                    entry.close();
                    Collection<RedisPubSubListener> listeners = entry.getListeners(channelName);
                    this.unsubscribe(channelName);
                    if (!listeners.isEmpty()) {
                        PubSubConnectionEntry newEntry = this.subscribe(channelName);
                        for (RedisPubSubListener redisPubSubListener : listeners) {
                            newEntry.addListener(channelName, redisPubSubListener);
                        }
                        this.log.debug("resubscribed listeners for '{}' channel", (Object)channelName);
                    }
                }
            }
        }
    }

    protected void changeMaster(int endSlot, String host, int port) {
        this.getEntry(endSlot).changeMaster(host, port);
    }

    protected MasterSlaveEntry removeMaster(int endSlot) {
        return (MasterSlaveEntry)this.entries.remove(endSlot);
    }

    @Override
    public RedisConnection connectionWriteOp(int slot) {
        MasterSlaveEntry e = this.getEntry(slot);
        if (!e.isOwn(slot)) {
            throw new RedisEmptySlotException("No node for slot: " + slot, slot);
        }
        return e.connectionWriteOp();
    }

    @Override
    public RedisConnection connectionReadOp(int slot) {
        MasterSlaveEntry e = this.getEntry(slot);
        if (!e.isOwn(slot)) {
            throw new RedisEmptySlotException("No node for slot: " + slot, slot);
        }
        return e.connectionReadOp();
    }

    @Override
    public RedisConnection connectionReadOp(int slot, RedisClient client) {
        MasterSlaveEntry e = this.getEntry(slot);
        if (!e.isOwn(slot)) {
            throw new RedisEmptySlotException("No node for slot: " + slot, slot);
        }
        return e.connectionReadOp(client);
    }

    RedisPubSubConnection nextPubSubConnection(int slot) {
        return this.getEntry(slot).nextPubSubConnection();
    }

    protected void releaseSubscribeConnection(int slot, PubSubConnectionEntry entry) {
        this.getEntry(slot).returnSubscribeConnection(entry);
    }

    @Override
    public void releaseWrite(int slot, RedisConnection connection) {
        this.getEntry(slot).releaseWrite(connection);
    }

    @Override
    public void releaseRead(int slot, RedisConnection connection) {
        this.getEntry(slot).releaseRead(connection);
    }

    @Override
    public void shutdown() {
        this.shutdownLatch.closeAndAwaitUninterruptibly();
        for (MasterSlaveEntry entry : this.entries.values()) {
            entry.shutdown();
        }
        this.timer.stop();
        this.group.shutdownGracefully().syncUninterruptibly();
    }

    @Override
    public Collection<RedisClientEntry> getClients() {
        return Collections.unmodifiableCollection(this.clients);
    }

    @Override
    public <R> Promise<R> newPromise() {
        return this.group.next().newPromise();
    }

    @Override
    public EventLoopGroup getGroup() {
        return this.group;
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        return this.timer.newTimeout(task, delay, unit);
    }

    @Override
    public InfinitySemaphoreLatch getShutdownLatch() {
        return this.shutdownLatch;
    }
}

