/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.concurrent.TimeUnit;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.connection.RedisClientEntry;
import org.redisson.misc.InfinitySemaphoreLatch;

public interface ConnectionManager {
    public Collection<RedisClientEntry> getClients();

    public void shutdownAsync(RedisClient var1);

    public int calcSlot(String var1);

    public HashedWheelTimer getTimer();

    public MasterSlaveServersConfig getConfig();

    public Codec getCodec();

    public NavigableMap<Integer, MasterSlaveEntry> getEntries();

    public <R> Promise<R> newPromise();

    public void releaseRead(int var1, RedisConnection var2);

    public void releaseWrite(int var1, RedisConnection var2);

    public RedisConnection connectionReadOp(int var1);

    public RedisConnection connectionReadOp(int var1, RedisClient var2);

    public RedisConnection connectionWriteOp(int var1);

    public <T> FutureListener<T> createReleaseReadListener(int var1, RedisConnection var2, Timeout var3);

    public <T> FutureListener<T> createReleaseWriteListener(int var1, RedisConnection var2, Timeout var3);

    public RedisClient createClient(String var1, int var2, int var3);

    public RedisClient createClient(String var1, int var2);

    public PubSubConnectionEntry getEntry(String var1);

    public PubSubConnectionEntry subscribe(String var1);

    public PubSubConnectionEntry psubscribe(String var1);

    public <V> void subscribe(RedisPubSubListener<V> var1, String var2);

    public void unsubscribe(String var1);

    public void punsubscribe(String var1);

    public void shutdown();

    public EventLoopGroup getGroup();

    public Timeout newTimeout(TimerTask var1, long var2, TimeUnit var4);

    public InfinitySemaphoreLatch getShutdownLatch();
}

