/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionEntry {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile boolean freezed;
    private final RedisClient client;
    private final Queue<RedisConnection> connections = new ConcurrentLinkedQueue<RedisConnection>();
    private final Semaphore connectionsSemaphore;

    public ConnectionEntry(RedisClient client, int poolSize) {
        this.client = client;
        this.connectionsSemaphore = new Semaphore(poolSize);
    }

    public RedisClient getClient() {
        return this.client;
    }

    public boolean isFreezed() {
        return this.freezed;
    }

    public void setFreezed(boolean freezed) {
        this.freezed = freezed;
    }

    public Semaphore getConnectionsSemaphore() {
        return this.connectionsSemaphore;
    }

    public Queue<RedisConnection> getConnections() {
        return this.connections;
    }

    public RedisConnection connect(MasterSlaveServersConfig config) {
        RedisConnection conn = this.client.connect();
        if (config.getPassword() != null) {
            conn.sync(RedisCommands.AUTH, config.getPassword());
        }
        if (config.getDatabase() != 0) {
            conn.sync(RedisCommands.SELECT, config.getDatabase());
        }
        if (config.getClientName() != null) {
            conn.sync(RedisCommands.CLIENT_SETNAME, config.getClientName());
        }
        this.log.debug("new connection created: {}", (Object)conn);
        return conn;
    }

    public String toString() {
        return "ConnectionEntry [freezed=" + this.freezed + ", client=" + this.client + "]";
    }
}

