/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.ClusterServersConfig;
import org.redisson.Config;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ClusterNodeInfo;
import org.redisson.connection.ClusterPartition;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.SingleEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConnectionManager
extends MasterSlaveConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<URI, RedisConnection> nodeConnections = new HashMap<URI, RedisConnection>();
    private final Map<Integer, ClusterPartition> lastPartitions = new HashMap<Integer, ClusterPartition>();
    private ScheduledFuture<?> monitorFuture;

    public ClusterConnectionManager(ClusterServersConfig cfg, Config config) {
        this.init(config);
        this.config = this.create(cfg);
        this.init(this.config);
        for (URI addr : cfg.getNodeAddresses()) {
            RedisConnection connection = this.connect(cfg, addr);
            if (connection == null) continue;
            String nodesValue = connection.sync(RedisCommands.CLUSTER_NODES, new Object[0]);
            Map<Integer, ClusterPartition> partitions = this.parsePartitions(nodesValue);
            for (ClusterPartition partition : partitions.values()) {
                this.addMasterEntry(partition, cfg);
            }
        }
        this.monitorClusterChange(cfg);
    }

    private RedisConnection connect(ClusterServersConfig cfg, URI addr) {
        RedisConnection connection = this.nodeConnections.get(addr);
        if (connection != null) {
            return connection;
        }
        RedisClient client = this.createClient(addr.getHost(), addr.getPort(), cfg.getTimeout());
        try {
            connection = client.connect();
            this.nodeConnections.put(addr, connection);
        }
        catch (RedisConnectionException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return connection;
    }

    @Override
    protected void initEntry(MasterSlaveServersConfig config) {
    }

    private void addMasterEntry(ClusterPartition partition, ClusterServersConfig cfg) {
        if (partition.isMasterFail()) {
            this.log.warn("master: {} for slot range: {}-{} add failed. Reason - server has FAIL flag", new Object[]{partition.getMasterAddress(), partition.getStartSlot(), partition.getEndSlot()});
            return;
        }
        RedisConnection connection = this.connect(cfg, partition.getMasterAddress());
        if (connection == null) {
            return;
        }
        Map<String, String> params = connection.sync(RedisCommands.CLUSTER_INFO, new Object[0]);
        if ("fail".equals(params.get("cluster_state"))) {
            this.log.warn("master: {} for slot range: {}-{} add failed. Reason - cluster_state:fail", new Object[]{partition.getMasterAddress(), partition.getStartSlot(), partition.getEndSlot()});
            return;
        }
        MasterSlaveServersConfig config = this.create(cfg);
        this.log.info("master: {} for slot range: {}-{} added", new Object[]{partition.getMasterAddress(), partition.getStartSlot(), partition.getEndSlot()});
        config.setMasterAddress(partition.getMasterAddress());
        SingleEntry entry = new SingleEntry(partition.getStartSlot(), partition.getEndSlot(), this, config);
        this.entries.put(partition.getEndSlot(), entry);
        this.lastPartitions.put(partition.getEndSlot(), partition);
    }

    private void monitorClusterChange(final ClusterServersConfig cfg) {
        this.monitorFuture = GlobalEventExecutor.INSTANCE.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    Iterator<URI> i$ = cfg.getNodeAddresses().iterator();
                    if (i$.hasNext()) {
                        URI addr = i$.next();
                        RedisConnection connection = ClusterConnectionManager.this.connect(cfg, addr);
                        String nodesValue = connection.sync(RedisCommands.CLUSTER_NODES, new Object[0]);
                        ClusterConnectionManager.this.log.debug("cluster nodes state: {}", (Object)nodesValue);
                        Map partitions = ClusterConnectionManager.this.parsePartitions(nodesValue);
                        block2: for (ClusterPartition newPart : partitions.values()) {
                            for (ClusterPartition part : ClusterConnectionManager.this.lastPartitions.values()) {
                                ClusterPartition newMasterPart;
                                if (!newPart.getMasterAddress().equals(part.getMasterAddress())) continue;
                                ClusterConnectionManager.this.log.debug("found endslot {} for {} fail {}", new Object[]{part.getEndSlot(), part.getMasterAddress(), newPart.isMasterFail()});
                                if (!newPart.isMasterFail() || (newMasterPart = (ClusterPartition)partitions.get(part.getEndSlot())).getMasterAddress().equals(part.getMasterAddress())) continue block2;
                                ClusterConnectionManager.this.log.debug("changing master from {} to {} for {}", new Object[]{part.getMasterAddress(), newMasterPart.getMasterAddress(), newMasterPart.getEndSlot()});
                                URI newUri = newMasterPart.getMasterAddress();
                                URI oldUri = part.getMasterAddress();
                                ClusterConnectionManager.this.changeMaster(newMasterPart.getEndSlot(), newUri.getHost(), newUri.getPort());
                                ClusterConnectionManager.this.slaveDown(newMasterPart.getEndSlot(), oldUri.getHost(), oldUri.getPort());
                                part.setMasterAddress(newMasterPart.getMasterAddress());
                                continue block2;
                            }
                        }
                        ClusterConnectionManager.this.checkSlotsChange(cfg, partitions);
                    }
                }
                catch (Exception e) {
                    ClusterConnectionManager.this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }, (long)cfg.getScanInterval(), (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void checkSlotsChange(ClusterServersConfig cfg, Map<Integer, ClusterPartition> partitions) {
        HashSet<Integer> removeSlots = new HashSet<Integer>(this.lastPartitions.keySet());
        removeSlots.removeAll(partitions.keySet());
        this.lastPartitions.keySet().removeAll(removeSlots);
        if (!removeSlots.isEmpty()) {
            this.log.info("{} slots found to remove", (Object)removeSlots.size());
        }
        HashMap<Integer, MasterSlaveEntry> removeAddrs = new HashMap<Integer, MasterSlaveEntry>();
        for (Integer slot : removeSlots) {
            MasterSlaveEntry masterSlaveEntry = this.removeMaster(slot);
            masterSlaveEntry.shutdownMasterAsync();
            removeAddrs.put(slot, masterSlaveEntry);
        }
        HashSet<Integer> addSlots = new HashSet<Integer>(partitions.keySet());
        addSlots.removeAll(this.lastPartitions.keySet());
        if (!addSlots.isEmpty()) {
            this.log.info("{} slots found to add", (Object)addSlots.size());
        }
        for (Integer n : addSlots) {
            ClusterPartition partition = partitions.get(n);
            this.addMasterEntry(partition, cfg);
        }
        for (Map.Entry entry : removeAddrs.entrySet()) {
            InetSocketAddress url = ((MasterSlaveEntry)entry.getValue()).getClient().getAddr();
            this.slaveDown((Integer)entry.getKey(), url.getHostName(), url.getPort());
        }
    }

    private Map<Integer, ClusterPartition> parsePartitions(String nodesValue) {
        HashMap<String, ClusterPartition> partitions = new HashMap<String, ClusterPartition>();
        HashMap<Integer, ClusterPartition> result = new HashMap<Integer, ClusterPartition>();
        List<ClusterNodeInfo> nodes = this.parse(nodesValue);
        for (ClusterNodeInfo clusterNodeInfo : nodes) {
            ClusterPartition partition;
            String id = clusterNodeInfo.getNodeId();
            if (clusterNodeInfo.getFlags().contains((Object)ClusterNodeInfo.Flag.SLAVE)) {
                id = clusterNodeInfo.getSlaveOf();
            }
            if ((partition = (ClusterPartition)partitions.get(id)) == null) {
                partition = new ClusterPartition();
                partitions.put(id, partition);
            }
            if (clusterNodeInfo.getFlags().contains((Object)ClusterNodeInfo.Flag.FAIL)) {
                partition.setMasterFail(true);
            }
            if (clusterNodeInfo.getFlags().contains((Object)ClusterNodeInfo.Flag.SLAVE)) {
                partition.addSlaveAddress(clusterNodeInfo.getAddress());
                continue;
            }
            partition.setStartSlot(clusterNodeInfo.getStartSlot());
            partition.setEndSlot(clusterNodeInfo.getEndSlot());
            result.put(clusterNodeInfo.getEndSlot(), partition);
            partition.setMasterAddress(clusterNodeInfo.getAddress());
        }
        return result;
    }

    private MasterSlaveServersConfig create(ClusterServersConfig cfg) {
        MasterSlaveServersConfig c = new MasterSlaveServersConfig();
        c.setRetryInterval(cfg.getRetryInterval());
        c.setRetryAttempts(cfg.getRetryAttempts());
        c.setTimeout(cfg.getTimeout());
        c.setPingTimeout(cfg.getPingTimeout());
        c.setLoadBalancer(cfg.getLoadBalancer());
        c.setPassword(cfg.getPassword());
        c.setDatabase(cfg.getDatabase());
        c.setClientName(cfg.getClientName());
        c.setMasterConnectionPoolSize(cfg.getMasterConnectionPoolSize());
        c.setSlaveConnectionPoolSize(cfg.getSlaveConnectionPoolSize());
        c.setSlaveSubscriptionConnectionPoolSize(cfg.getSlaveSubscriptionConnectionPoolSize());
        c.setSubscriptionsPerConnection(cfg.getSubscriptionsPerConnection());
        return c;
    }

    private List<ClusterNodeInfo> parse(String nodesResponse) {
        ArrayList<ClusterNodeInfo> nodes = new ArrayList<ClusterNodeInfo>();
        for (String nodeInfo : nodesResponse.split("\n")) {
            ClusterNodeInfo node = new ClusterNodeInfo();
            String[] params = nodeInfo.split(" ");
            String nodeId = params[0];
            node.setNodeId(nodeId);
            String addr = params[1];
            node.setAddress(addr);
            String flags = params[2];
            for (String flag : flags.split(",")) {
                String flagValue = flag.toUpperCase().replaceAll("\\?", "");
                node.addFlag(ClusterNodeInfo.Flag.valueOf(flagValue));
            }
            String slaveOf = params[3];
            if (!"-".equals(slaveOf)) {
                node.setSlaveOf(slaveOf);
            }
            if (params.length > 8) {
                String slots = params[8];
                String[] parts = slots.split("-");
                node.setStartSlot(Integer.valueOf(parts[0]));
                node.setEndSlot(Integer.valueOf(parts[1]));
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void shutdown() {
        this.monitorFuture.cancel(true);
        super.shutdown();
        for (RedisConnection connection : this.nodeConnections.values()) {
            connection.getRedisClient().shutdown();
        }
    }
}

