/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.LoadBalancer;
import org.redisson.connection.SubscribesConnectionEntry;
import org.redisson.misc.ReclosableLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseLoadBalancer
implements LoadBalancer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MasterSlaveServersConfig config;
    private ConnectionManager connectionManager;
    private final ReclosableLatch clientsEmpty = new ReclosableLatch();
    final Map<RedisClient, SubscribesConnectionEntry> clients = PlatformDependent.newConcurrentHashMap();

    BaseLoadBalancer() {
    }

    @Override
    public void init(MasterSlaveServersConfig config, ConnectionManager connectionManager) {
        this.config = config;
        this.connectionManager = connectionManager;
    }

    @Override
    public synchronized void add(SubscribesConnectionEntry entry) {
        this.clients.put(entry.getClient(), entry);
        if (!entry.isFreezed()) {
            this.clientsEmpty.open();
        }
    }

    @Override
    public int getAvailableClients() {
        int count = 0;
        for (SubscribesConnectionEntry connectionEntry : this.clients.values()) {
            if (connectionEntry.isFreezed()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public synchronized void unfreeze(String host, int port) {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        for (SubscribesConnectionEntry connectionEntry : this.clients.values()) {
            if (!connectionEntry.getClient().getAddr().equals(addr)) continue;
            connectionEntry.setFreezed(false);
            this.clientsEmpty.open();
            return;
        }
        throw new IllegalStateException("Can't find " + addr + " in slaves!");
    }

    @Override
    public synchronized Collection<RedisPubSubConnection> freeze(String host, int port) {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        for (SubscribesConnectionEntry connectionEntry : this.clients.values()) {
            RedisConnection connection;
            if (connectionEntry.isFreezed() || !connectionEntry.getClient().getAddr().equals(addr)) continue;
            this.log.debug("{} freezed", (Object)addr);
            connectionEntry.setFreezed(true);
            while ((connection = connectionEntry.getConnections().poll()) != null) {
                connection.closeAsync();
            }
            while ((connection = connectionEntry.pollFreeSubscribeConnection()) != null) {
                connection.closeAsync();
            }
            boolean allFreezed = true;
            for (SubscribesConnectionEntry entry : this.clients.values()) {
                if (entry.isFreezed()) continue;
                allFreezed = false;
                break;
            }
            if (allFreezed) {
                this.clientsEmpty.close();
            }
            ArrayList<RedisPubSubConnection> list = new ArrayList<RedisPubSubConnection>(connectionEntry.getAllSubscribeConnections());
            connectionEntry.getAllSubscribeConnections().clear();
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public RedisPubSubConnection nextPubSubConnection() {
        this.clientsEmpty.awaitUninterruptibly();
        ArrayList<SubscribesConnectionEntry> clientsCopy = new ArrayList<SubscribesConnectionEntry>(this.clients.values());
        while (true) {
            if (clientsCopy.isEmpty()) {
                throw new RedisConnectionException("Slave subscribe-connection pool gets exhausted!");
            }
            int index = this.getIndex(clientsCopy);
            SubscribesConnectionEntry entry = (SubscribesConnectionEntry)clientsCopy.get(index);
            if (entry.isFreezed() || !entry.getSubscribeConnectionsSemaphore().tryAcquire()) {
                clientsCopy.remove(index);
                continue;
            }
            try {
                RedisPubSubConnection conn = entry.pollFreeSubscribeConnection();
                if (conn != null) {
                    return conn;
                }
                conn = entry.getClient().connectPubSub();
                if (this.config.getPassword() != null) {
                    conn.sync(RedisCommands.AUTH, this.config.getPassword());
                }
                if (this.config.getDatabase() != 0) {
                    conn.sync(RedisCommands.SELECT, this.config.getDatabase());
                }
                if (this.config.getClientName() != null) {
                    conn.sync(RedisCommands.CLIENT_SETNAME, this.config.getClientName());
                }
                entry.registerSubscribeConnection(conn);
                return conn;
            }
            catch (RedisConnectionException e) {
                entry.getSubscribeConnectionsSemaphore().release();
                this.log.warn("Can't connect to {}, trying next connection!", (Object)entry.getClient().getAddr());
                clientsCopy.remove(index);
                continue;
            }
            break;
        }
    }

    @Override
    public RedisConnection getConnection(RedisClient client) {
        SubscribesConnectionEntry entry = this.clients.get(client);
        if (entry != null) {
            RedisConnection conn = this.retrieveConnection(entry);
            if (conn == null) {
                throw new RedisConnectionException("Slave connection pool gets exhausted for " + client);
            }
            return conn;
        }
        throw new RedisConnectionException("Can't find entry for " + client);
    }

    @Override
    public RedisConnection nextConnection() {
        RedisConnection conn;
        this.clientsEmpty.awaitUninterruptibly();
        ArrayList<SubscribesConnectionEntry> clientsCopy = new ArrayList<SubscribesConnectionEntry>(this.clients.values());
        while (true) {
            if (clientsCopy.isEmpty()) {
                throw new RedisConnectionException("Slave connection pool gets exhausted!");
            }
            int index = this.getIndex(clientsCopy);
            SubscribesConnectionEntry entry = (SubscribesConnectionEntry)clientsCopy.get(index);
            conn = this.retrieveConnection(entry);
            if (conn != null) break;
            clientsCopy.remove(index);
        }
        return conn;
    }

    private RedisConnection retrieveConnection(SubscribesConnectionEntry entry) {
        if (entry.isFreezed() || !entry.getConnectionsSemaphore().tryAcquire()) {
            return null;
        }
        RedisConnection conn = entry.getConnections().poll();
        if (conn != null) {
            return conn;
        }
        try {
            return entry.connect(this.config);
        }
        catch (RedisException e) {
            entry.getConnectionsSemaphore().release();
            this.log.warn("Can't connect to {}, trying next connection!", (Object)entry.getClient().getAddr());
            return null;
        }
    }

    abstract int getIndex(List<SubscribesConnectionEntry> var1);

    @Override
    public void returnSubscribeConnection(RedisPubSubConnection connection) {
        SubscribesConnectionEntry entry = this.clients.get(connection.getRedisClient());
        if (entry.isFreezed()) {
            connection.closeAsync();
        } else {
            entry.offerFreeSubscribeConnection(connection);
        }
        entry.getSubscribeConnectionsSemaphore().release();
    }

    @Override
    public void returnConnection(RedisConnection connection) {
        SubscribesConnectionEntry entry = this.clients.get(connection.getRedisClient());
        if (entry.isFreezed()) {
            connection.closeAsync();
        } else {
            entry.getConnections().add(connection);
        }
        entry.getConnectionsSemaphore().release();
    }

    @Override
    public void shutdown() {
        for (SubscribesConnectionEntry entry : this.clients.values()) {
            entry.getClient().shutdown();
        }
    }

    @Override
    public void shutdownAsync() {
        for (RedisClient client : this.clients.keySet()) {
            this.connectionManager.shutdownAsync(client);
        }
    }
}

