/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class SerializationCodec
implements Codec {
    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) throws IOException {
                try {
                    ObjectInputStream inputStream = new ObjectInputStream((InputStream)new ByteBufInputStream(buf));
                    return inputStream.readObject();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
    }

    @Override
    public Encoder getValueEncoder() {
        return new Encoder(){

            @Override
            public byte[] encode(Object in) throws IOException {
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                ObjectOutputStream outputStream = new ObjectOutputStream(result);
                outputStream.writeObject(in);
                outputStream.close();
                return result.toByteArray();
            }
        };
    }
}

