/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class JsonJacksonCodec
implements Codec {
    private ObjectMapper mapObjectMapper = new ObjectMapper();

    public JsonJacksonCodec() {
        this.init(this.mapObjectMapper);
        ObjectMapper.DefaultTypeResolverBuilder mapTyper = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL){

            public boolean useForType(JavaType t) {
                switch (this._appliesFor) {
                    case NON_CONCRETE_AND_ARRAYS: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                    }
                    case OBJECT_AND_NON_CONCRETE: {
                        return t.getRawClass() == Object.class || !t.isConcrete();
                    }
                    case NON_FINAL: {
                        while (t.isArrayType()) {
                            t = t.getContentType();
                        }
                        if (t.getRawClass() == Long.class) {
                            return true;
                        }
                        return !t.isFinal();
                    }
                }
                return t.getRawClass() == Object.class;
            }
        };
        mapTyper.init(JsonTypeInfo.Id.CLASS, null);
        mapTyper.inclusion(JsonTypeInfo.As.PROPERTY);
        this.mapObjectMapper.setDefaultTyping((TypeResolverBuilder)mapTyper);
    }

    protected void init(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setVisibilityChecker(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) throws IOException {
                return JsonJacksonCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), Object.class);
            }
        };
    }

    @Override
    public Encoder getMapValueEncoder() {
        return new Encoder(){

            @Override
            public byte[] encode(Object in) throws IOException {
                return JsonJacksonCodec.this.mapObjectMapper.writeValueAsBytes(in);
            }
        };
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getMapValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getMapValueEncoder();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.getMapValueDecoder();
    }

    @Override
    public Encoder getValueEncoder() {
        return this.getMapValueEncoder();
    }
}

