/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class StringMapReplayDecoder
implements MultiDecoder<List<Map<String, String>>> {
    @Override
    public Object decode(ByteBuf buf, State state) {
        return buf.toString(CharsetUtil.UTF_8);
    }

    @Override
    public List<Map<String, String>> decode(List<Object> parts, State state) {
        if (!parts.isEmpty() && parts.get(0) instanceof List) {
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(parts.size());
            for (Object object : parts) {
                List list = (List)object;
                result.addAll(list);
            }
            return result;
        }
        HashMap<String, String> result = new HashMap<String, String>(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            result.put(parts.get(i - 1).toString(), parts.get(i).toString());
        }
        return Collections.singletonList(result);
    }

    @Override
    public boolean isApplicable(int paramNum, State state) {
        return true;
    }
}

