/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class NestedMultiDecoder<T>
implements MultiDecoder<Object> {
    private final MultiDecoder<Object> firstDecoder;
    private final MultiDecoder<Object> secondDecoder;

    public NestedMultiDecoder(MultiDecoder<Object> firstDecoder, MultiDecoder<Object> secondDecoder) {
        this.firstDecoder = firstDecoder;
        this.secondDecoder = secondDecoder;
    }

    @Override
    public Object decode(ByteBuf buf, State state) throws IOException {
        DecoderState ds = this.getDecoder(state);
        return ds.getFlipDecoders().peek().decode(buf, state);
    }

    @Override
    public boolean isApplicable(int paramNum, State state) {
        DecoderState ds = this.getDecoder(state);
        if (paramNum == 0) {
            ds.getFlipDecoders().poll();
        }
        return ds.getFlipDecoders().peek().isApplicable(paramNum, state);
    }

    private DecoderState getDecoder(State state) {
        DecoderState ds = (DecoderState)state.getDecoderState();
        if (ds == null) {
            ds = new DecoderState(this.firstDecoder, this.secondDecoder);
            state.setDecoderState(ds);
        }
        return ds;
    }

    @Override
    public Object decode(List<Object> parts, State state) {
        DecoderState ds = this.getDecoder(state);
        return ds.getDecoders().poll().decode(parts, state);
    }

    public static class DecoderState {
        Deque<MultiDecoder<?>> decoders;
        Deque<MultiDecoder<?>> flipDecoders;

        public DecoderState(MultiDecoder<Object> firstDecoder, MultiDecoder<Object> secondDecoder) {
            this.decoders = new ArrayDeque<MultiDecoder>(Arrays.asList(firstDecoder, secondDecoder));
            this.flipDecoders = new ArrayDeque<MultiDecoder>(Arrays.asList(firstDecoder, secondDecoder, firstDecoder));
        }

        public Deque<MultiDecoder<?>> getDecoders() {
            return this.decoders;
        }

        public Deque<MultiDecoder<?>> getFlipDecoders() {
            return this.flipDecoders;
        }
    }
}

