/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.redisson.client.RedisConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Bootstrap bootstrap;
    private final ChannelGroup channels;
    private static final int BACKOFF_CAP = 12;

    public ConnectionWatchdog(Bootstrap bootstrap, ChannelGroup channels) {
        this.bootstrap = bootstrap;
        this.channels = channels;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channels.add((Object)ctx.channel());
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        RedisConnection connection = (RedisConnection)ctx.channel().attr(RedisConnection.CONNECTION).get();
        if (!connection.isClosed()) {
            EventLoopGroup group = ctx.channel().eventLoop().parent();
            this.reconnect(group, connection);
        }
        ctx.fireChannelInactive();
    }

    private void reconnect(final EventLoopGroup group, final RedisConnection connection) {
        group.schedule(new Runnable(){

            @Override
            public void run() {
                ConnectionWatchdog.this.doReConnect(group, connection, 1);
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    private void doReConnect(final EventLoopGroup group, final RedisConnection connection, final int attempts) {
        if (connection.isClosed()) {
            return;
        }
        this.log.debug("reconnecting {} to {} ", new Object[]{connection, connection.getRedisClient().getAddr(), connection});
        this.bootstrap.connect().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (connection.isClosed()) {
                    return;
                }
                if (future.isSuccess()) {
                    ConnectionWatchdog.this.log.debug("{} connected to {}", (Object)connection, (Object)connection.getRedisClient().getAddr());
                    connection.updateChannel(future.channel());
                    return;
                }
                int timeout = 2 << attempts;
                group.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionWatchdog.this.doReConnect(group, connection, Math.min(12, attempts + 1));
                    }
                }, (long)timeout, TimeUnit.MILLISECONDS);
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().close();
    }
}

