/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.List;
import java.util.Queue;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.QueueCommandHolder;

public class CommandsQueue
extends ChannelDuplexHandler {
    public static final AttributeKey<QueueCommand> REPLAY = AttributeKey.valueOf((String)"promise");
    private final Queue<QueueCommandHolder> queue = PlatformDependent.newMpscQueue();

    public void sendNextCommand(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(REPLAY).remove();
        this.queue.poll();
        this.sendData(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof QueueCommand) {
            QueueCommand data = (QueueCommand)msg;
            if (this.queue.peek() != null && this.queue.peek().getCommand() == data) {
                super.write(ctx, msg, promise);
            } else {
                this.queue.add(new QueueCommandHolder(data, promise));
                this.sendData(ctx);
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private void sendData(final ChannelHandlerContext ctx) throws Exception {
        QueueCommandHolder command = this.queue.peek();
        if (command != null && command.getSended().compareAndSet(false, true)) {
            QueueCommand data = command.getCommand();
            List<CommandData<Object, Object>> pubSubOps = data.getPubSubOperations();
            if (!pubSubOps.isEmpty()) {
                for (CommandData<Object, Object> cd : pubSubOps) {
                    for (Object channel : cd.getParams()) {
                        ((CommandDecoder)ctx.pipeline().get(CommandDecoder.class)).addChannel(channel.toString(), cd);
                    }
                }
            } else {
                ctx.channel().attr(REPLAY).set((Object)data);
            }
            command.getChannelPromise().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        CommandsQueue.this.sendNextCommand(ctx);
                    }
                }
            });
            ctx.channel().writeAndFlush((Object)data, command.getChannelPromise());
        }
    }
}

