/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.CharsetUtil;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.Encoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.StringParamsEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandEncoder
extends MessageToByteEncoder<CommandData<Object, Object>> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Encoder paramsEncoder = new StringParamsEncoder();
    final char ARGS_PREFIX = (char)42;
    final char BYTES_PREFIX = (char)36;
    final byte[] CRLF = "\r\n".getBytes();
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    protected void encode(ChannelHandlerContext ctx, CommandData<Object, Object> msg, ByteBuf out) throws Exception {
        out.writeByte(42);
        int len = 1 + msg.getParams().length;
        if (msg.getCommand().getSubName() != null) {
            ++len;
        }
        out.writeBytes(CommandEncoder.toChars(len));
        out.writeBytes(this.CRLF);
        this.writeArgument(out, msg.getCommand().getName().getBytes("UTF-8"));
        if (msg.getCommand().getSubName() != null) {
            this.writeArgument(out, msg.getCommand().getSubName().getBytes("UTF-8"));
        }
        int i = 1;
        for (Object param : msg.getParams()) {
            Encoder encoder = this.paramsEncoder;
            if (msg.getCommand().getInParamType().size() == 1) {
                if (msg.getCommand().getInParamIndex() == i && msg.getCommand().getInParamType().get(0) == RedisCommand.ValueType.OBJECT) {
                    encoder = msg.getCodec().getValueEncoder();
                } else if (msg.getCommand().getInParamIndex() <= i && msg.getCommand().getInParamType().get(0) != RedisCommand.ValueType.OBJECT) {
                    encoder = this.encoder(msg, i - msg.getCommand().getInParamIndex());
                }
            } else {
                int paramNum = i - msg.getCommand().getInParamIndex();
                if (msg.getCommand().getInParamIndex() <= i) {
                    encoder = this.encoder(msg, paramNum);
                }
            }
            this.writeArgument(out, encoder.encode(param));
            ++i;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("channel: {} message: {}", (Object)ctx.channel(), (Object)out.toString(CharsetUtil.UTF_8));
        }
    }

    private Encoder encoder(CommandData<Object, Object> msg, int param) {
        int typeIndex = 0;
        if (msg.getCommand().getInParamType().size() > 1) {
            typeIndex = param;
        }
        if (msg.getCommand().getInParamType().get(typeIndex) == RedisCommand.ValueType.MAP) {
            if (param % 2 != 0) {
                return msg.getCodec().getMapValueEncoder();
            }
            return msg.getCodec().getMapKeyEncoder();
        }
        if (msg.getCommand().getInParamType().get(typeIndex) == RedisCommand.ValueType.MAP_KEY) {
            return msg.getCodec().getMapKeyEncoder();
        }
        if (msg.getCommand().getInParamType().get(typeIndex) == RedisCommand.ValueType.MAP_VALUE) {
            return msg.getCodec().getMapValueEncoder();
        }
        if (msg.getCommand().getInParamType().get(typeIndex) == RedisCommand.ValueType.OBJECTS) {
            return msg.getCodec().getValueEncoder();
        }
        throw new IllegalStateException();
    }

    private void writeArgument(ByteBuf out, byte[] arg) {
        out.writeByte(36);
        out.writeBytes(CommandEncoder.toChars(arg.length));
        out.writeBytes(this.CRLF);
        out.writeBytes(arg);
        out.writeBytes(this.CRLF);
    }

    static int stringSize(long x) {
        int i = 0;
        while (x > (long)sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static void getChars(long i, int index, byte[] buf) {
        long r;
        long q;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536L) {
            q = i / 100L;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = (byte)DigitOnes[(int)r];
            buf[--charPos] = (byte)DigitTens[(int)r];
        }
        do {
            q = i * 52429L >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = (byte)digits[(int)r];
        } while ((i = q) != 0L);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static byte[] toChars(long i) {
        int size = i < 0L ? CommandEncoder.stringSize(-i) + 1 : CommandEncoder.stringSize(i);
        byte[] buf = new byte[size];
        CommandEncoder.getChars(i, size, buf);
        return buf;
    }
}

