/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.RedisException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.pubsub.Message;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDecoder
extends ReplayingDecoder<State> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final char CR = '\r';
    public static final char LF = '\n';
    private static final char ZERO = '0';
    private final Map<String, MultiDecoder<Object>> messageDecoders = new HashMap<String, MultiDecoder<Object>>();
    private final Map<String, CommandData<Object, Object>> channels = PlatformDependent.newConcurrentHashMap();

    public void addChannel(String channel, CommandData<Object, Object> data) {
        this.channels.put(channel, data);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        QueueCommand data = (QueueCommand)ctx.channel().attr(CommandsQueue.REPLAY).get();
        Decoder<Object> currentDecoder = null;
        if (data == null) {
            currentDecoder = new Decoder<Object>(){

                @Override
                public Object decode(ByteBuf buf, State state) {
                    return buf.toString(CharsetUtil.UTF_8);
                }
            };
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("channel: {} message: {}", (Object)ctx.channel(), (Object)in.toString(0, in.writerIndex(), CharsetUtil.UTF_8));
        }
        if (this.state() == null) {
            this.state(new State());
        }
        ((State)this.state()).setDecoderState(null);
        if (data == null) {
            this.decode(in, null, null, ctx.channel(), currentDecoder);
        } else if (data instanceof CommandData) {
            CommandData cmd = (CommandData)data;
            try {
                this.decode(in, cmd, null, ctx.channel(), currentDecoder);
            }
            catch (IOException e) {
                cmd.getPromise().setFailure((Throwable)e);
            }
        } else if (data instanceof CommandsData) {
            CommandsData commands = (CommandsData)data;
            int i = ((State)this.state()).getIndex();
            while (in.writerIndex() > in.readerIndex()) {
                CommandData<Object, Object> cmd = null;
                try {
                    this.checkpoint();
                    ((State)this.state()).setIndex(i);
                    cmd = commands.getCommands().get(i);
                    this.decode(in, cmd, null, ctx.channel(), currentDecoder);
                    ++i;
                }
                catch (IOException e) {
                    cmd.getPromise().setFailure((Throwable)e);
                }
            }
            if (i == commands.getCommands().size()) {
                Promise<Void> promise = commands.getPromise();
                if (!promise.trySuccess(null) && promise.isCancelled()) {
                    this.log.warn("response has been skipped due to timeout! channel: {}, command: {}", (Object)ctx.channel(), (Object)data);
                }
                ((CommandsQueue)ctx.pipeline().get(CommandsQueue.class)).sendNextCommand(ctx);
                this.state(null);
            } else {
                this.checkpoint();
                ((State)this.state()).setIndex(i);
            }
            return;
        }
        ((CommandsQueue)ctx.pipeline().get(CommandsQueue.class)).sendNextCommand(ctx);
        this.state(null);
    }

    private void decode(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel, Decoder<Object> currentDecoder) throws IOException {
        byte code = in.readByte();
        if (code == 43) {
            String result = in.readBytes(in.bytesBefore((byte)13)).toString(CharsetUtil.UTF_8);
            in.skipBytes(2);
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 45) {
            String error = in.readBytes(in.bytesBefore((byte)13)).toString(CharsetUtil.UTF_8);
            in.skipBytes(2);
            if (error.startsWith("MOVED")) {
                String[] errorParts = error.split(" ");
                int slot = Integer.valueOf(errorParts[1]);
                data.getPromise().setFailure((Throwable)new RedisMovedException(slot));
            } else if (error.startsWith("(error) ASK")) {
                String[] errorParts = error.split(" ");
                int slot = Integer.valueOf(errorParts[2]);
                data.getPromise().setFailure((Throwable)new RedisMovedException(slot));
            } else {
                data.getPromise().setFailure((Throwable)new RedisException(error + ". channel: " + channel + " command: " + data));
            }
        } else if (code == 58) {
            String status = in.readBytes(in.bytesBefore((byte)13)).toString(CharsetUtil.UTF_8);
            in.skipBytes(2);
            Long result = Long.valueOf(status);
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 36) {
            ByteBuf buf = this.readBytes(in);
            Object result = null;
            if (buf != null) {
                result = this.decoder(data, parts, currentDecoder).decode(buf, (State)this.state());
            }
            this.handleResult(data, parts, result, false, channel);
        } else if (code == 42) {
            long size = CommandDecoder.readLong(in);
            ArrayList<Object> respParts = new ArrayList<Object>();
            this.decodeMulti(in, data, parts, channel, currentDecoder, size, respParts);
        } else {
            throw new IllegalStateException("Can't decode replay " + (char)code);
        }
    }

    private void decodeMulti(ByteBuf in, CommandData<Object, Object> data, List<Object> parts, Channel channel, Decoder<Object> currentDecoder, long size, List<Object> respParts) throws IOException {
        int i = respParts.size();
        while ((long)i < size) {
            this.decode(in, data, respParts, channel, currentDecoder);
            ++i;
        }
        Object result = this.messageDecoder(data, respParts).decode(respParts, (State)this.state());
        if (result instanceof Message) {
            this.handleMultiResult(data, null, channel, result);
            if (in.writerIndex() > in.readerIndex()) {
                this.decode(in, data, null, channel, currentDecoder);
            }
        } else {
            this.handleMultiResult(data, parts, channel, result);
        }
    }

    private void handleMultiResult(CommandData<Object, Object> data, List<Object> parts, Channel channel, Object result) {
        if (data == null && result instanceof PubSubStatusMessage) {
            String channelName = ((PubSubStatusMessage)result).getChannel();
            CommandData<Object, Object> d = this.channels.get(channelName);
            if (Arrays.asList("PSUBSCRIBE", "SUBSCRIBE").contains(d.getCommand().getName())) {
                this.channels.remove(channelName);
                this.messageDecoders.put(channelName, d.getMessageDecoder());
            }
            if (Arrays.asList("PUNSUBSCRIBE", "UNSUBSCRIBE").contains(d.getCommand().getName())) {
                this.channels.remove(channelName);
                this.messageDecoders.remove(channelName);
            }
        }
        if (data != null) {
            this.handleResult(data, parts, result, true, channel);
        } else {
            RedisPubSubConnection pubSubConnection = (RedisPubSubConnection)channel.attr(RedisPubSubConnection.CONNECTION).get();
            if (result instanceof PubSubStatusMessage) {
                pubSubConnection.onMessage((PubSubStatusMessage)result);
            } else if (result instanceof PubSubMessage) {
                pubSubConnection.onMessage((PubSubMessage)result);
            } else {
                pubSubConnection.onMessage((PubSubPatternMessage)result);
            }
        }
    }

    private void handleResult(CommandData<Object, Object> data, List<Object> parts, Object result, boolean multiResult, Channel channel) {
        if (data != null) {
            result = multiResult ? data.getCommand().getConvertor().convertMulti(result) : data.getCommand().getConvertor().convert(result);
        }
        if (parts != null) {
            parts.add(result);
        } else if (!data.getPromise().trySuccess(result) && data.getPromise().isCancelled()) {
            this.log.warn("response has been skipped due to timeout! channel: {}, command: {}, result: {}", new Object[]{channel, data, result});
        }
    }

    private MultiDecoder<Object> messageDecoder(CommandData<Object, Object> data, List<Object> parts) {
        if (data == null) {
            if (Arrays.asList("subscribe", "psubscribe", "punsubscribe", "unsubscribe").contains(parts.get(0))) {
                String channelName = (String)parts.get(1);
                return this.channels.get(channelName).getCommand().getReplayMultiDecoder();
            }
            if (parts.get(0).equals("message")) {
                String channelName = (String)parts.get(1);
                return this.messageDecoders.get(channelName);
            }
            if (parts.get(0).equals("pmessage")) {
                String patternName = (String)parts.get(1);
                return this.messageDecoders.get(patternName);
            }
        }
        return data.getCommand().getReplayMultiDecoder();
    }

    private Decoder<Object> decoder(CommandData<Object, Object> data, List<Object> parts, Decoder<Object> currentDecoder) {
        MultiDecoder<Object> multiDecoder;
        if (data == null) {
            if (parts.size() == 2 && parts.get(0).equals("message")) {
                String channelName = (String)parts.get(1);
                return this.messageDecoders.get(channelName);
            }
            if (parts.size() == 3 && parts.get(0).equals("pmessage")) {
                String patternName = (String)parts.get(1);
                return this.messageDecoders.get(patternName);
            }
            return currentDecoder;
        }
        Decoder<Object> decoder = data.getCommand().getReplayDecoder();
        if (parts != null && (multiDecoder = data.getCommand().getReplayMultiDecoder()).isApplicable(parts.size(), (State)this.state())) {
            decoder = multiDecoder;
        }
        if (decoder == null) {
            decoder = data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP ? (parts.size() % 2 != 0 ? data.getCodec().getMapKeyDecoder() : data.getCodec().getMapValueDecoder()) : (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_KEY ? data.getCodec().getMapKeyDecoder() : (data.getCommand().getOutParamType() == RedisCommand.ValueType.MAP_VALUE ? data.getCodec().getMapValueDecoder() : data.getCodec().getValueDecoder()));
        }
        return decoder;
    }

    public ByteBuf readBytes(ByteBuf is) throws IOException {
        long l = CommandDecoder.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    public static long readLong(ByteBuf is) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }
}

