/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.codec;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class StringCodec
implements Codec {
    public static final StringCodec INSTANCE = new StringCodec();

    @Override
    public Decoder<Object> getValueDecoder() {
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) {
                return buf.toString(CharsetUtil.UTF_8);
            }
        };
    }

    @Override
    public Encoder getValueEncoder() {
        return new Encoder(){

            @Override
            public byte[] encode(Object in) throws IOException {
                return in.toString().getBytes("UTF-8");
            }
        };
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.getValueEncoder();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.getValueDecoder();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.getValueEncoder();
    }
}

