/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.Channel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.client.OneShotPubSubListener;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.pubsub.PubSubMessage;
import org.redisson.client.protocol.pubsub.PubSubMessageDecoder;
import org.redisson.client.protocol.pubsub.PubSubPatternMessage;
import org.redisson.client.protocol.pubsub.PubSubPatternMessageDecoder;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;

public class RedisPubSubConnection
extends RedisConnection {
    final Queue<RedisPubSubListener<Object>> listeners = new ConcurrentLinkedQueue<RedisPubSubListener<Object>>();

    public RedisPubSubConnection(RedisClient redisClient, Channel channel) {
        super(redisClient, channel);
    }

    public void addListener(RedisPubSubListener listener) {
        this.listeners.add(listener);
    }

    public void addOneShotListener(RedisPubSubListener listener) {
        this.listeners.add(new OneShotPubSubListener(this, listener));
    }

    public void removeListener(RedisPubSubListener<?> listener) {
        this.listeners.remove(listener);
    }

    public void onMessage(PubSubStatusMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onStatus(message.getType(), message.getChannel());
        }
    }

    public void onMessage(PubSubMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onMessage(message.getChannel(), message.getValue());
        }
    }

    public void onMessage(PubSubPatternMessage message) {
        for (RedisPubSubListener redisPubSubListener : this.listeners) {
            redisPubSubListener.onPatternMessage(message.getPattern(), message.getChannel(), message.getValue());
        }
    }

    public void subscribe(Codec codec, String ... channel) {
        this.async(new PubSubMessageDecoder(codec.getValueDecoder()), RedisCommands.SUBSCRIBE, (Object[])channel);
    }

    public void psubscribe(Codec codec, String ... channel) {
        this.async(new PubSubPatternMessageDecoder(codec.getValueDecoder()), RedisCommands.PSUBSCRIBE, (Object[])channel);
    }

    public void unsubscribe(String ... channel) {
        this.async((MultiDecoder<Object>)null, RedisCommands.UNSUBSCRIBE, (Object[])channel);
    }

    public void punsubscribe(String ... channel) {
        this.async((MultiDecoder<Object>)null, RedisCommands.PUNSUBSCRIBE, (Object[])channel);
    }

    private <T, R> void async(MultiDecoder<Object> messageDecoder, RedisCommand<T> command, Object ... params) {
        this.channel.writeAndFlush(new CommandData(null, messageDecoder, null, command, params));
    }
}

