/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.TimeUnit;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;

public class RedisConnection
implements RedisCommands {
    public static final AttributeKey<RedisConnection> CONNECTION = AttributeKey.valueOf((String)"connection");
    final RedisClient redisClient;
    private volatile boolean closed;
    volatile Channel channel;

    public RedisConnection(RedisClient redisClient, Channel channel) {
        this.redisClient = redisClient;
        this.updateChannel(channel);
    }

    public void updateChannel(Channel channel) {
        this.channel = channel;
        channel.attr(CONNECTION).set((Object)this);
    }

    public RedisClient getRedisClient() {
        return this.redisClient;
    }

    public <R> R await(Future<R> cmd) {
        if (!cmd.awaitUninterruptibly(this.redisClient.getTimeout(), TimeUnit.MILLISECONDS)) {
            Promise promise = (Promise)cmd;
            RedisTimeoutException ex = new RedisTimeoutException();
            promise.setFailure((Throwable)ex);
            throw ex;
        }
        if (!cmd.isSuccess()) {
            if (cmd.cause() instanceof RedisException) {
                throw (RedisException)cmd.cause();
            }
            throw new RedisException("Unexpected exception while processing command", cmd.cause());
        }
        return (R)cmd.getNow();
    }

    public <T> T sync(RedisStrictCommand<T> command, Object ... params) {
        Future r = this.async(null, command, params);
        return (T)this.await(r);
    }

    public <T, R> ChannelFuture send(CommandData<T, R> data) {
        return this.channel.writeAndFlush(data);
    }

    public ChannelFuture send(CommandsData data) {
        return this.channel.writeAndFlush((Object)data);
    }

    public <T, R> R sync(Codec encoder, RedisCommand<T> command, Object ... params) {
        Future<R> r = this.async(encoder, command, params);
        return this.await(r);
    }

    public <T, R> Future<R> async(RedisCommand<T> command, Object ... params) {
        return this.async(null, command, params);
    }

    public <T, R> Future<R> async(Codec encoder, RedisCommand<T> command, Object ... params) {
        Promise promise = this.redisClient.getBootstrap().group().next().newPromise();
        this.send(new CommandData(promise, encoder, command, params));
        return promise;
    }

    public <T, R> CommandData<T, R> create(Codec encoder, RedisCommand<T> command, Object ... params) {
        Promise promise = this.redisClient.getBootstrap().group().next().newPromise();
        return new CommandData(promise, encoder, command, params);
    }

    public void setClosed(boolean reconnect) {
        this.closed = reconnect;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ChannelFuture closeAsync() {
        this.setClosed(true);
        return this.channel.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [redisClient=" + this.redisClient + ", channel=" + this.channel + "]";
    }
}

