/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.handler.CommandEncoder;
import org.redisson.client.handler.CommandsListEncoder;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.ConnectionWatchdog;

public class RedisClient {
    private final Bootstrap bootstrap;
    private final InetSocketAddress addr;
    private final ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final long timeout;

    public RedisClient(String host, int port) {
        this((EventLoopGroup)new NioEventLoopGroup(), NioSocketChannel.class, host, port, 60000);
    }

    public RedisClient(EventLoopGroup group, Class<? extends SocketChannel> socketChannelClass, String host, int port, int timeout) {
        this.addr = new InetSocketAddress(host, port);
        this.bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().channel(socketChannelClass)).group(group)).remoteAddress((SocketAddress)this.addr);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addFirst(new ChannelHandler[]{new ConnectionWatchdog(RedisClient.this.bootstrap, RedisClient.this.channels), new CommandEncoder(), new CommandsListEncoder(), new CommandsQueue(), new CommandDecoder()});
            }
        });
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeout);
        this.timeout = timeout;
    }

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    long getTimeout() {
        return this.timeout;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public RedisConnection connect() {
        try {
            ChannelFuture future = this.bootstrap.connect();
            future.syncUninterruptibly();
            return new RedisConnection(this, future.channel());
        }
        catch (Exception e) {
            throw new RedisConnectionException("unable to connect", e);
        }
    }

    public Future<RedisConnection> connectAsync() {
        final Promise f = this.bootstrap.group().next().newPromise();
        ChannelFuture channelFuture = this.bootstrap.connect();
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    RedisConnection c = new RedisConnection(RedisClient.this, future.channel());
                    f.setSuccess((Object)c);
                } else {
                    f.setFailure(future.cause());
                }
            }
        });
        return f;
    }

    public RedisPubSubConnection connectPubSub() {
        try {
            ChannelFuture future = this.bootstrap.connect();
            future.syncUninterruptibly();
            return new RedisPubSubConnection(this, future.channel());
        }
        catch (Exception e) {
            throw new RedisConnectionException("unable to connect", e);
        }
    }

    public void shutdown() {
        this.shutdownAsync().syncUninterruptibly();
    }

    public ChannelGroupFuture shutdownAsync() {
        return this.channels.close();
    }

    public String toString() {
        return "RedisClient [addr=" + this.addr + "]";
    }
}

