/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.net.URI;
import org.redisson.BaseConfig;
import org.redisson.misc.URIBuilder;

public class SingleServerConfig
extends BaseConfig<SingleServerConfig> {
    private URI address;
    private int subscriptionConnectionPoolSize = 25;
    private int connectionPoolSize = 100;

    SingleServerConfig() {
    }

    SingleServerConfig(SingleServerConfig config) {
        super(config);
        this.setAddress(config.getAddress());
        this.setConnectionPoolSize(config.getConnectionPoolSize());
        this.setSubscriptionConnectionPoolSize(config.getSubscriptionConnectionPoolSize());
    }

    public SingleServerConfig setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public SingleServerConfig setSubscriptionConnectionPoolSize(int subscriptionConnectionPoolSize) {
        this.subscriptionConnectionPoolSize = subscriptionConnectionPoolSize;
        return this;
    }

    public int getSubscriptionConnectionPoolSize() {
        return this.subscriptionConnectionPoolSize;
    }

    public SingleServerConfig setAddress(String address) {
        this.address = URIBuilder.create(address);
        return this;
    }

    public URI getAddress() {
        return this.address;
    }

    void setAddress(URI address) {
        this.address = address;
    }
}

