/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.redisson.BaseMasterSlaveServersConfig;
import org.redisson.misc.URIBuilder;

public class SentinelServersConfig
extends BaseMasterSlaveServersConfig<SentinelServersConfig> {
    private List<URI> sentinelAddresses = new ArrayList<URI>();
    private String masterName;

    public SentinelServersConfig() {
    }

    SentinelServersConfig(SentinelServersConfig config) {
        super(config);
        this.setSentinelAddresses(config.getSentinelAddresses());
        this.setMasterName(config.getMasterName());
    }

    public SentinelServersConfig setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public SentinelServersConfig addSentinelAddress(String ... addresses) {
        for (String address : addresses) {
            this.sentinelAddresses.add(URIBuilder.create(address));
        }
        return this;
    }

    public List<URI> getSentinelAddresses() {
        return this.sentinelAddresses;
    }

    void setSentinelAddresses(List<URI> sentinelAddresses) {
        this.sentinelAddresses = sentinelAddresses;
    }
}

