/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.Collections;
import java.util.List;
import org.redisson.CommandExecutor;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubStatusListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.core.MessageListener;
import org.redisson.core.RTopic;
import org.redisson.core.StatusListener;

public class RedissonTopic<M>
implements RTopic<M> {
    final CommandExecutor commandExecutor;
    private final String name;

    protected RedissonTopic(CommandExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
    }

    @Override
    public List<String> getChannelNames() {
        return Collections.singletonList(this.name);
    }

    @Override
    public long publish(M message) {
        return this.commandExecutor.get(this.publishAsync(message));
    }

    @Override
    public Future<Long> publishAsync(M message) {
        return this.commandExecutor.writeAsync(this.name, RedisCommands.PUBLISH, this.name, message);
    }

    @Override
    public int addListener(StatusListener listener) {
        return this.addListener(new PubSubStatusListener(listener, this.name));
    }

    @Override
    public int addListener(MessageListener<M> listener) {
        PubSubMessageListener<M> pubSubListener = new PubSubMessageListener<M>(listener, this.name);
        return this.addListener(pubSubListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private int addListener(RedisPubSubListener<M> pubSubListener) {
        PubSubConnectionEntry entry;
        PubSubConnectionEntry pubSubConnectionEntry = entry = this.commandExecutor.getConnectionManager().subscribe(this.name);
        synchronized (pubSubConnectionEntry) {
            if (entry.isActive()) {
                entry.addListener(this.name, pubSubListener);
                return pubSubListener.hashCode();
            }
        }
        return this.addListener(pubSubListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(int listenerId) {
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getEntry(this.name);
        if (entry == null) {
            return;
        }
        PubSubConnectionEntry pubSubConnectionEntry = entry;
        synchronized (pubSubConnectionEntry) {
            if (entry.isActive()) {
                entry.removeListener(this.name, listenerId);
                if (!entry.hasListeners(this.name)) {
                    this.commandExecutor.getConnectionManager().unsubscribe(this.name);
                }
                return;
            }
        }
        this.removeListener(listenerId);
    }
}

