/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.redisson.CommandExecutor;
import org.redisson.RedissonObject;
import org.redisson.SyncOperation;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.core.RSortedSet;

public class RedissonSortedSet<V>
extends RedissonObject
implements RSortedSet<V> {
    private Comparator<? super V> comparator = NaturalComparator.NATURAL_ORDER;

    protected RedissonSortedSet(CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.loadComparator();
        commandExecutor.write(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.SETNX, this.getCurrentVersionKey(), 0L);
    }

    private void loadComparator() {
        this.commandExecutor.read(this.getName(), new SyncOperation<Void>(){

            @Override
            public Void execute(Codec codec, RedisConnection conn) {
                RedissonSortedSet.this.loadComparator(conn);
                return null;
            }
        });
    }

    private void loadComparator(RedisConnection connection) {
        try {
            String comparatorSign = (String)connection.sync(StringCodec.INSTANCE, RedisCommands.GET, this.getComparatorKeyName());
            if (comparatorSign != null) {
                String[] parts = comparatorSign.split(":");
                String className = parts[0];
                String sign = parts[1];
                String result = RedissonSortedSet.calcClassSign(className);
                if (!result.equals(sign)) {
                    throw new IllegalStateException("Local class signature of " + className + " differs from used by this SortedSet!");
                }
                Class<?> clazz = Class.forName(className);
                this.comparator = (Comparator)clazz.newInstance();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String calcClassSign(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(result);
            outputStream.writeObject(clazz);
            outputStream.close();
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(result.toByteArray());
            return new BigInteger(1, crypt.digest()).toString(16);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't calculate sign of " + name, e);
        }
    }

    @Override
    public int size() {
        return (Integer)this.commandExecutor.read(this.getName(), RedisCommands.LLEN, this.getName());
    }

    private int size(RedisConnection connection) {
        return connection.sync(RedisCommands.LLEN, this.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(final Object o) {
        return this.commandExecutor.read(this.getName(), new SyncOperation<Boolean>(){

            @Override
            public Boolean execute(Codec codec, RedisConnection conn) {
                return RedissonSortedSet.this.binarySearch(o, codec, conn).getIndex() >= 0;
            }
        });
    }

    @Override
    public Iterator<V> iterator() {
        boolean ind = false;
        return new Iterator<V>(){
            private int currentIndex = -1;
            private boolean removeExecuted;

            @Override
            public boolean hasNext() {
                int size = RedissonSortedSet.this.size();
                return this.currentIndex + 1 < size && size > 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                ++this.currentIndex;
                this.removeExecuted = false;
                return RedissonSortedSet.this.get(this.currentIndex);
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonSortedSet.this.remove(this.currentIndex);
                --this.currentIndex;
                this.removeExecuted = true;
            }
        };
    }

    private void remove(final int index) {
        this.commandExecutor.write(this.getName(), new SyncOperation<V>(){

            @Override
            public V execute(Codec codec, RedisConnection conn) {
                if (index == 0) {
                    return conn.sync(codec, RedisCommands.LPOP, RedissonSortedSet.this.getName());
                }
                while (true) {
                    conn.sync(RedisCommands.WATCH, RedissonSortedSet.this.getName());
                    List tail = (List)conn.sync(codec, RedisCommands.LRANGE, RedissonSortedSet.this.getName(), index + 1, RedissonSortedSet.this.size());
                    conn.sync(RedisCommands.MULTI, new Object[0]);
                    conn.sync(codec, RedisCommands.LTRIM, RedissonSortedSet.this.getName(), 0, index - 1);
                    if (tail.isEmpty()) {
                        if (((List)conn.sync(codec, RedisCommands.EXEC, new Object[0])).size() != 1) continue;
                        return null;
                    }
                    tail.add(0, RedissonSortedSet.this.getName());
                    conn.sync(codec, RedisCommands.RPUSH, tail.toArray());
                    if (((List)conn.sync(codec, RedisCommands.EXEC, new Object[0])).size() == 2) break;
                }
                return null;
            }
        });
    }

    private V get(int index) {
        return (V)this.commandExecutor.read(this.getName(), RedisCommands.LINDEX, this.getName(), index);
    }

    @Override
    public Object[] toArray() {
        List res = (List)this.commandExecutor.read(this.getName(), RedisCommands.LRANGE, this.getName(), 0, -1);
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List res = (List)this.commandExecutor.read(this.getName(), RedisCommands.LRANGE, this.getName(), 0, -1);
        return res.toArray(a);
    }

    private String getCurrentVersionKey() {
        return "redisson__sortedset__version__{" + this.getName() + "}";
    }

    private Long getCurrentVersion(Codec codec, RedisConnection simpleConnection) {
        return (Long)simpleConnection.sync(LongCodec.INSTANCE, RedisCommands.GET, this.getCurrentVersionKey());
    }

    @Override
    public boolean add(final V value) {
        return this.commandExecutor.write(this.getName(), new SyncOperation<Boolean>(){

            @Override
            public Boolean execute(Codec codec, RedisConnection conn) {
                return RedissonSortedSet.this.add(value, codec, conn);
            }
        });
    }

    @Override
    public Future<Boolean> addAsync(final V value) {
        EventLoop loop = this.commandExecutor.getConnectionManager().getGroup().next();
        final Promise promise = loop.newPromise();
        loop.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean result = RedissonSortedSet.this.add(value);
                    promise.setSuccess((Object)result);
                }
                catch (Exception e) {
                    promise.setFailure((Throwable)e);
                }
            }
        });
        return promise;
    }

    boolean add(V value, Codec codec, RedisConnection connection) {
        block5: {
            while (true) {
                connection.sync(RedisCommands.WATCH, this.getName(), this.getComparatorKeyName());
                this.checkComparator(connection);
                Long version = this.getCurrentVersion(codec, connection);
                BinarySearchResult<V> res = this.binarySearch(value, codec, connection);
                if (res.getIndex() >= 0) break block5;
                if (!version.equals(this.getCurrentVersion(codec, connection))) {
                    connection.sync(RedisCommands.UNWATCH, new Object[0]);
                    continue;
                }
                Object pivot = null;
                boolean before = false;
                int index = -(res.getIndex() + 1);
                if (index < this.size()) {
                    before = true;
                    pivot = connection.sync(codec, RedisCommands.LINDEX, this.getName(), index);
                }
                connection.sync(RedisCommands.MULTI, new Object[0]);
                if (index >= this.size()) {
                    connection.sync(codec, RedisCommands.RPUSH, this.getName(), value);
                } else {
                    connection.sync(codec, RedisCommands.LINSERT, this.getName(), before ? "BEFORE" : "AFTER", pivot, value);
                }
                connection.sync(RedisCommands.INCR, this.getCurrentVersionKey());
                List re = (List)connection.sync(codec, RedisCommands.EXEC, new Object[0]);
                if (re.size() == 2) break;
            }
            return true;
        }
        connection.sync(RedisCommands.UNWATCH, new Object[0]);
        return false;
    }

    private void checkComparator(RedisConnection connection) {
        String comparatorSign = (String)connection.sync(StringCodec.INSTANCE, RedisCommands.GET, this.getComparatorKeyName());
        if (comparatorSign != null) {
            String[] vals = comparatorSign.split(":");
            String className = vals[0];
            if (!this.comparator.getClass().getName().equals(className)) {
                this.loadComparator(connection);
            }
        }
    }

    public static double calcIncrement(double value) {
        BigDecimal b = BigDecimal.valueOf(value);
        BigDecimal r = b.remainder(BigDecimal.ONE);
        if (r.compareTo(BigDecimal.ZERO) == 0) {
            return 1.0;
        }
        double res = 1.0 / Math.pow(10.0, r.scale());
        return res;
    }

    @Override
    public Future<Boolean> removeAsync(final V value) {
        EventLoopGroup group = this.commandExecutor.getConnectionManager().getGroup();
        final Promise promise = group.next().newPromise();
        group.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean result = RedissonSortedSet.this.remove(value);
                    promise.setSuccess((Object)result);
                }
                catch (Exception e) {
                    promise.setFailure((Throwable)e);
                }
            }
        });
        return promise;
    }

    @Override
    public boolean remove(final Object value) {
        return this.commandExecutor.write(this.getName(), new SyncOperation<Boolean>(){

            @Override
            public Boolean execute(Codec codec, RedisConnection conn) {
                return RedissonSortedSet.this.remove(value, codec, conn);
            }
        });
    }

    boolean remove(Object value, Codec codec, RedisConnection conn) {
        while (true) {
            conn.sync(RedisCommands.WATCH, this.getName());
            BinarySearchResult<Object> res = this.binarySearch(value, codec, conn);
            if (res.getIndex() < 0) {
                conn.sync(RedisCommands.UNWATCH, new Object[0]);
                return false;
            }
            if (res.getIndex() == 0) {
                conn.sync(RedisCommands.MULTI, new Object[0]);
                conn.sync(codec, RedisCommands.LPOP, this.getName());
                if (((List)conn.sync(codec, RedisCommands.EXEC, new Object[0])).size() == 1) {
                    return true;
                }
            }
            List tail = (List)conn.sync(codec, RedisCommands.LRANGE, this.getName(), res.getIndex() + 1, this.size());
            conn.sync(RedisCommands.MULTI, new Object[0]);
            conn.sync(RedisCommands.LTRIM, this.getName(), 0, res.getIndex() - 1);
            if (tail.isEmpty()) {
                if (((List)conn.sync(codec, RedisCommands.EXEC, new Object[0])).size() != 1) continue;
                return true;
            }
            tail.add(0, this.getName());
            conn.sync(codec, RedisCommands.RPUSH, tail.toArray());
            if (((List)conn.sync(codec, RedisCommands.EXEC, new Object[0])).size() == 2) break;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V v : c) {
            if (!this.add(v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<V> iterator = this.iterator();
        while (iterator.hasNext()) {
            V object = iterator.next();
            if (c.contains(object)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<V> subSet(V fromElement, V toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<V> headSet(V toElement) {
        return this.subSet((V)null, toElement);
    }

    @Override
    public SortedSet<V> tailSet(V fromElement) {
        return this.subSet(fromElement, (V)null);
    }

    @Override
    public V first() {
        Object res = this.commandExecutor.read(this.getName(), RedisCommands.LINDEX, this.getName(), 0);
        if (res == null) {
            throw new NoSuchElementException();
        }
        return (V)res;
    }

    @Override
    public V last() {
        Object res = this.commandExecutor.read(this.getName(), RedisCommands.LINDEX, this.getName(), -1);
        if (res == null) {
            throw new NoSuchElementException();
        }
        return (V)res;
    }

    private String getScoreKeyName(int index) {
        return "redisson__sortedset__score__" + this.getName() + "__" + index;
    }

    private String getComparatorKeyName() {
        return "redisson__sortedset__comparator__{" + this.getName() + "}";
    }

    @Override
    public boolean trySetComparator(Comparator<? super V> comparator) {
        String className = comparator.getClass().getName();
        String comparatorSign = className + ":" + RedissonSortedSet.calcClassSign(className);
        Boolean res = (Boolean)this.commandExecutor.evalWrite(this.getName(), RedisCommands.EVAL_BOOLEAN, "if redis.call('llen', KEYS[1]) == 0 then redis.call('set', KEYS[2], ARGV[1]); return true; else return false; end", Arrays.asList(this.getName(), this.getComparatorKeyName()), comparatorSign);
        if (res.booleanValue()) {
            this.comparator = comparator;
        }
        return res;
    }

    private V getAtIndex(Codec codec, int index, RedisConnection connection) {
        return (V)connection.sync(codec, RedisCommands.LINDEX, this.getName(), index);
    }

    private BinarySearchResult<V> binarySearch(V value, Codec codec, RedisConnection connection, int lowerIndex, int upperIndex) {
        while (lowerIndex <= upperIndex) {
            int index = lowerIndex + (upperIndex - lowerIndex) / 2;
            V res = this.getAtIndex(codec, index, connection);
            int cmp = this.comparator.compare(value, res);
            if (cmp == 0) {
                BinarySearchResult indexRes = new BinarySearchResult();
                indexRes.setIndex(index);
                return indexRes;
            }
            if (cmp < 0) {
                upperIndex = index - 1;
                continue;
            }
            lowerIndex = index + 1;
        }
        BinarySearchResult indexRes = new BinarySearchResult();
        indexRes.setIndex(-(lowerIndex + 1));
        return indexRes;
    }

    public BinarySearchResult<V> binarySearch(V value, Codec codec, RedisConnection connection) {
        int upperIndex = this.size(connection) - 1;
        return this.binarySearch(value, codec, connection, 0, upperIndex);
    }

    double score(V value, RedisConnection connection, int indexDiff, boolean tail) {
        return -1.0;
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static class BinarySearchResult<V> {
        private V value;
        private int index;

        public BinarySearchResult(V value) {
            this.value = value;
        }

        public BinarySearchResult() {
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public V getValue() {
            return this.value;
        }
    }

    private static class NaturalComparator<V>
    implements Comparator<V>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;
        static final NaturalComparator NATURAL_ORDER = new NaturalComparator();

        private NaturalComparator() {
        }

        @Override
        public int compare(V c1, V c2) {
            Comparable c1co = (Comparable)c1;
            Comparable c2co = (Comparable)c2;
            return c1co.compareTo(c2co);
        }
    }
}

