/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.redisson.CommandExecutor;
import org.redisson.RedissonExpirable;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.core.RSet;

public class RedissonSet<V>
extends RedissonExpirable
implements RSet<V> {
    protected RedissonSet(CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public Future<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.SCARD, this.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public Future<Boolean> containsAsync(Object o) {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.SISMEMBER, this.getName(), o);
    }

    private ListScanResult<V> scanIterator(RedisClient client, long startPos) {
        return (ListScanResult)this.commandExecutor.read(client, this.getName(), RedisCommands.SSCAN, this.getName(), startPos);
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private Iterator<V> iter;
            private RedisClient client;
            private Long iterPos;
            private boolean removeExecuted;
            private V value;

            @Override
            public boolean hasNext() {
                if (this.iter == null) {
                    ListScanResult res = RedissonSet.this.scanIterator(null, 0L);
                    this.client = res.getRedisClient();
                    this.iter = res.getValues().iterator();
                    this.iterPos = res.getPos();
                } else if (!this.iter.hasNext() && this.iterPos != 0L) {
                    ListScanResult res = RedissonSet.this.scanIterator(this.client, this.iterPos);
                    this.iter = res.getValues().iterator();
                    this.iterPos = res.getPos();
                }
                return this.iter.hasNext();
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index");
                }
                this.value = this.iter.next();
                this.removeExecuted = false;
                return this.value;
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                this.iter.remove();
                RedissonSet.this.remove(this.value);
                this.removeExecuted = true;
            }
        };
    }

    @Override
    public Future<Collection<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.SMEMBERS, this.getName());
    }

    @Override
    public Object[] toArray() {
        List res = (List)this.get(this.readAllAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List res = (List)this.get(this.readAllAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public Future<Boolean> addAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.SADD_SINGLE, this.getName(), e);
    }

    @Override
    public V removeRandom() {
        return this.get(this.removeRandomAsync());
    }

    @Override
    public Future<V> removeRandomAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.SPOP_SINGLE, this.getName());
    }

    @Override
    public Future<Boolean> removeAsync(Object o) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.SREM_SINGLE, this.getName(), o);
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public Future<Boolean> containsAllAsync(Collection<?> c) {
        return this.commandExecutor.evalReadAsync(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4), "local s = redis.call('smembers', KEYS[1]);for i = 0, table.getn(s), 1 do for j = 0, table.getn(ARGV), 1 do if ARGV[j] == s[i] then table.remove(ARGV, j) end end; end;return table.getn(ARGV) == 0; ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return false;
        }
        return this.get(this.addAllAsync(c));
    }

    @Override
    public Future<Boolean> addAllAsync(Collection<? extends V> c) {
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.SADD, args.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public Future<Boolean> retainAllAsync(Collection<?> c) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4), "local changed = false local s = redis.call('smembers', KEYS[1]) local i = 0 while i <= table.getn(s) do local element = s[i] local isInAgrs = false for j = 0, table.getn(ARGV), 1 do if ARGV[j] == element then isInAgrs = true break end end if isInAgrs == false then redis.call('SREM', KEYS[1], element) changed = true end i = i + 1 end return changed ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public Future<Boolean> removeAllAsync(Collection<?> c) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4), "local v = false for i = 0, table.getn(ARGV), 1 do if redis.call('srem', KEYS[1], ARGV[i]) == 1 then v = true end end return v ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public void clear() {
        this.delete();
    }
}

