/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.NoSuchElementException;
import org.redisson.CommandExecutor;
import org.redisson.RedissonList;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.core.RQueue;

public class RedissonQueue<V>
extends RedissonList<V>
implements RQueue<V> {
    protected RedissonQueue(CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public boolean offer(V e) {
        return this.add(e);
    }

    @Override
    public Future<Boolean> offerAsync(V e) {
        return this.addAsync(e);
    }

    @Override
    public V getFirst() {
        Object value = this.getValue(0);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V removeFirst() {
        V value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V remove() {
        return this.removeFirst();
    }

    @Override
    public Future<V> pollAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.LPOP, this.getName());
    }

    @Override
    public V poll() {
        return this.get(this.pollAsync());
    }

    @Override
    public V element() {
        return this.getFirst();
    }

    @Override
    public Future<V> peekAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peek() {
        return this.getValue(0);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName) {
        return this.get(this.pollLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public Future<V> pollLastAndOfferFirstToAsync(String queueName) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.RPOPLPUSH, this.getName(), queueName);
    }

    @Override
    public Future<V> pollLastAndOfferFirstToAsync(RQueue<V> queue) {
        return this.pollLastAndOfferFirstToAsync(queue.getName());
    }

    @Override
    public V pollLastAndOfferFirstTo(RQueue<V> queue) {
        return this.pollLastAndOfferFirstTo(queue.getName());
    }
}

