/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import java.util.List;
import org.redisson.CommandExecutor;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.PubSubPatternStatusListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.connection.PubSubConnectionEntry;
import org.redisson.core.PatternMessageListener;
import org.redisson.core.PatternStatusListener;
import org.redisson.core.RPatternTopic;

public class RedissonPatternTopic<M>
implements RPatternTopic<M> {
    final CommandExecutor commandExecutor;
    private final String name;

    protected RedissonPatternTopic(CommandExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
    }

    @Override
    public int addListener(PatternStatusListener listener) {
        return this.addListener(new PubSubPatternStatusListener(listener, this.name));
    }

    @Override
    public int addListener(PatternMessageListener<M> listener) {
        PubSubPatternMessageListener<M> pubSubListener = new PubSubPatternMessageListener<M>(listener, this.name);
        return this.addListener(pubSubListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private int addListener(RedisPubSubListener<M> pubSubListener) {
        PubSubConnectionEntry entry;
        PubSubConnectionEntry pubSubConnectionEntry = entry = this.commandExecutor.getConnectionManager().psubscribe(this.name);
        synchronized (pubSubConnectionEntry) {
            if (entry.isActive()) {
                entry.addListener(this.name, pubSubListener);
                return pubSubListener.hashCode();
            }
        }
        return this.addListener(pubSubListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(int listenerId) {
        PubSubConnectionEntry entry = this.commandExecutor.getConnectionManager().getEntry(this.name);
        if (entry == null) {
            return;
        }
        PubSubConnectionEntry pubSubConnectionEntry = entry;
        synchronized (pubSubConnectionEntry) {
            if (entry.isActive()) {
                entry.removeListener(this.name, listenerId);
                if (entry.getListeners(this.name).isEmpty()) {
                    this.commandExecutor.getConnectionManager().punsubscribe(this.name);
                }
                return;
            }
        }
        this.removeListener(listenerId);
    }

    @Override
    public List<String> getPatternNames() {
        return Collections.singletonList(this.name);
    }
}

