/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import org.redisson.CommandExecutor;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.core.RObject;

abstract class RedissonObject
implements RObject {
    final CommandExecutor commandExecutor;
    private final String name;

    public RedissonObject(CommandExecutor commandExecutor, String name) {
        this.commandExecutor = commandExecutor;
        this.name = name;
    }

    protected <V> V get(Future<V> future) {
        return this.commandExecutor.get(future);
    }

    protected <V> Promise<V> newPromise() {
        return this.commandExecutor.getConnectionManager().getGroup().next().newPromise();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void rename(String newName) {
        this.get(this.renameAsync(newName));
    }

    @Override
    public Future<Void> renameAsync(String newName) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.RENAME, this.getName(), newName);
    }

    @Override
    public void migrate(String host, int port, int database) {
        this.get(this.migrateAsync(host, port, database));
    }

    @Override
    public Future<Void> migrateAsync(String host, int port, int database) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.MIGRATE, host, port, this.getName(), database);
    }

    @Override
    public boolean move(int database) {
        return this.get(this.moveAsync(database));
    }

    @Override
    public Future<Boolean> moveAsync(int database) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.MOVE, this.getName(), database);
    }

    @Override
    public boolean renamenx(String newName) {
        return this.get(this.renamenxAsync(newName));
    }

    @Override
    public Future<Boolean> renamenxAsync(String newName) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.RENAMENX, this.getName(), newName);
    }

    @Override
    public boolean delete() {
        return this.get(this.deleteAsync());
    }

    @Override
    public Future<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_SINGLE, this.getName());
    }
}

