/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.redisson.CommandExecutor;
import org.redisson.RedissonExpirable;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.LongReplayConvertor;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.core.Predicate;
import org.redisson.core.RMap;

public class RedissonMap<K, V>
extends RedissonExpirable
implements RMap<K, V> {
    private final RedisCommand<Object> EVAL_PUT = new RedisCommand("EVAL", 4, RedisCommand.ValueType.MAP, RedisCommand.ValueType.MAP_VALUE);

    protected RedissonMap(CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public Future<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.HLEN, this.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return (Boolean)this.commandExecutor.read(this.getName(), RedisCommands.HEXISTS, this.getName(), key);
    }

    @Override
    public Future<Boolean> containsKeyAsync(Object key) {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.HEXISTS, this.getName(), key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.get(this.containsValueAsync(value));
    }

    @Override
    public Future<Boolean> containsValueAsync(Object value) {
        return this.commandExecutor.evalReadAsync(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4), "local s = redis.call('hvals', KEYS[1]);for i = 0, table.getn(s), 1 do if ARGV[1] == s[i] then return true end end;return false", Collections.singletonList(this.getName()), value);
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        if (keys.size() == 0) {
            return Collections.emptyMap();
        }
        ArrayList<String> args = new ArrayList<String>(keys.size() + 1);
        args.add(this.getName());
        args.addAll(keys);
        List list = (List)this.commandExecutor.read(this.getName(), RedisCommands.HMGET, args.toArray());
        HashMap result = new HashMap(list.size());
        for (int index = 0; index < args.size() - 1; ++index) {
            Object value = list.get(index);
            if (value == null) continue;
            result.put(args.get(index + 1), value);
        }
        return result;
    }

    @Override
    public V get(Object key) {
        return this.get(this.getAsync(key));
    }

    @Override
    public V put(K key, V value) {
        return this.get(this.putAsync(key, value));
    }

    @Override
    public V remove(Object key) {
        return this.get(this.removeAsync(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map.size() == 0) {
            return;
        }
        this.commandExecutor.write(this.getName(), RedisCommands.HMSET, this.getName(), map);
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Set<K> keySet() {
        return this.get(this.keySetAsync());
    }

    @Override
    public Future<Set<K>> keySetAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.HKEYS, this.getName());
    }

    @Override
    public Collection<V> values() {
        return this.get(this.valuesAsync());
    }

    @Override
    public Future<Collection<V>> valuesAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.HVALS, this.getName());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map map = (Map)this.commandExecutor.read(this.getName(), RedisCommands.HGETALL, this.getName());
        return map.entrySet();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.get(this.putIfAbsentAsync(key, value));
    }

    @Override
    public Future<V> putIfAbsentAsync(K key, V value) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.EVAL_PUT, "if redis.call('hexists', KEYS[1], ARGV[1]) == 0 then redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return nil else return redis.call('hget', KEYS[1], ARGV[1]) end", Collections.singletonList(this.getName()), key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.get(this.removeAsync(key, value)) == 1L;
    }

    @Override
    public Future<Long> removeAsync(Object key, Object value) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand<Long>("EVAL", new LongReplayConvertor(), 4, RedisCommand.ValueType.MAP), "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then return redis.call('hdel', KEYS[1], ARGV[1]) else return 0 end", Collections.singletonList(this.getName()), key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.get(this.replaceAsync(key, oldValue, newValue));
    }

    @Override
    public Future<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4, Arrays.asList(RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE, RedisCommand.ValueType.MAP_VALUE)), "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('hset', KEYS[1], ARGV[1], ARGV[3]); return true; else return false; end", Collections.singletonList(this.getName()), key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.get(this.replaceAsync(key, value));
    }

    @Override
    public Future<V> replaceAsync(K key, V value) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand("EVAL", 4, RedisCommand.ValueType.MAP, RedisCommand.ValueType.MAP_VALUE), "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return v; else return nil; end", Collections.singletonList(this.getName()), key, value);
    }

    @Override
    public Future<V> getAsync(K key) {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.HGET, this.getName(), key);
    }

    @Override
    public Future<V> putAsync(K key, V value) {
        return this.commandExecutor.evalWriteAsync(this.getName(), this.EVAL_PUT, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(this.getName()), key, value);
    }

    @Override
    public Future<V> removeAsync(K key) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand("EVAL", 4, RedisCommand.ValueType.MAP_KEY, RedisCommand.ValueType.MAP_VALUE), "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hdel', KEYS[1], ARGV[1]); return v", Collections.singletonList(this.getName()), key);
    }

    @Override
    public Future<Boolean> fastPutAsync(K key, V value) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.HSET, this.getName(), key, value);
    }

    @Override
    public boolean fastPut(K key, V value) {
        return this.get(this.fastPutAsync(key, value));
    }

    @Override
    public Future<Long> fastRemoveAsync(K ... keys) {
        if (keys == null || keys.length == 0) {
            return this.commandExecutor.getConnectionManager().getGroup().next().newSucceededFuture((Object)0L);
        }
        ArrayList<String> args = new ArrayList<String>(keys.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(keys));
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.HDEL, args.toArray());
    }

    @Override
    public long fastRemove(K ... keys) {
        return this.get(this.fastRemoveAsync(keys));
    }

    private MapScanResult<Object, V> scanIterator(RedisClient client, long startPos) {
        return (MapScanResult)this.commandExecutor.read(client, this.getName(), RedisCommands.HSCAN, this.getName(), startPos);
    }

    private Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(){
            private Iterator<Map.Entry<K, V>> iter;
            private long iterPos = 0L;
            private RedisClient client;
            private boolean removeExecuted;
            private Map.Entry<K, V> value;

            @Override
            public boolean hasNext() {
                if (this.iter == null || !this.iter.hasNext() && this.iterPos != 0L) {
                    MapScanResult res = RedissonMap.this.scanIterator(this.client, this.iterPos);
                    if (this.iter == null) {
                        this.client = res.getRedisClient();
                    }
                    this.iter = res.getMap().entrySet().iterator();
                    this.iterPos = res.getPos();
                }
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index");
                }
                this.value = this.iter.next();
                this.removeExecuted = false;
                return this.value;
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                this.hasNext();
                this.iter.remove();
                RedissonMap.this.fastRemove(this.value.getKey());
                this.removeExecuted = true;
            }
        };
    }

    @Override
    public Map<K, V> filterKeys(Predicate<K> predicate) {
        HashMap<K, V> result = new HashMap<K, V>();
        Iterator<Map.Entry<K, V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (!predicate.apply(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Map<K, V> filterValues(Predicate<V> predicate) {
        HashMap<K, V> result = new HashMap<K, V>();
        Iterator<Map.Entry<K, V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (!predicate.apply(entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Map<K, V> filterEntries(Predicate<Map.Entry<K, V>> predicate) {
        HashMap<K, V> result = new HashMap<K, V>();
        Iterator<Map.Entry<K, V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (!predicate.apply(entry)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public V addAndGet(K key, Number value) {
        return this.get(this.addAndGetAsync(key, value));
    }

    @Override
    public Future<V> addAndGetAsync(K key, Number value) {
        return this.commandExecutor.writeAsync(this.getName(), StringCodec.INSTANCE, new RedisCommand<Object>("HINCRBYFLOAT", new NumberConvertor(value.getClass())), this.getName(), key, new BigDecimal(value.toString()).toPlainString());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }
}

