/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Promise;
import java.util.concurrent.Semaphore;

public class RedissonLockEntry {
    private int counter;
    private final Semaphore latch;
    private final Promise<Boolean> promise;

    public RedissonLockEntry(RedissonLockEntry source) {
        this.counter = source.counter;
        this.latch = source.latch;
        this.promise = source.promise;
    }

    public RedissonLockEntry(Promise<Boolean> promise) {
        this.latch = new Semaphore(0);
        this.promise = promise;
    }

    public boolean isFree() {
        return this.counter == 0;
    }

    public void aquire() {
        ++this.counter;
    }

    public void release() {
        --this.counter;
    }

    public Promise<Boolean> getPromise() {
        return this.promise;
    }

    public Semaphore getLatch() {
        return this.latch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.counter;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RedissonLockEntry other = (RedissonLockEntry)obj;
        return this.counter == other.counter;
    }
}

