/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.CommandExecutor;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.core.RLock;

public class RedissonLock
extends RedissonExpirable
implements RLock {
    public static final long LOCK_EXPIRATION_INTERVAL_SECONDS = 30L;
    private static final ConcurrentMap<String, Timeout> refreshTaskMap = PlatformDependent.newConcurrentHashMap();
    protected long internalLockLeaseTime = TimeUnit.SECONDS.toMillis(30L);
    private final UUID id;
    private static final Integer unlockMessage = 0;
    private static final ConcurrentMap<String, RedissonLockEntry> ENTRIES = PlatformDependent.newConcurrentHashMap();

    protected RedissonLock(CommandExecutor commandExecutor, String name, UUID id) {
        super(commandExecutor, name);
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribe() {
        RedissonLockEntry newEntry;
        RedissonLockEntry entry;
        do {
            if ((entry = (RedissonLockEntry)ENTRIES.get(this.getEntryName())) == null) {
                return;
            }
            newEntry = new RedissonLockEntry(entry);
            newEntry.release();
        } while (!ENTRIES.replace(this.getEntryName(), entry, newEntry));
        if (newEntry.isFree() && ENTRIES.remove(this.getEntryName(), newEntry)) {
            ConcurrentMap<String, RedissonLockEntry> concurrentMap = ENTRIES;
            synchronized (concurrentMap) {
                if (!ENTRIES.containsKey(this.getEntryName())) {
                    this.commandExecutor.getConnectionManager().unsubscribe(this.getChannelName());
                }
            }
        }
    }

    private String getEntryName() {
        return this.id + ":" + this.getName();
    }

    private Promise<Boolean> aquire() {
        RedissonLockEntry newEntry;
        RedissonLockEntry entry;
        do {
            if ((entry = (RedissonLockEntry)ENTRIES.get(this.getEntryName())) == null) {
                return null;
            }
            newEntry = new RedissonLockEntry(entry);
            newEntry.aquire();
        } while (!ENTRIES.replace(this.getEntryName(), entry, newEntry));
        return newEntry.getPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Boolean> subscribe() {
        Promise<Boolean> promise = this.aquire();
        if (promise != null) {
            return promise;
        }
        Promise newPromise = this.newPromise();
        final RedissonLockEntry value = new RedissonLockEntry(newPromise);
        value.aquire();
        RedissonLockEntry oldValue = ENTRIES.putIfAbsent(this.getEntryName(), value);
        if (oldValue != null) {
            Promise<Boolean> oldPromise = this.aquire();
            if (oldPromise == null) {
                return this.subscribe();
            }
            return oldPromise;
        }
        BaseRedisPubSubListener<Integer> listener = new BaseRedisPubSubListener<Integer>(){

            @Override
            public void onMessage(String channel, Integer message) {
                if (message.equals(unlockMessage) && RedissonLock.this.getChannelName().equals(channel)) {
                    value.getLatch().release();
                }
            }

            @Override
            public boolean onStatus(PubSubType type, String channel) {
                if (channel.equals(RedissonLock.this.getChannelName()) && !value.getPromise().isSuccess()) {
                    value.getPromise().setSuccess((Object)true);
                    return true;
                }
                return false;
            }
        };
        ConcurrentMap<String, RedissonLockEntry> concurrentMap = ENTRIES;
        synchronized (concurrentMap) {
            this.commandExecutor.getConnectionManager().subscribe(listener, this.getChannelName());
        }
        return newPromise;
    }

    private String getChannelName() {
        return "redisson__lock__channel__{" + this.getName() + "}";
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        Long ttl = leaseTime != -1L ? this.tryLockInner(leaseTime, unit) : this.tryLockInner();
        if (ttl == null) {
            return;
        }
        this.subscribe().awaitUninterruptibly();
        try {
            while ((ttl = leaseTime != -1L ? this.tryLockInner(leaseTime, unit) : this.tryLockInner()) != null) {
                RedissonLockEntry entry = (RedissonLockEntry)ENTRIES.get(this.getEntryName());
                if (ttl >= 0L) {
                    entry.getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    continue;
                }
                entry.getLatch().acquire();
            }
        }
        finally {
            this.unsubscribe();
        }
    }

    @Override
    public boolean tryLock() {
        return this.tryLockInner() == null;
    }

    private Long tryLockInner() {
        Long ttlRemaining = this.tryLockInner(30L, TimeUnit.SECONDS);
        if (ttlRemaining == null) {
            this.newRefreshTask();
        }
        return ttlRemaining;
    }

    private void newRefreshTask() {
        if (refreshTaskMap.containsKey(this.getName())) {
            return;
        }
        Timeout task = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                RedissonLock.this.expire(RedissonLock.this.internalLockLeaseTime, TimeUnit.MILLISECONDS);
                refreshTaskMap.remove(RedissonLock.this.getName());
                RedissonLock.this.newRefreshTask();
            }
        }, this.internalLockLeaseTime / 3L, TimeUnit.MILLISECONDS);
        if (refreshTaskMap.putIfAbsent(this.getName(), task) != null) {
            task.cancel();
        }
    }

    private void stopRefreshTask() {
        Timeout task = (Timeout)refreshTaskMap.remove(this.getName());
        if (task != null) {
            task.cancel();
        }
    }

    private Long tryLockInner(long leaseTime, TimeUnit unit) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        return (Long)this.commandExecutor.evalWrite(this.getName(), RedisCommands.EVAL_INTEGER, "local v = redis.call('get', KEYS[1]); if (v == false) then   redis.call('set', KEYS[1], cjson.encode({['o'] = ARGV[1], ['c'] = 1}), 'px', ARGV[2]);   return nil; else   local o = cjson.decode(v);   if (o['o'] == ARGV[1]) then     o['c'] = o['c'] + 1; redis.call('set', KEYS[1], cjson.encode(o), 'px', ARGV[2]);     return nil;   end;  return redis.call('pttl', KEYS[1]); end", Collections.singletonList(this.getName()), this.id.toString() + "-" + Thread.currentThread().getId(), this.internalLockLeaseTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        Long ttl = leaseTime != -1L ? this.tryLockInner(leaseTime, unit) : this.tryLockInner();
        if (ttl == null) {
            return true;
        }
        if (!this.subscribe().awaitUninterruptibly(time, TimeUnit.MILLISECONDS)) {
            return false;
        }
        try {
            while ((ttl = leaseTime != -1L ? this.tryLockInner(leaseTime, unit) : this.tryLockInner()) != null) {
                if (time <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                long current = System.currentTimeMillis();
                RedissonLockEntry entry = (RedissonLockEntry)ENTRIES.get(this.getEntryName());
                if (ttl >= 0L && ttl < time) {
                    entry.getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                } else {
                    entry.getLatch().tryAcquire(time, TimeUnit.MILLISECONDS);
                }
                long elapsed = System.currentTimeMillis() - current;
                time -= elapsed;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unsubscribe();
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.tryLock(time, -1L, unit);
    }

    @Override
    public void unlock() {
        Boolean opStatus = (Boolean)this.commandExecutor.evalWrite(this.getName(), RedisCommands.EVAL_BOOLEAN, "local v = redis.call('get', KEYS[1]); if (v == false) then   redis.call('publish', ARGV[4], ARGV[2]);   return true; else   local o = cjson.decode(v);   if (o['o'] == ARGV[1]) then     o['c'] = o['c'] - 1;     if (o['c'] > 0) then       redis.call('set', KEYS[1], cjson.encode(o), 'px', ARGV[3]);       return false;    else       redis.call('del', KEYS[1]);      redis.call('publish', ARGV[4], ARGV[2]);       return true;    end  end;  return nil; end", Collections.singletonList(this.getName()), this.id.toString() + "-" + Thread.currentThread().getId(), unlockMessage, this.internalLockLeaseTime, this.getChannelName());
        if (opStatus == null) {
            throw new IllegalStateException("Can't unlock lock Current id: " + this.id + " thread-id: " + Thread.currentThread().getId());
        }
        if (opStatus.booleanValue()) {
            this.stopRefreshTask();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceUnlock() {
        this.get(this.forceUnlockAsync());
    }

    private Future<Boolean> forceUnlockAsync() {
        this.stopRefreshTask();
        return this.commandExecutor.evalWriteAsync(this.getName(), RedisCommands.EVAL_BOOLEAN, "redis.call('del', KEYS[1]); redis.call('publish', ARGV[2], ARGV[1]); return true", Collections.singletonList(this.getName()), unlockMessage, this.getChannelName());
    }

    @Override
    public boolean isLocked() {
        return (Boolean)this.commandExecutor.read(this.getName(), RedisCommands.EXISTS, this.getName());
    }

    @Override
    public boolean isHeldByCurrentThread() {
        Boolean opStatus = (Boolean)this.commandExecutor.evalRead(this.getName(), RedisCommands.EVAL_BOOLEAN, "local v = redis.call('get', KEYS[1]); if (v == false) then   return false; else   local o = cjson.decode(v);   if (o['o'] == ARGV[1]) then     return true;   else    return false;   end;end", Collections.singletonList(this.getName()), this.id.toString() + "-" + Thread.currentThread().getId());
        return opStatus;
    }

    @Override
    public int getHoldCount() {
        Long opStatus = (Long)this.commandExecutor.evalRead(this.getName(), RedisCommands.EVAL_INTEGER, "local v = redis.call('get', KEYS[1]); if (v == false) then   return 0; else   local o = cjson.decode(v);   return o['c']; end", Collections.singletonList(this.getName()), new Object[0]);
        return opStatus.intValue();
    }

    @Override
    public boolean delete() {
        this.forceUnlock();
        return true;
    }

    @Override
    public Future<Boolean> deleteAsync() {
        return this.forceUnlockAsync();
    }
}

