/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.redisson.CommandExecutor;
import org.redisson.RedissonExpirable;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.BooleanNumberReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.IntegerReplayConvertor;
import org.redisson.core.RList;

public class RedissonList<V>
extends RedissonExpirable
implements RList<V> {
    protected RedissonList(CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public Future<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.LLEN, this.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public Iterator<V> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        List<V> list = this.readAll();
        return list.toArray();
    }

    private List<V> readAll() {
        return (List)this.get(this.readAllAsync());
    }

    @Override
    public Future<Collection<V>> readAllAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.LRANGE, this.getName(), 0, -1);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<V> list = this.readAll();
        return list.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public Future<Boolean> addAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.RPUSH_BOOLEAN, this.getName(), e);
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(o, 1);
    }

    @Override
    public Future<Boolean> removeAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    protected Future<Boolean> removeAsync(Object o, int count) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.LREM_SINGLE, this.getName(), count, o);
    }

    protected boolean remove(Object o, int count) {
        return this.get(this.removeAsync(o, count));
    }

    @Override
    public Future<Boolean> containsAllAsync(Collection<?> c) {
        return this.commandExecutor.evalReadAsync(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4), "local items = redis.call('lrange', KEYS[1], 0, -1) for i=1, #items do for j = 0, table.getn(ARGV), 1 do if items[i] == ARGV[j] then table.remove(ARGV, j) end end end return table.getn(ARGV) == 0", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public Future<Boolean> addAllAsync(Collection<? extends V> c) {
        final Promise promise = this.newPromise();
        if (c.isEmpty()) {
            promise.setSuccess((Object)false);
            return promise;
        }
        final int listSize = this.size();
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        Future res = this.commandExecutor.writeAsync(this.getName(), RedisCommands.RPUSH, args.toArray());
        res.addListener((GenericFutureListener)new FutureListener<Long>(){

            public void operationComplete(Future<Long> future) throws Exception {
                if (future.isSuccess()) {
                    promise.setSuccess((Object)((long)listSize != (Long)future.getNow() ? 1 : 0));
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
        return promise;
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> coll) {
        this.checkPosition(index);
        if (coll.isEmpty()) {
            return false;
        }
        int size = this.size();
        if (index < size) {
            if (index == 0) {
                ArrayList<V> elements = new ArrayList<V>(coll);
                Collections.reverse(elements);
                elements.add(0, this.getName());
                Long newSize = (Long)this.commandExecutor.write(this.getName(), RedisCommands.LPUSH, elements.toArray());
                return newSize != (long)size;
            }
            ArrayList<Integer> args = new ArrayList<Integer>(coll.size() + 1);
            args.add(index);
            args.addAll(coll);
            return (Boolean)this.commandExecutor.evalWrite(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5), "local ind = table.remove(ARGV, 1); local tail = redis.call('lrange', KEYS[1], ind, -1); redis.call('ltrim', KEYS[1], 0, ind - 1); for i, v in ipairs(ARGV) do redis.call('rpush', KEYS[1], v) end;for i, v in ipairs(tail) do redis.call('rpush', KEYS[1], v) end;return true", Collections.singletonList(this.getName()), args.toArray());
        }
        return this.addAll((Collection<? extends V>)coll);
    }

    @Override
    public Future<Boolean> removeAllAsync(Collection<?> c) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4), "local v = false for i = 0, table.getn(ARGV), 1 do if redis.call('lrem', KEYS[1], 0, ARGV[i]) == 1 then v = true end end return v ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public Future<Boolean> retainAllAsync(Collection<?> c) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 4), "local changed = false local items = redis.call('lrange', KEYS[1], 0, -1) local i = 1 local s = table.getn(items) while i <= s do local element = items[i] local isInAgrs = false for j = 0, table.getn(ARGV), 1 do if ARGV[j] == element then isInAgrs = true break end end if isInAgrs == false then redis.call('LREM', KEYS[1], 0, element) changed = true end i = i + 1 end return changed ", Collections.singletonList(this.getName()), c.toArray());
    }

    @Override
    public void clear() {
        this.delete();
    }

    @Override
    public Future<V> getAsync(int index) {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.LINDEX, this.getName(), index);
    }

    @Override
    public V get(int index) {
        this.checkIndex(index);
        return this.getValue(index);
    }

    V getValue(int index) {
        return this.get(this.getAsync(index));
    }

    private void checkIndex(int index) {
        int size = this.size();
        if (!this.isInRange(index, size)) {
            throw new IndexOutOfBoundsException("index: " + index + " but current size: " + size);
        }
    }

    private boolean isInRange(int index, int size) {
        return index >= 0 && index < size;
    }

    private void checkPosition(int index) {
        int size = this.size();
        if (!this.isPositionInRange(index, size)) {
            throw new IndexOutOfBoundsException("index: " + index + " but current size: " + size);
        }
    }

    private boolean isPositionInRange(int index, int size) {
        return index >= 0 && index <= size;
    }

    @Override
    public V set(int index, V element) {
        this.checkIndex(index);
        return this.get(this.setAsync(index, element));
    }

    @Override
    public Future<V> setAsync(int index, V element) {
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand("EVAL", 5), "local v = redis.call('lindex', KEYS[1], ARGV[1]); redis.call('lset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(this.getName()), index, element);
    }

    @Override
    public void fastSet(int index, V element) {
        this.checkIndex(index);
        this.get(this.fastSetAsync(index, element));
    }

    @Override
    public Future<Void> fastSetAsync(int index, V element) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.LSET, this.getName(), index, element);
    }

    @Override
    public void add(int index, V element) {
        this.addAll(index, (Collection<? extends V>)Collections.singleton(element));
    }

    @Override
    public V remove(int index) {
        this.checkIndex(index);
        if (index == 0) {
            return (V)this.commandExecutor.write(this.getName(), RedisCommands.LPOP, this.getName());
        }
        return (V)this.commandExecutor.evalWrite(this.getName(), RedisCommands.EVAL_OBJECT, "local v = redis.call('lindex', KEYS[1], ARGV[1]); local tail = redis.call('lrange', KEYS[1], ARGV[1]);redis.call('ltrim', KEYS[1], 0, ARGV[1] - 1);for i, v in ipairs(tail) do redis.call('rpush', KEYS[1], v) end;return v", Collections.singletonList(this.getName()), index);
    }

    @Override
    public int indexOf(Object o) {
        return this.get(this.indexOfAsync(o));
    }

    @Override
    public Future<Boolean> containsAsync(Object o) {
        return this.indexOfAsync(o, new BooleanNumberReplayConvertor());
    }

    private <R> Future<R> indexOfAsync(Object o, Convertor<R> convertor) {
        return this.commandExecutor.evalReadAsync(this.getName(), new RedisCommand<R>("EVAL", convertor, 4), "local key = KEYS[1] local obj = ARGV[1] local items = redis.call('lrange', key, 0, -1) for i=1,#items do if items[i] == obj then return i - 1 end end return -1", Collections.singletonList(this.getName()), o);
    }

    @Override
    public Future<Integer> indexOfAsync(Object o) {
        return this.indexOfAsync(o, new IntegerReplayConvertor());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.get(this.lastIndexOfAsync(o));
    }

    @Override
    public Future<Integer> lastIndexOfAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(), new RedisCommand<Integer>("EVAL", new IntegerReplayConvertor(), 4), "local key = KEYS[1] local obj = ARGV[1] local items = redis.call('lrange', key, 0, -1) for i = table.getn(items), 0, -1 do if items[i] == obj then return i - 1 end end return -1", Collections.singletonList(this.getName()), o);
    }

    @Override
    public ListIterator<V> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<V> listIterator(final int ind) {
        return new ListIterator<V>(){
            private V prevCurrentValue;
            private V nextCurrentValue;
            private V currentValueHasRead;
            private int currentIndex;
            private boolean removeExecuted;
            {
                this.currentIndex = ind - 1;
            }

            @Override
            public boolean hasNext() {
                Object val = RedissonList.this.getValue(this.currentIndex + 1);
                if (val != null) {
                    this.nextCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V next() {
                if (this.nextCurrentValue == null && !this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                ++this.currentIndex;
                this.currentValueHasRead = this.nextCurrentValue;
                this.nextCurrentValue = null;
                this.removeExecuted = false;
                return this.currentValueHasRead;
            }

            @Override
            public void remove() {
                if (this.currentValueHasRead == null) {
                    throw new IllegalStateException("Neither next nor previous have been called");
                }
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonList.this.remove(this.currentValueHasRead);
                --this.currentIndex;
                this.removeExecuted = true;
                this.currentValueHasRead = null;
            }

            @Override
            public boolean hasPrevious() {
                if (this.currentIndex < 0) {
                    return false;
                }
                Object val = RedissonList.this.getValue(this.currentIndex);
                if (val != null) {
                    this.prevCurrentValue = val;
                }
                return val != null;
            }

            @Override
            public V previous() {
                if (this.prevCurrentValue == null && !this.hasPrevious()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                --this.currentIndex;
                this.removeExecuted = false;
                this.currentValueHasRead = this.prevCurrentValue;
                this.prevCurrentValue = null;
                return this.currentValueHasRead;
            }

            @Override
            public int nextIndex() {
                return this.currentIndex + 1;
            }

            @Override
            public int previousIndex() {
                return this.currentIndex;
            }

            @Override
            public void set(V e) {
                if (this.currentIndex >= RedissonList.this.size() - 1) {
                    throw new IllegalStateException();
                }
                RedissonList.this.set(this.currentIndex, e);
            }

            @Override
            public void add(V e) {
                RedissonList.this.add(this.currentIndex + 1, e);
                ++this.currentIndex;
            }
        };
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        int size = this.size();
        if (fromIndex < 0 || toIndex > size) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + " size: " + size);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        return (List)this.commandExecutor.read(this.getName(), RedisCommands.LRANGE, this.getName(), fromIndex, toIndex - 1);
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

