/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.CommandExecutor;
import org.redisson.SlotCallback;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.core.RKeys;
import org.redisson.misc.CompositeIterable;

public class RedissonKeys
implements RKeys {
    private final CommandExecutor commandExecutor;

    public RedissonKeys(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public Iterable<String> getKeysByPattern(final String pattern) {
        ArrayList iterables = new ArrayList();
        for (final Integer slot : this.commandExecutor.getConnectionManager().getEntries().keySet()) {
            Iterable<String> iterable = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return RedissonKeys.this.createKeysIterator(slot, pattern);
                }
            };
            iterables.add(iterable);
        }
        return new CompositeIterable<String>(iterables);
    }

    @Override
    public Iterable<String> getKeys() {
        ArrayList iterables = new ArrayList();
        for (final Integer slot : this.commandExecutor.getConnectionManager().getEntries().keySet()) {
            Iterable<String> iterable = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return RedissonKeys.this.createKeysIterator(slot, null);
                }
            };
            iterables.add(iterable);
        }
        return new CompositeIterable<String>(iterables);
    }

    private ListScanResult<String> scanIterator(int slot, long startPos, String pattern) {
        if (pattern == null) {
            return (ListScanResult)this.commandExecutor.write(slot, (Codec)StringCodec.INSTANCE, RedisCommands.SCAN, startPos);
        }
        return (ListScanResult)this.commandExecutor.write(slot, (Codec)StringCodec.INSTANCE, RedisCommands.SCAN, startPos, "MATCH", pattern);
    }

    private Iterator<String> createKeysIterator(final int slot, final String pattern) {
        return new Iterator<String>(){
            private Iterator<String> iter;
            private Long iterPos;
            private boolean removeExecuted;
            private String value;

            @Override
            public boolean hasNext() {
                if (this.iter == null) {
                    ListScanResult res = RedissonKeys.this.scanIterator(slot, 0L, pattern);
                    this.iter = res.getValues().iterator();
                    this.iterPos = res.getPos();
                } else if (!this.iter.hasNext() && this.iterPos != 0L) {
                    ListScanResult res = RedissonKeys.this.scanIterator(slot, this.iterPos, pattern);
                    this.iter = res.getValues().iterator();
                    this.iterPos = res.getPos();
                }
                return this.iter.hasNext();
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element");
                }
                this.value = this.iter.next();
                this.removeExecuted = false;
                return this.value;
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                this.iter.remove();
                RedissonKeys.this.delete(this.value);
                this.removeExecuted = true;
            }
        };
    }

    @Override
    public String randomKey() {
        return this.commandExecutor.get(this.randomKeyAsync());
    }

    @Override
    public Future<String> randomKeyAsync() {
        return this.commandExecutor.readRandomAsync(RedisCommands.RANDOM_KEY, new Object[0]);
    }

    @Override
    public Collection<String> findKeysByPattern(String pattern) {
        return this.commandExecutor.get(this.findKeysByPatternAsync(pattern));
    }

    @Override
    public Future<Collection<String>> findKeysByPatternAsync(String pattern) {
        return this.commandExecutor.readAllAsync(RedisCommands.KEYS, pattern);
    }

    @Override
    public long deleteByPattern(String pattern) {
        return this.commandExecutor.get(this.deleteByPatternAsync(pattern));
    }

    @Override
    public Future<Long> deleteByPatternAsync(String pattern) {
        return this.commandExecutor.evalWriteAllAsync(RedisCommands.EVAL_INTEGER, new SlotCallback<Long, Long>(){
            AtomicLong results = new AtomicLong();

            @Override
            public void onSlotResult(Long result) {
                this.results.addAndGet(result);
            }

            @Override
            public Long onFinish() {
                return this.results.get();
            }
        }, "local keys = redis.call('keys', ARGV[1]) local n = 0 for i=1, table.getn(keys),5000 do n = n + redis.call('del', unpack(keys, i, math.min(i+4999, table.getn(keys)))) end return n;", Collections.<Object>emptyList(), pattern);
    }

    @Override
    public long delete(String ... keys) {
        return this.commandExecutor.get(this.deleteAsync(keys));
    }

    @Override
    public Future<Long> deleteAsync(String ... keys) {
        return this.commandExecutor.writeAllAsync(RedisCommands.DEL, new SlotCallback<Long, Long>(){
            AtomicLong results = new AtomicLong();

            @Override
            public void onSlotResult(Long result) {
                this.results.addAndGet(result);
            }

            @Override
            public Long onFinish() {
                return this.results.get();
            }
        }, (Object[])keys);
    }
}

