/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.CommandExecutor;
import org.redisson.RedissonCountDownLatchEntry;
import org.redisson.RedissonObject;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.core.RCountDownLatch;

public class RedissonCountDownLatch
extends RedissonObject
implements RCountDownLatch {
    private static final Integer zeroCountMessage = 0;
    private static final Integer newCountMessage = 1;
    private static final ConcurrentMap<String, RedissonCountDownLatchEntry> ENTRIES = PlatformDependent.newConcurrentHashMap();
    private final UUID id;

    protected RedissonCountDownLatch(CommandExecutor commandExecutor, String name, UUID id) {
        super(commandExecutor, name);
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Boolean> subscribe() {
        Promise<Boolean> promise = this.aquire();
        if (promise != null) {
            return promise;
        }
        Promise newPromise = this.newPromise();
        final RedissonCountDownLatchEntry value = new RedissonCountDownLatchEntry(newPromise);
        value.aquire();
        RedissonCountDownLatchEntry oldValue = ENTRIES.putIfAbsent(this.getEntryName(), value);
        if (oldValue != null) {
            Promise<Boolean> oldPromise = this.aquire();
            if (oldPromise == null) {
                return this.subscribe();
            }
            return oldPromise;
        }
        BaseRedisPubSubListener<Integer> listener = new BaseRedisPubSubListener<Integer>(){

            @Override
            public void onMessage(String channel, Integer message) {
                if (!RedissonCountDownLatch.this.getChannelName().equals(channel)) {
                    return;
                }
                if (message.equals(zeroCountMessage)) {
                    value.getLatch().open();
                }
                if (message.equals(newCountMessage)) {
                    value.getLatch().close();
                }
            }

            @Override
            public boolean onStatus(PubSubType type, String channel) {
                if (channel.equals(RedissonCountDownLatch.this.getChannelName()) && !value.getPromise().isSuccess()) {
                    value.getPromise().setSuccess((Object)true);
                    return true;
                }
                return false;
            }
        };
        ConcurrentMap<String, RedissonCountDownLatchEntry> concurrentMap = ENTRIES;
        synchronized (concurrentMap) {
            this.commandExecutor.getConnectionManager().subscribe(listener, this.getChannelName());
        }
        return newPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribe() {
        RedissonCountDownLatchEntry newEntry;
        RedissonCountDownLatchEntry entry;
        do {
            if ((entry = (RedissonCountDownLatchEntry)ENTRIES.get(this.getEntryName())) == null) {
                return;
            }
            newEntry = new RedissonCountDownLatchEntry(entry);
            newEntry.release();
        } while (!ENTRIES.replace(this.getEntryName(), entry, newEntry));
        if (newEntry.isFree() && ENTRIES.remove(this.getEntryName(), newEntry)) {
            ConcurrentMap<String, RedissonCountDownLatchEntry> concurrentMap = ENTRIES;
            synchronized (concurrentMap) {
                if (!ENTRIES.containsKey(this.getEntryName())) {
                    this.commandExecutor.getConnectionManager().unsubscribe(this.getChannelName());
                }
            }
        }
    }

    private Promise<Boolean> aquire() {
        RedissonCountDownLatchEntry entry;
        while ((entry = (RedissonCountDownLatchEntry)ENTRIES.get(this.getEntryName())) != null) {
            RedissonCountDownLatchEntry newEntry = new RedissonCountDownLatchEntry(entry);
            newEntry.aquire();
            if (!ENTRIES.replace(this.getEntryName(), entry, newEntry)) continue;
            return newEntry.getPromise();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        Future<Boolean> promise = this.subscribe();
        try {
            promise.await();
            while (this.getCountInner() > 0L) {
                RedissonCountDownLatchEntry entry = (RedissonCountDownLatchEntry)ENTRIES.get(this.getEntryName());
                if (entry == null) continue;
                entry.getLatch().await();
            }
        }
        finally {
            this.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        Future<Boolean> promise = this.subscribe();
        try {
            if (!promise.await(time, unit)) {
                boolean bl = false;
                return bl;
            }
            time = unit.toMillis(time);
            while (this.getCountInner() > 0L) {
                if (time <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                long current = System.currentTimeMillis();
                RedissonCountDownLatchEntry entry = (RedissonCountDownLatchEntry)ENTRIES.get(this.getEntryName());
                if (entry != null) {
                    entry.getLatch().await(time, TimeUnit.MILLISECONDS);
                }
                long elapsed = System.currentTimeMillis() - current;
                time -= elapsed;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unsubscribe();
        }
    }

    @Override
    public void countDown() {
        if (this.getCount() <= 0L) {
            return;
        }
        this.commandExecutor.evalWrite(this.getName(), RedisCommands.EVAL_BOOLEAN, "local v = redis.call('decr', KEYS[1]);if v <= 0 then redis.call('del', KEYS[1]) end;if v == 0 then redis.call('publish', ARGV[2], ARGV[1]) end;return true", Collections.singletonList(this.getName()), zeroCountMessage, this.getChannelName());
    }

    private String getEntryName() {
        return this.id + this.getName();
    }

    private String getChannelName() {
        return "redisson_countdownlatch_{" + this.getName() + "}";
    }

    @Override
    public long getCount() {
        return this.getCountInner();
    }

    private long getCountInner() {
        Long val = (Long)this.commandExecutor.read(this.getName(), LongCodec.INSTANCE, RedisCommands.GET, this.getName());
        if (val == null) {
            return 0L;
        }
        return val;
    }

    @Override
    public boolean trySetCount(long count) {
        return (Boolean)this.commandExecutor.evalWrite(this.getName(), RedisCommands.EVAL_BOOLEAN, "if redis.call('exists', KEYS[1]) == 0 then redis.call('set', KEYS[1], ARGV[2]); redis.call('publish', ARGV[3], ARGV[1]); return true else return false end", Collections.singletonList(this.getName()), newCountMessage, count, this.getChannelName());
    }

    @Override
    public Future<Boolean> deleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), RedisCommands.EVAL_BOOLEAN, "if redis.call('del', KEYS[1]) == 1 then redis.call('publish', ARGV[2], ARGV[1]); return true else return false end", Collections.singletonList(this.getName()), newCountMessage, this.getChannelName());
    }
}

