/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.redisson.CommandExecutor;
import org.redisson.RedissonExpirable;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.core.RBucket;

public class RedissonBucket<V>
extends RedissonExpirable
implements RBucket<V> {
    protected RedissonBucket(CommandExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    @Override
    public V get() {
        return this.get(this.getAsync());
    }

    @Override
    public Future<V> getAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.GET, this.getName());
    }

    @Override
    public void set(V value) {
        this.get(this.setAsync(value));
    }

    @Override
    public Future<Void> setAsync(V value) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.SET, this.getName(), value);
    }

    @Override
    public void set(V value, long timeToLive, TimeUnit timeUnit) {
        this.get(this.setAsync(value, timeToLive, timeUnit));
    }

    @Override
    public Future<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.SETEX, this.getName(), timeUnit.toSeconds(timeToLive), value);
    }

    @Override
    public boolean exists() {
        return this.get(this.existsAsync());
    }

    @Override
    public Future<Boolean> existsAsync() {
        return this.commandExecutor.readAsync(this.getName(), RedisCommands.EXISTS, this.getName());
    }
}

