/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.redisson.CommandExecutor;
import org.redisson.RedissonQueue;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.core.RBlockingQueue;

public class RedissonBlockingQueue<V>
extends RedissonQueue<V>
implements RBlockingQueue<V> {
    protected RedissonBlockingQueue(CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public Future<Boolean> putAsync(V e) {
        return this.offerAsync(e);
    }

    @Override
    public void put(V e) throws InterruptedException {
        this.offer(e);
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public Future<V> takeAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.BLPOP_VALUE, this.getName(), 0);
    }

    @Override
    public V take() throws InterruptedException {
        Future<V> res = this.takeAsync();
        return (V)res.await().getNow();
    }

    @Override
    public Future<V> pollAsync(long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.BLPOP_VALUE, this.getName(), unit.toSeconds(timeout));
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        Future<V> res = this.pollAsync(timeout, unit);
        return (V)res.await().getNow();
    }

    @Override
    public V pollLastAndOfferFirstTo(RBlockingQueue<V> queue, long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollLastAndOfferFirstTo(queue.getName(), timeout, unit);
    }

    @Override
    public Future<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.BRPOPLPUSH, this.getName(), queueName, unit.toSeconds(timeout));
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        Future<V> res = this.pollLastAndOfferFirstToAsync(queueName, timeout, unit);
        return (V)res.await().getNow();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public Future<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('ltrim', KEYS[1], -1, 0); return vals", Collections.singletonList(this.getName()), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public Future<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); return vals", Collections.singletonList(this.getName()), maxElements);
    }
}

