/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.Collections;
import org.redisson.CommandExecutor;
import org.redisson.RedissonExpirable;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.core.RAtomicLong;

public class RedissonAtomicLong
extends RedissonExpirable
implements RAtomicLong {
    protected RedissonAtomicLong(CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public long addAndGet(long delta) {
        return this.get(this.addAndGetAsync(delta));
    }

    @Override
    public Future<Long> addAndGetAsync(long delta) {
        return this.commandExecutor.writeAsync(this.getName(), StringCodec.INSTANCE, RedisCommands.INCRBY, this.getName(), delta);
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public Future<Boolean> compareAndSetAsync(long expect, long update) {
        return this.commandExecutor.evalWriteAsync(this.getName(), StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return true else return false end", Collections.singletonList(this.getName()), expect, update);
    }

    @Override
    public long decrementAndGet() {
        return this.get(this.decrementAndGetAsync());
    }

    @Override
    public Future<Long> decrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getName(), StringCodec.INSTANCE, RedisCommands.DECR, this.getName());
    }

    @Override
    public long get() {
        return this.addAndGet(0L);
    }

    @Override
    public Future<Long> getAsync() {
        return this.addAndGetAsync(0L);
    }

    @Override
    public long getAndAdd(long delta) {
        return this.get(this.getAndAddAsync(delta));
    }

    @Override
    public Future<Long> getAndAddAsync(long delta) {
        return this.commandExecutor.evalWriteAsync(this.getName(), StringCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local v = redis.call('get', KEYS[1]) or 0; redis.call('set', KEYS[1], v + ARGV[1]); return tonumber(v)", Collections.singletonList(this.getName()), delta);
    }

    @Override
    public long getAndSet(long newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public Future<Long> getAndSetAsync(long newValue) {
        return this.commandExecutor.evalWriteAsync(this.getName(), StringCodec.INSTANCE, RedisCommands.EVAL_INTEGER, "local v = redis.call('get', KEYS[1]) or 0; redis.call('set', KEYS[1], ARGV[1]); return tonumber(v)", Collections.singletonList(this.getName()), newValue);
    }

    @Override
    public long incrementAndGet() {
        return this.get(this.incrementAndGetAsync());
    }

    @Override
    public Future<Long> incrementAndGetAsync() {
        return this.commandExecutor.writeAsync(this.getName(), StringCodec.INSTANCE, RedisCommands.INCR, this.getName());
    }

    @Override
    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public Future<Long> getAndIncrementAsync() {
        return this.getAndAddAsync(1L);
    }

    @Override
    public long getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    @Override
    public Future<Long> getAndDecrementAsync() {
        return this.getAndAddAsync(-1L);
    }

    @Override
    public void set(long newValue) {
        this.get(this.setAsync(newValue));
    }

    @Override
    public Future<Void> setAsync(long newValue) {
        return this.commandExecutor.writeAsync(this.getName(), StringCodec.INSTANCE, RedisCommands.SET, this.getName(), newValue);
    }

    public String toString() {
        return Long.toString(this.get());
    }
}

