/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.CommandExecutor;
import org.redisson.CommandExecutorService;
import org.redisson.Config;
import org.redisson.RedisNodes;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBatch;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonClient;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonDeque;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonKeys;
import org.redisson.RedissonList;
import org.redisson.RedissonLock;
import org.redisson.RedissonMap;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonQueue;
import org.redisson.RedissonScript;
import org.redisson.RedissonSet;
import org.redisson.RedissonSortedSet;
import org.redisson.RedissonTopic;
import org.redisson.SlotCallback;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ClusterConnectionManager;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.SentinelConnectionManager;
import org.redisson.connection.SingleConnectionManager;
import org.redisson.core.ClusterNode;
import org.redisson.core.Node;
import org.redisson.core.NodesGroup;
import org.redisson.core.RAtomicLong;
import org.redisson.core.RBatch;
import org.redisson.core.RBlockingQueue;
import org.redisson.core.RBucket;
import org.redisson.core.RCountDownLatch;
import org.redisson.core.RDeque;
import org.redisson.core.RHyperLogLog;
import org.redisson.core.RKeys;
import org.redisson.core.RList;
import org.redisson.core.RLock;
import org.redisson.core.RMap;
import org.redisson.core.RPatternTopic;
import org.redisson.core.RQueue;
import org.redisson.core.RScript;
import org.redisson.core.RSet;
import org.redisson.core.RSortedSet;
import org.redisson.core.RTopic;

public class Redisson
implements RedissonClient {
    private final CommandExecutor commandExecutor;
    private final ConnectionManager connectionManager;
    private final Config config;
    private final UUID id = UUID.randomUUID();

    Redisson(Config config) {
        this.config = config;
        Config configCopy = new Config(config);
        if (configCopy.getMasterSlaveServersConfig() != null) {
            this.connectionManager = new MasterSlaveConnectionManager(configCopy.getMasterSlaveServersConfig(), configCopy);
        } else if (configCopy.getSingleServerConfig() != null) {
            this.connectionManager = new SingleConnectionManager(configCopy.getSingleServerConfig(), configCopy);
        } else if (configCopy.getSentinelServersConfig() != null) {
            this.connectionManager = new SentinelConnectionManager(configCopy.getSentinelServersConfig(), configCopy);
        } else if (configCopy.getClusterServersConfig() != null) {
            this.connectionManager = new ClusterConnectionManager(configCopy.getClusterServersConfig(), configCopy);
        } else {
            throw new IllegalArgumentException("server(s) address(es) not defined!");
        }
        this.commandExecutor = new CommandExecutorService(this.connectionManager);
    }

    public static Redisson create() {
        Config config = new Config();
        config.useSingleServer().setAddress("127.0.0.1:6379");
        return Redisson.create(config);
    }

    public static Redisson create(Config config) {
        return new Redisson(config);
    }

    @Override
    public <V> RBucket<V> getBucket(String name) {
        return new RedissonBucket(this.commandExecutor, name);
    }

    @Override
    public <V> List<RBucket<V>> getBuckets(String pattern) {
        Future r = this.commandExecutor.readAllAsync(RedisCommands.KEYS, pattern);
        Collection keys = this.commandExecutor.get(r);
        ArrayList<RBucket<V>> buckets = new ArrayList<RBucket<V>>(keys.size());
        for (Object key : keys) {
            if (key == null) continue;
            buckets.add(this.getBucket(key.toString()));
        }
        return buckets;
    }

    @Override
    public <V> RHyperLogLog<V> getHyperLogLog(String name) {
        return new RedissonHyperLogLog(this.commandExecutor, name);
    }

    @Override
    public <V> RList<V> getList(String name) {
        return new RedissonList(this.commandExecutor, name);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name) {
        return new RedissonMap(this.commandExecutor, name);
    }

    @Override
    public RLock getLock(String name) {
        return new RedissonLock(this.commandExecutor, name, this.id);
    }

    @Override
    public <V> RSet<V> getSet(String name) {
        return new RedissonSet(this.commandExecutor, name);
    }

    @Override
    public RScript getScript() {
        return new RedissonScript(this.commandExecutor);
    }

    @Override
    public <V> RSortedSet<V> getSortedSet(String name) {
        return new RedissonSortedSet(this.commandExecutor, name);
    }

    @Override
    public <M> RTopic<M> getTopic(String name) {
        return new RedissonTopic(this.commandExecutor, name);
    }

    @Override
    public <M> RPatternTopic<M> getPatternTopic(String pattern) {
        return new RedissonPatternTopic(this.commandExecutor, pattern);
    }

    @Override
    public <V> RQueue<V> getQueue(String name) {
        return new RedissonQueue(this.commandExecutor, name);
    }

    @Override
    public <V> RBlockingQueue<V> getBlockingQueue(String name) {
        return new RedissonBlockingQueue(this.commandExecutor, name);
    }

    @Override
    public <V> RDeque<V> getDeque(String name) {
        return new RedissonDeque(this.commandExecutor, name);
    }

    @Override
    public RAtomicLong getAtomicLong(String name) {
        return new RedissonAtomicLong(this.commandExecutor, name);
    }

    @Override
    public RCountDownLatch getCountDownLatch(String name) {
        return new RedissonCountDownLatch(this.commandExecutor, name, this.id);
    }

    @Override
    public RKeys getKeys() {
        return new RedissonKeys(this.commandExecutor);
    }

    @Override
    public void shutdown() {
        this.connectionManager.shutdown();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Collection<String> findKeysByPattern(String pattern) {
        return this.commandExecutor.get(this.findKeysByPatternAsync(pattern));
    }

    @Override
    public Future<Collection<String>> findKeysByPatternAsync(String pattern) {
        return this.commandExecutor.readAllAsync(RedisCommands.KEYS, pattern);
    }

    @Override
    public long deleteByPattern(String pattern) {
        return this.commandExecutor.get(this.deleteByPatternAsync(pattern));
    }

    @Override
    public Future<Long> deleteByPatternAsync(String pattern) {
        return this.commandExecutor.evalWriteAllAsync(RedisCommands.EVAL_INTEGER, new SlotCallback<Long, Long>(){
            AtomicLong results = new AtomicLong();

            @Override
            public void onSlotResult(Long result) {
                this.results.addAndGet(result);
            }

            @Override
            public Long onFinish() {
                return this.results.get();
            }
        }, "local keys = redis.call('keys', ARGV[1]) local n = 0 for i=1, table.getn(keys),5000 do n = n + redis.call('del', unpack(keys, i, math.min(i+4999, table.getn(keys)))) end return n;", Collections.<Object>emptyList(), pattern);
    }

    @Override
    @Deprecated
    public long delete(String ... keys) {
        return this.commandExecutor.get(this.deleteAsync(keys));
    }

    @Override
    @Deprecated
    public Future<Long> deleteAsync(String ... keys) {
        return this.commandExecutor.writeAllAsync(RedisCommands.DEL, new SlotCallback<Long, Long>(){
            AtomicLong results = new AtomicLong();

            @Override
            public void onSlotResult(Long result) {
                this.results.addAndGet(result);
            }

            @Override
            public Long onFinish() {
                return this.results.get();
            }
        }, (Object[])keys);
    }

    @Override
    public NodesGroup<Node> getNodesGroup() {
        return new RedisNodes<Node>(this.connectionManager);
    }

    @Override
    public NodesGroup<ClusterNode> getClusterNodesGroup() {
        if (!this.config.isClusterConfig()) {
            throw new IllegalStateException("Redisson not in cluster mode!");
        }
        return new RedisNodes<ClusterNode>(this.connectionManager);
    }

    @Override
    public void flushdb() {
        this.commandExecutor.get(this.commandExecutor.writeAllAsync(RedisCommands.FLUSHDB, new Object[0]));
    }

    @Override
    public void flushall() {
        this.commandExecutor.get(this.commandExecutor.writeAllAsync(RedisCommands.FLUSHALL, new Object[0]));
    }

    @Override
    public RBatch createBatch() {
        return new RedissonBatch(this.connectionManager);
    }
}

